<?php

namespace App\Console\Commands;

use App\Mail\ActivationUserOfferRequestMail;
use App\Models\NotificationLog;
use App\Models\Post;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;

class CheckUserOfferRequest extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'tender:offerrequest';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check if validated user not offered yet every 6 hours';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }
    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $posts = Post::with('users', 'offers')->where('tender_status', '1')->get();

        foreach ($posts as $post) {
            if($post->users->count() > 0) {
                foreach ($post->users as $user) {
                   $diffInHours = Carbon::parse($user->pivot->created_at)->diffInHours(Carbon::now());

                   if(!in_array($user->id, $post->offers->pluck('user_id')->toArray()) && $diffInHours > 5) {
                        $notificationLogType = 'mail';
                        $notificationLogName = 'Mail - İhale izni olup teklif yapmamış kullanıcılara hatırlatma'; //ActivationUserOfferRequestMail
                        NotificationLog::createNotificationLog(Post::where('id', '=', $post->id)->first(), $user, $notificationLogType, $notificationLogName, NULL);

                        Mail::to($user->email)->queue(
                            new ActivationUserOfferRequestMail($user, Post::where('id', '=', $post->id)->first())
                        );

                        $notificationLogType = 'sms';
                        $notificationLogName = 'SMS - İhale izni olup teklif yapmamış kullanıcılara hatırlatma'; //ActivationUserOfferRequestSMS
                        $notificationLogDesc = str_replace('%20', ' ', ActivationUserOfferRequestSMS($user, Post::where('id', '=', $post->id)->first()));
                        NotificationLog::createNotificationLog($post, $user, $notificationLogType, $notificationLogName, $notificationLogDesc);
                
                        sendSms($user, ActivationUserOfferRequestSMS($user, Post::where('id', '=', $post->id)->first()));
                   }
                }
            }
        }

        $this->info('Offer requests has been checked successfully.');
    }
}