<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\City;
use App\Models\District;
use App\Models\Neighborhood;

class AddressController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
    }
    
    public function getDistricts($id) {

        $districts = City::where('id', $id)->get()->first()->district()->pluck('name', 'id');


        $districtsArray = [];

        foreach ($districts as $key => $value) {
            $districtsArray[] = array('id'=> $key, 'text' => $value);
        }  
        // dd($districtsArray);

        return response()->json($districtsArray); 
    }

    
    public function getNeighborhoods($id) {
        
        $neighborhoods = District::where('id', $id)->get()->first()->neighborhood()->pluck('name', 'id');

        $neighborhoodsArray = [];
        foreach ($neighborhoods as $key => $value) {
            $neighborhoodsArray[] = array('id'=> $key, 'text' => $value);
        }  
        
        return response()->json($neighborhoodsArray);
    }
}
