<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Bank;
use App\Models\NotificationLog;
use App\Models\Post;
use App\Models\ArchiveFile;
use ZipArchive;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('admin');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        //sergilenen postların en çok görünen 5 tanesi

        $posts = Post::where('tender_status', 1)->withCount('postsViews')->orderBy('posts_views_count','desc')->take(5)->get();

        // dd($posts);

        return view('admin.index', compact('posts'));
    }

    public function ajaxInput($id)
    {
        $banks = Bank::all();


        if ($id == 0) {
            $view = view("admin.properties.properties1", compact('banks'))->render();
            return response()->json(['html'=>$view]);
        }

        if ($id == 1) {
            $view = view("admin.properties.properties2", compact('banks'))->render();
            return response()->json(['html'=>$view]);
        }

        if ($id == 2) {
            $view = view("admin.properties.properties3", compact('banks'))->render();
            return response()->json(['html'=>$view]);
        }

    }

        public function smsMailLogs() {
        $logs = NotificationLog::with('user', 'post')->get();
        
        return view('laravel-log-viewer::mail-sms-logs', compact('logs'));
    }

    public function logMailView($log) {

        $notificationLog = NotificationLog::with('user', 'post')->where('id', $log)->first();
        // dd($notificationLog);
        $markdown = new \Illuminate\Mail\Markdown(view(), config('mail.markdown'));   

        switch ($notificationLog->name) {
            case 'Mail - Yeni Kullanıcı kayıt bildirimi':
                return $markdown->render('mail.user-register-mail', ['user' => $notificationLog->user]);                        
                break;
            case 'Mail - Kullanıcı ihale katılım talebi bildirimi':
                return $markdown->render('mail.tender-user-permission-mail', [
                    'user' => $notificationLog->user,
                    'post' => $notificationLog->post,
                    'bank' => $notificationLog->post->bank
                ]);                        
                break;
            case 'Mail - Kullanıcı ihale teklif verme izin bildirimi':
                return $markdown->render('mail.tender-user-permission-activation-mail', [
                    'user' => $notificationLog->user,
                    'post' => $notificationLog->post,
                ]);                        
                break;
            case 'Mail - İhale daha yüksek teklif hatırlatma':
                return $markdown->render('mail.higher-offer-mail', [
                    'user' => $notificationLog->user,
                    'post' => $notificationLog->post,
                ]);                        
                break;
            case 'Mail - Kullanıcı ihale sonucu kaybetti bildirimi':
                return $markdown->render('mail.tender-loser-mail', [
                    'user' => $notificationLog->user,
                    'post' => $notificationLog->post,
                ]);                        
                break;
            case 'Mail - Kullanıcı ihale sonucu kazandı bildirimi':
                return $markdown->render('mail.tender-winner-mail', [
                    'user' => $notificationLog->user,
                    'post' => $notificationLog->post,
                ]);                        
                break;
            case 'Mail - İhale izni olup teklif yapmamış kullanıcılara hatırlatma':
                return $markdown->render('mail.activation-user-offer-request-mail', [
                    'user' => $notificationLog->user,
                    'post' => $notificationLog->post,
                ]);                        
                break;
            default:
                return abort(404, "page not found");
                break;
        }
    }

    public function logMailPdfsDownload($logId, $userId, $postId) {
        $allFiles = ArchiveFile::where('notification_log_id', $logId)->where('user_id', $userId)
            ->where('post_id', $postId)->get();
        // dd($allFiles);
        $filesFullPaths = [];

        if($allFiles != NULL) {
            foreach ($allFiles as $file) {
                $filesFullPaths[] = $file->file_name;
            }
        }
        // dd($filesFullPaths);
        $zipname = 'mail-pdf.zip';
        $zip = new ZipArchive;
        $zip->open('storage/mail_file_archive/'.$postId.'/'.$logId.'/'.$userId.'/'.$zipname, ZipArchive::CREATE);
        foreach ($filesFullPaths as $file) {
            $zip->addFile($file);
        }
        $zip->close();

        return response()->download(public_path('storage/mail_file_archive/'.$postId.'/'.$logId.'/'.$userId.'/'.$zipname));

        // header('Content-Type: application/zip');
        // header('Content-disposition: attachment; filename='.$zipname);
        // header('Content-Length: ' . filesize($zipname));
        // readfile($zipname);
    }


}
