<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ArchiveFile;
use App\Models\Bank;
use App\Models\City;
use App\Models\District;
use App\Models\Document;
use App\Models\Neighborhood;
use App\Models\Post;
use App\Models\PostView;
use App\Models\Property;
use App\Models\User;
use Carbon\Carbon;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Image;
use PDF;

class PropertyController extends Controller
{

    public function __construct()
    {
       // $this->authorize('admin');
       $this->middleware('auth');
    }

    /*
    protected function resourceAbilityMap()
    {
        return [
            'show' => 'view',
            'create' => 'create',
            'store' => 'create',
            'edit' => 'update',
            'update' => 'update',
            'destroy' => 'delete',
            'cloneProperty'=>'cloneProperty',
            'setTenderStatusActive'=>'setTenderStatusActive'
        ];
    }
    */

    public function index()
    {
        //Queries are in PropertyComposer.

        $this->authorize('view', Property::class);


        
      //  PostView::createViewLog(Post::findOrfail(1));

        return view('admin.properties.index');
    }

    public function create()
    {
        $this->authorize('create', Property::class);

        $cities = City::all();
        $banks = Bank::with(['documents' => function ($query) {
            $query->where('is_active', 1);
        }])->get();
        
        $banksJsonFormat = json_decode($banks); 
        $propturkDepositRatio = Bank::where('name', 'propturk')->first()->deposit;

        return view('admin.properties.create', compact('cities', 'banks', 'banksJsonFormat', 'propturkDepositRatio'));

    }


    public function store(Request $request)
    {
        $this->authorize('create', Property::class);

        // dd($request->all());
        //$validatedProperty = $request->all()['property']->validate([
     
        //     $validated = $request->validate([  
        //     'property.property_type' => 'required|integer',
        //     'property.house_type' => 'integer|nullable',
        //     'property.gross_m2' => 'integer|nullable',
        //     'property.net_m2' => 'integer|nullable',
        //     'property.building_age' => 'integer|nullable',
        //     'property.heating_type' => 'integer|nullable',
        //     'property.using_status' => 'integer|nullable',
        //     'property.room_count' => 'integer|nullable',
        //     'property.floor' => 'integer|nullable',
        //     'property.total_floor' => 'integer|nullable',
        //     'property.bath_count' => 'integer|nullable',
        //     'property.is_balcony' => 'integer|nullable',
        //     'property.is_furnished' => 'integer|nullable',
        //     'property.is_site' => 'integer|nullable',
        //     'property.is_creditable' => 'integer|nullable',
        //     'property.dues' => 'integer|nullable',
        //     'property.side' => 'nullable',
        //     'property.inside_properties' => 'nullable',
        //     'property.outside_properties' => 'nullable',
        //     'property.land_type' => 'integer|nullable',
        //     'property.peer' => 'integer|nullable',
        //     'property.clearence' => 'integer|nullable',
        //     'property.land_state' => 'integer|nullable',
        //     'property.infrastructure' => 'nullable',
        //     'property.general_properties' => 'nullable',
        //     'property.workplace_type' => 'integer|nullable',
        //     'property.country' => 'string|nullable',
        //     'property.district' => 'string|nullable',
        //     'property.neighborhood' => 'string|nullable',
        //     'property.address' => 'string|nullable',
        //     'property.parsel_request_url' => 'string|nullable',
        //     'property.longitude' => 'nullable',
        //     'property.langitude' => 'nullable',
        //     'post.code' => 'required|string',
        //     'post.title' => 'required|string',
        //     'post.bank_id' => 'required',
        // ]);




        

        DB::beginTransaction();
        try {
            $postArr = [];
            $propertyArr = [];
            $folderName = '';
            foreach($request->all()['properties'] as $key => $value) {
                if($key == 'inside_properties' || $key == 'outside_properties' || $key == 'side' || $key == 'general_properties' || $key == 'infrastructure' || $key == 'general_properties_land') {
                    $propertyArr[$key] = serialize($value);
                }
                else {
                    // dump($key);
                    $propertyArr[$key] = $value;
                }
            }

            if(isset($request->all()['properties']['neighborhood'])){
                $neighborhood = Neighborhood::findOrfail($propertyArr['neighborhood']);
                $propertyArr['neighborhood'] = $neighborhood->name;
                $propertyArr['neighborhood_id'] = $neighborhood->id;
                $propertyArr['district'] = $neighborhood->district->name;
                $propertyArr['country'] = $neighborhood->district->city->name;
            }


            foreach ($request->all()['post'] as $key => $value) {
                if ($key == 'start_price') {
                    $postArr[$key] = str_replace('.', '', $request->all()['post'][$key]);
                    $postArr['current_price'] = $postArr[$key];
                }
                elseif ($key == 'offer_step' || $key == 'entry_price' || $key == 'deposit_ratio' || $key == 'fast_buy_price') {
                    $postArr[$key] = str_replace('.', '', $request->all()['post'][$key]);
                }
                else{
                    $postArr[$key] = $value;
                }
            }
            

            $postArr['duration'] = $postArr['duration_day']*1440 + $postArr['duration_hour']*60;
            unset($postArr['duration_day']);
            unset($postArr['duration_hour']);

            $folderName = 'img_'. time().Str::random(5);
            $postArr['images_folder'] = $folderName;
            
            File::makeDirectory(storage_path('app/public/'.$folderName));
            if($request->hasfile('images_folder')) {
                foreach($request->file('images_folder') as $file)
                {
                    $file->store($folderName);
                }
            }


            $propertyArr['slug'] = SlugService::createSlug(Property::class, 'slug', $postArr['title']);

            $shortLinkCode = Str::random(8);
            
            $allPosts = Post::all();
            $postsShortLinks = $allPosts->pluck('short_link_code')->toArray();

            if(!in_array($shortLinkCode, $postsShortLinks)) {
                $postArr['short_link_code'] = $shortLinkCode;
            }
            else {
                $postArr['short_link_code'] = $shortLinkCode.time();
            }

            

            
            //dd($postArr);
            $property = Property::create($propertyArr);
            
            $tender_code = 10000000 + (int)$property->id;
            $postsTenderCodes = $allPosts->pluck('tender_code')->toArray();
                
            if(!in_array($tender_code, $postsTenderCodes)) {
                $postArr['tender_code'] = $tender_code;
            }
            else {
                $postArr['tender_code'] = $tender_code.random_int(10000, 99999);
            }
            
            $property->post()->save(new Post($postArr));


            Log::channel('Ynetici-Ilan-Operasyon')->info('Y-ILAN OLUSTURMA~'.'ID: '.Auth::user()->id.' E-mail: '.Auth::user()->email.'~'.$postArr['tender_code'].' ilan kodlu '.$postArr['title'].' baslikli ihaleye olusturulmustur.');


            $request->session()->flash('status', 'Yeni ihale basarili bir sekilde olusturuldu.');

            DB::commit();
            
            return redirect()->route('admin.imagePage', ['slug' => $property->slug])->with('status', 'Ilan basarili bir sekilde olusturulmustur.');
        }
        catch(Exception $e) {
            DB::rollback();
            
            return redirect()->route('admin.properties.index')->with('status', 'Ilan olusturulurken hata meydana geldi!!');
        }
    }

    public function imagePage($slug) {  
        $property = Property::PropertyWithRelations()->where('slug', $slug)->first();   
        $media = [];    
        foreach (Storage::allFiles($property->post->images_folder) as $image)   
        {
                
            $fileName = explode('/', $image);   
            $fileName = array_pop($fileName);   
            $type = explode('.', $fileName);    
            $type = array_pop($type);   
            $media[] = array(   
                'name' => $fileName,    
                'size' => 0,    
                'type' => $type,    
                'id' => $fileName,  
                'url' => Storage::url($image)   
            );  
            //  
        }   
        
        $media = json_encode($media);   
            
        //dd($media);
        return view('admin.properties.property-photo', compact('property', 'media'));   
    }   
    // public function getImage($slug)  
    // {    
    //     dd($slug);   
    //     return response()->json(['success']);    
    // }    
    public function imageUpload(Request $request, $slug) {  
        // dd($request->all()); 
        $property = Property::PropertyWithRelations()->where('slug', $slug)->first();   
        $post = Post::findOrfail($property->post->id);  
        $ret = false;   
        if($request->hasfile('file')) { 

            
            $image = $request->file('file');
            
            // $imageName = Str::random(8).time().'.'.$image->extension();

            $imageName = Carbon::now()->timestamp.'.'.$image->extension();

            $filePath = storage_path('app/public/'.$post->images_folder);
            $img = Image::make($image->path());

            $img->resize($img->width()/2, null, function ($const) {
                $const->aspectRatio();
            })->save($filePath.'/'.$imageName);
            


            /*
            $fileName = $request->file('file')->store($post->images_folder);    
            
            $fileName = explode('/', $fileName);
                
            $fileName = array_pop($fileName);   
            */
            $ret = true;    
        }   
        else    
        {   
            $ret = false;   
        }   
        // dd($fileName);   
        // dd($postArr);    
        //$post->fill($postArr);    
        //$post->save();    
            
        return response()->json(['valid' => $ret, 'id' => $imageName]);     
        // return redirect()->route('admin.properties.index');  
            
    }   

    public function imageDelete(Request $request, $slug)    
    {   
        // dd($slug);   
        $fileName = $request->input('_image');  
            
        $fileName = explode('/', $fileName);    
        $fileName = array_pop($fileName);   
        $property = Property::PropertyWithRelations()->where('slug', $slug)->first();   
        $postFolderName = Post::findOrfail($property->post->id)->images_folder; 
        // dd($request->all()); 
            
        $ret = Storage::delete($postFolderName.'/'.$fileName);  
        // dd($postFolderName.$fileName);   
        return response()->json(['valid' => $ret]);     
        // foreach(Storage::allFiles($postFolderName) as $image) {  
        //     Storage::delete($image); 
        // }    
    }

    public function show($slug)
    {
        $this->authorize('show', Property::class);

        $now = Carbon::now('Europe/Istanbul');


        $property = Property::where('slug', $slug)->first();
        $post = $property->post()->with('bank')->get()->first();
        
        $endTimeStr = $post->end_time;
        $endTime = Carbon::parse($endTimeStr, 'Europe/Istanbul');

        $endTimeClock = $endTime->format('H:i');
        $endTimeDay = $endTime->day;
        $endTimeMonth = config('enums.months')[$endTime->format('F')];
        $endTimeYear = $endTime->year;

        $endTimeStr = $post->end_time;
        $endTime = Carbon::parse($endTimeStr, 'Europe/Istanbul');
        $now = Carbon::now('Europe/Istanbul');
        if(!$now->gt($endTime)){
            $diffInSeconds = $now->diffInSeconds($endTime);
        }
        else{
            $diffInSeconds = 0;
        }
        
        $postMin = $post->duration;
        $postDay = (int) ($postMin / 1440);
        $postHour = ($postMin % 1440) / 60;
        // dd($postDay, $postHour); 
        return view('admin.properties.show', [
            'property' => $property,
            'post' => $post,
            'diffInSeconds' => $diffInSeconds,
            'endTimeClock' => $endTimeClock,
            'endTimeDay' => $endTimeDay,
            'endTimeMonth' => $endTimeMonth,
            'endTimeYear' => $endTimeYear,
            'postDay' => $postDay,
            'postHour' => $postHour,
        ]);

    }

 
 
    public function edit($slug)
    {
        $this->authorize('edit', Property::class);
        $property = Property::PropertyWithRelations()->where('slug', $slug)->first();   

        $neighborhood = NULL;
        $neighborhoods = NULL;
        $districts = NULL;
        if($property->neighborhood_id != NULL) {
            $neighborhood = Neighborhood::findOrfail($property->neighborhood_id);   
            $property->district_id = $neighborhood->district->id;   
            $property->city_id = $neighborhood->district->city->id; 
            $neighborhoods = District::findOrfail($neighborhood->district->id)->neighborhood;   
            $districts = District::all();
        }

        $property->day = intval($property->post->duration / 1440);  
        $property->hour = intval(($property->post->duration % 1440) / 60);  
        $banks = Bank::with(['documents' => function ($query) {
            $query->where('is_active', 1);
        }])->get();
        
        $banksJsonFormat = json_decode($banks); 
        $cities = City::all();  
        $postMin = $property->post->duration;
        $postDay = (int) ($postMin / 1440);
        $postHour = ($postMin % 1440) / 60;
        // dd($neighborhood);   

        $propturkBank = Bank::where('name', 'propturk')->first();

        $propturkContracts = Document::where('bank_id', $propturkBank->id)->get();
        
        return view('admin.properties.edit', compact('propturkContracts', 'property', 'banks', 'banksJsonFormat', 'cities', 'districts', 'neighborhoods', 'neighborhood', 'postHour', 'postDay'));


    }



    public function update(Request $request, $slug)
    {
        $this->authorize('edit', Property::class);
        if(!$request->exists('post.contracts')) {
            $postRequestArr = $request->post;
            $postRequestArr['contracts'] = [];
            $request->request->add(['post' => $postRequestArr]);
        }
        DB::beginTransaction();
        try {
            $property = Property::where('slug', $slug)->first();    
            $post = Post::findOrfail($property->post->id);  
            $folderName = $post->images_folder; 
            $propertyArr = [];
            $serializeDatas = array('inside_properties', 'outside_properties', 'side', 'general_properties', 'infrastructure', 'general_properties_land');
            foreach($serializeDatas as $key => $value) {
                if(!isset($request->all()['properties'][$value])) {
                    $propertyArr[$value] = NULL;
                }
            }
            foreach($request->all()['properties'] as $key => $value) {  
                if($key == 'inside_properties' || $key == 'outside_properties' || $key == 'side' || $key == 'general_properties' || $key == 'infrastructure' || $key == 'general_properties_land') {    
                    $propertyArr[$key] = serialize($value); 
                }   
                else {  
                    // dump($key);  
                    $propertyArr[$key] = $value;    
                }   
            }
            if(isset($request->all()['properties']['neighborhood'])){
                $neighborhood = Neighborhood::findOrfail($request->all()['properties']['neighborhood']);    
                $propertyArr['neighborhood'] = $neighborhood->name; 
                $propertyArr['neighborhood_id'] = $neighborhood->id;    
                $propertyArr['district'] = $neighborhood->district->name;   
                $propertyArr['country'] = $neighborhood->district->city->name;
            }



            //dd($propertyArr); 
            $property->fill($propertyArr);  
            $property->save();  
            $postArr = [];  
            foreach ($request->all()['post'] as $key => $value) {   
                if ($key == 'start_price') {    
                    $postArr[$key] = str_replace('.', '', $request->all()['post'][$key]);   
                    $postArr['current_price'] = $postArr[$key]; 
                }   
                elseif ($key == 'offer_step' || $key == 'entry_price' || $key == 'deposit_ratio' || $key == 'fast_buy_price') { 
                    $postArr[$key] = str_replace('.', '', $request->all()['post'][$key]);   
                }   
                else{   
                    $postArr[$key] = $value;    
                }   
            }   
            $postArr['duration'] = $postArr['duration_day']*1440 + $postArr['duration_hour']*60;    
            unset($postArr['duration_day']);    
            unset($postArr['duration_hour']);   

            $attributesTranslate = [
                'code'              => 'kod',
                'title'             => 'baslik',
                'desc'              => 'aiklama',
                'is_opportunity'    => 'firsat',
                'duration'          => 'ihale sresi',
                'start_price'       => 'baslangi fiyati',
                'offer_step'        => 'teklif adimi',
                'is_warrant'        => 'teminat propturk',
                'entry_price'       => 'banka teminat miktari',
                'is_fast_buy'       => 'hizli satin al',
                'fast_buy_price'    => 'hizli satin al fiyati',
                'bank_id'           =>  'banka bilgisi',
                'deposit_ratio'     => 'propturk teminat',
                'tender_status'     => 'ihale durumu',
                'current_price'     =>  'ihale fiyati',
            ];

            foreach($post->getAttributes() as $key => $value) { 
                if(array_key_exists($key, $postArr) && $post->$key != $postArr[$key] && !array_key_exists('contracts', $postArr)) {
                    Log::channel('Ynetici-Ilan-Operasyon')->info('Y-ILAN GNCELLEME~'.'ID: '.Auth::user()->id.' E-mail: '.Auth::user()->email.'~'.'ID: '.$post->id.' Ihale Kodu: '.$post->tender_code.' --'.$attributesTranslate[$key].'-- bilgisini gncelledi. Eski deger: '.$post->$key.'. Yeni deger: '.$postArr[$key]);
                }   
            }
            

            $post->fill($postArr);  

            $post->save(); 

            // dd($post->offer_step);

            if($post->bank->code == 'ziraatkatilim' && $post->tender_status == 1)
            {
                if(array_key_exists('offer_step', $post->getChanges()) || array_key_exists('start_price', $post->getChanges()))
                {
                    $response = Http::asForm()->post('http://ziraatkatilim-com-tr.drp-dev.com/api/realty-update', [
                        'apiToken' => env('DRUPART_API_TOKEN'),
                        'source' => 'propturk',
                        'realty_no' => $post->code,
                        'baslangicBedeli' => $post->start_price,
                        'minArtis' => $post->offer_step,
                        'yayindaMi' => 'evet'
                    ]);

                    if($response->json()['status'] != 'ok')
                    {
                        return redirect()->route('admin.properties.index')->with('status', 'Ilan gncellenirken hata meydana geldi. Ltfen DRUPART firmasiyla iletisime geiniz.');
                    }
                }
            }

            //deleting images first 
                
            // foreach(Storage::allFiles($folderName) as $image) {  
            //     Storage::delete($image); 
            // }    
            //adding new images 
            // if($request->hasfile('images_folder')) { 
            //     foreach($request->file('images_folder') as $file)    
            //     {    
            //         $file->store($folderName);   
            //     }    
            // }    
            DB::commit();

            $request->session()->flash('status', 'Ihale bilgileri basarili bir sekilde gncellendi.');  
                
            return redirect()->route('admin.imagePage', ['slug' => $property->slug]);
        }
        catch(Exception $e) {
            DB::rollback();
            
            return redirect()->route('admin.properties.index')->with('status', 'Ilan gncellenirken hata meydana geldi!!');
        }
    }


    public function destroy(Request $request, $slug)
    {
         $this->authorize('delete', Property::class);

        $property = Property::where('slug', $slug)->first();

        if($property->post->tender_status == 0) {
            $property->post->users()->detach();

            $property->delete();
    
            $request->session()->flash('status', 'Ihale bilgileri basarili bir sekilde silindi.');
        }
        else {
            $request->session()->flash('status', 'Aktif veya bitmis ihaleler silinemez.');
        }


        return redirect()->route('admin.properties.index');
    }

    public function cloneProperty(Request $request, $id) 
    {
        $this->authorize('cloneProperty', Property::class);
        $count = $request->tender_count;
        /*
        $id = 72;
        $count = 5;*/
        $cloneProperty = Property::findOrfail($id);
        $clonePost = Post::findOrfail($cloneProperty->post->id);
        $clonePostTitle = $clonePost->code;
        for($i = 0; $i<$count; $i++) {
            
            
            $cloneProperty->slug =  SlugService::createSlug(Property::class, 'slug', $clonePost['title']);
            
            $property = Property::create($cloneProperty->getAttributes());
 
            $filesArr = Storage::allFiles($clonePost->images_folder); 
            $folderName = 'img_'. time().Str::random(5);
            $clonePost->images_folder = $folderName;
            $clonePost->code = $clonePostTitle.'-'.($i+1);

            $allPosts = Post::all();
            $shorLinkCode = Str::random(8);
            $postsShortLinks = $allPosts->pluck('short_link_code')->toArray();
    
            if(!in_array($shorLinkCode, $postsShortLinks)) {
                $clonePost->short_link_code = $shorLinkCode;
            }
            else {
                $clonePost->short_link_code = $shorLinkCode.time();
            }

            Storage::makeDirectory($folderName);
    
            if(count($filesArr)) {
                foreach($filesArr as $file)
                {
                    Storage::copy($file, $folderName.'/'.Str::random(30).'.jpg');
                    //$file->store($folderName);
                }
            }

            $tender_code = 10000000 + (int)$property->id;
            $postsTenderCodes = $allPosts->pluck('tender_code')->toArray();
                  
            if(!in_array($tender_code, $postsTenderCodes)) {
                $clonePost->tender_code = $tender_code;
            }
            else {
                $clonePost->tender_code = $tender_code.random_int(10000, 99999);
            }

            $property->post()->save(new Post($clonePost->getAttributes()));
            
        }

        return redirect()->route('admin.properties.index')->with('status', $clonePost->code.' kodlu ihale '.$count.' defa basariyla ogaltilmistir.');
    }

    public function setTenderStatusActive($id)
    {
        $this->authorize('setTenderStatusActive', Property::class);

        $post = Post::findOrFail($id);

        if($post->bank->code == 'ziraatkatilim')
        {
            
            $response = Http::asForm()->post('http://ziraatkatilim-com-tr.drp-dev.com/api/realty-update', [
                'apiToken' => env('DRUPART_API_TOKEN'),
                'source' => 'propturk',
                'realty_no' => $post->code,
                'baslangicBedeli' => $post->start_price,
                'minArtis' => $post->offer_step,
                'yayindaMi' => 'evet'
            ]);

            if($response->json()['status'] != 'ok')
            {
                return redirect()->route('admin.properties.index')->with('status', 'Ilan aktif edilirken hata meydana geldi. Ltfen DRUPART firmasiyla iletisime geiniz.');
            }
            
        }

        $now = Carbon::now('Europe/Istanbul')->toDateTimeString();
        
        $post->publish_time = $now;
        $post->tender_status = 1;
        $post->save();
        return redirect()->route('admin.properties.index')->with('status','Ilan basariyla aktif edilmistir.');
    }

    public function setTenderStatusPassive($id)
    {
        $this->authorize('setTenderStatusActive', Property::class);

        $now = Carbon::now('Europe/Istanbul')->toDateTimeString();
        $post = Post::findOrFail($id);

        if(!is_null($post->end_time))
        {
            return redirect()->route('admin.properties.index')->with('danger', 'Ihale sreci baslamis ilani pasife alamazsiniz.');
        }
        
        if($post->bank->code == 'ziraatkatilim')
        {
            
            $response = Http::asForm()->post('http://ziraatkatilim-com-tr.drp-dev.com/api/realty-update', [
                'apiToken' => env('DRUPART_API_TOKEN'),
                'source' => 'propturk',
                'realty_no' => $post->code,
                'baslangicBedeli' => $post->start_price,
                'minArtis' => $post->offer_step,
                'yayindaMi' => 'hayir'
            ]);

            if($response->json()['status'] != 'ok')
            {
                return redirect()->route('admin.properties.index')->with('status', 'Ilan pasife alinirken hata meydana geldi. Ltfen DRUPART firmasiyla iletisime geiniz.');
            }
            
        }

        $post->tender_status = 0;
        $post->save();
        return redirect()->route('admin.properties.index')->with('status','Ilan basariyla pasif edilmistir.');
    }

    public function getTenderReportPdf($id) {


        /*
        {{ \Carbon\Carbon::parse($post->end_time)->format('d.m.Y') }}
        saat
        {{ \Carbon\Carbon::parse($post->end_time)->format('H:i') }} tarihine kadar revize edebilirsiniz.
        */
        $property = Property::findOrFail($id);
        $post = $property->post;

        $endTimeStr = $post->end_time;
        $endTime = Carbon::parse($endTimeStr, 'Europe/Istanbul');

        $endTimeDay = $endTime->day;
        $endTimeMonth = config('enums.months')[$endTime->format('F')];
        $endTimeYear = $endTime->year;

        $startTimeStr = $post->first_offer_time;

        $startTime = Carbon::parse($startTimeStr, 'Europe/Istanbul');

        $startTimeDay = $startTime->day;

        $startTimeMonth = config('enums.months')[$startTime->format('F')];

        $startTimeYear = $startTime->year;

        $postViewCount = PostView::where('post_id', $id)->get()->count();
        
    
        $offerPercentageRise = 100*($post->current_price-$post->start_price)/$post->start_price;
        
        $winner = User::findOrFail($post->winner_id);
        
        $tenderResultDatas = [
            'post_code' => $post->code,
            'post_title' => $property->country.' Ili, '.$property->district.' Ilesi, '. $post->title,
            'post_start_date_formatted' => Carbon::parse($post->first_offer_time)->format('d.m.Y H:i'),
            'post_end_date_formatted' => Carbon::parse($post->end_time)->format('d.m.Y H:i'),
            'post_start_date' => $startTimeDay.' '.$startTimeMonth.' '.$startTimeYear,
            'post_end_date' => $endTimeDay.' '.$endTimeMonth.' '.$endTimeYear,
            'city' => $property->country,
            'district' => $property->district,
            'neighborhood' => $property->neighborhood,
            'city_block_no' => $property->city_block_no,
            'parcel_no' => $property->parcel_no,
            'floor_no' => $property->floor_no,
            'block_no' => $property->block_no,
            'independent_section_no' => $property->independent_section_no,
            'address' => $property->address, 
            'post_image' => 'https://www.propturk.com/storage/'.Storage::allFiles($post->images_folder)[0],
            'bank_logo' => 'https://www.propturk.com/storage/bank-logo/'.$post->bank->code.'_logo.jpg',
            'start_price' => number_format($post->start_price, 0, '.', '.'),
            'offer_step' => number_format($post->offer_step, 0, '.', '.'),
            'post_user_count' => $post->users->count(),
            'post_offer_count' => $post->offers->count(),
            'best_price' => $post->current_price,
            'post_view_count' => $postViewCount,
            'post_with_user' => $post->offers()->with('user')->get()->reverse(),
            'offerPercentageRise' => $offerPercentageRise,
            'winner' => $winner, 
        ];
        
        $tenderReportPdf = PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])->loadView('mail.pdf-templates.finished-tender-report', $tenderResultDatas)->setPaper('A4', 'portrait');
        return $tenderReportPdf->download('ihale-sonucu-'.$post->code.'.pdf');

    }

    public function archiveFilesIndex($slug)
    {
        $property = Property::with('post')->where('slug', $slug)->first();
        $archiveFiles = $property->post->archiveFiles()->noNotificationLog()->get();
        foreach($archiveFiles as $archiveFile)
        {
            $archiveFile->url = env('APP_URL').'/storage/post_archive/'.$property->post->archive_folder.'/'.$archiveFile->file_name;
        }
        return view('admin.properties.archive-files', compact('archiveFiles', 'property'));
    }

    public function archiveFileUpload(Request $request, $slug)
    {
        $post = Property::with('post')->where('slug', $slug)->first()->post;

        $status = false;

        if($request->hasFile('file'))
        {
            if(is_null($post->archive_folder))
            {
                $archiveFolderName = 'archive_'.time().Str::random(5);

                $post->archive_folder = $archiveFolderName;

                File::makeDirectory(storage_path('app/public/post_archive/'.$archiveFolderName), 0755, true);
                
                $post->save();
            }

            $uploadedFile = $request->file('file');

            $uploadedFileName = explode('.', $uploadedFile->getClientOriginalName())[0];

            $archiveFileName = $uploadedFileName.time().'.'.$uploadedFile->getClientOriginalExtension();

            $archiveFile = new ArchiveFile([
                'file_name' => $archiveFileName,
                'mime_type' => $uploadedFile->getClientOriginalExtension(),
                'size' => $uploadedFile->getSize(),
            ]);

            $post->archiveFiles()->save($archiveFile);
            
            $path = Storage::putFileAs('post_archive/'.$post->archive_folder, $uploadedFile, $archiveFile->file_name);

            $status = true;
        }

        return response()->json(['valid' => $status, 'id' => $archiveFile->id]);
    }

    public function archiveFileDelete(Request $request, $slug)
    {
        $post = Property::with('post')->where('slug', $slug)->first()->post;

        $archiveFile = ArchiveFile::findOrFail($request->input('_image'));

        $archiveFile->delete();

        Storage::delete('post_archive/'.$post->archive_folder.'/'.$archiveFile->file_name);

        return response()->json(['valid' => true]);
    }

    public function archiveFileDownload(Request $request, $slug)
    {
        $post = Property::with('post')->where('slug', $slug)->first()->post;

        $archiveFile = ArchiveFile::where('id', $request->input('_archivefile'))->first();

        $path = 'storage/post_archive/'.$post->archive_folder.'/'.$archiveFile->file_name;

        return response()->download($path, $archiveFile->file_name, ['File-Name' => $archiveFile->file_name]);
    }

}