<?php

namespace App\Http\Controllers;

use App\Models\NotificationLog;
use App\Models\Post;
use App\Models\Property;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        //$this->authorizeResource(User::class, 'user');
    }

    public function show($slug)
    {
        $user = User::where('slug', $slug)->firstOrFail();

        $this->authorize('view', [$user, Auth::user()]);
        
        return view('user.home', compact('user'));
    }

    public function edit($slug)
    {
        $user = User::where('slug', $slug)->firstOrFail();

        $this->authorize('update', [$user, Auth::user()]);

        return view('user.edit', compact('user'));


    }

    public function update(Request $request, $slug)
    {
        $user = User::where('slug', $slug)->firstOrFail();

        $this->authorize('update', [$user, Auth::user()]);


        $request->validate([
            'name'              => ['required', 'string', 'max:255'],
            'surname'           => ['required', 'string', 'max:255'],
            'email'             => ['required', 'string', 'email', 'max:255'],
            'password'          => ['nullable', 'string', 'min:8', 'confirmed'],
            'phone_number'      => ['required'],
            'identity_number'   => ['nullable'],
            'company_name' => ['nullable', 'string'],
            'company_tax_office' => ['nullable', 'string'],
            'company_tax_id' => ['nullable', 'string'],

         ]);

         $userArray = $request->only('name', 'surname', 'identity_number', 'email', 'phone_number', 'password', 'sms_permission', 
            'company_name', 'company_tax_office', 'company_tax_id');

         if(!$request->has('sms_permission')) {
            $userArray['sms_permission'] = 0;
        }

        $userArray['phone_number'] =  substr(preg_replace('/[^0-9]/', '', $userArray['phone_number']), 1);

        //for creating log messages

        $attributesTranslate = [
            'name'            => 'isim',
            'surname'         => 'soyisim',
            'phone_number'    => 'telefon numarası',
            'identity_number' => 'kimlik numarası',
            'sms_permission'  => 'sms izni',
            'email'           => 'email',
            'company_name'           => 'şirket ismi',
            'company_tax_office'     => 'şirket vergi dairesi',
            'company_tax_id'         => 'şirket vergi no',

        ];

        foreach($user->getAttributes() as $key => $value) { 
            if($key != 'password' && array_key_exists($key, $userArray) && $user->$key != $userArray[$key]) {
                Log::channel('Kullanıcı-Güncelleme')->info('KULLANICI GÜNCELLEME~'.'ID: '.$user->id.' E-mail: '.$user->email.' --'.$attributesTranslate[$key].'-- bilgisini güncelledi. Eski değer: '.$user->$key.'. Yeni değer: '.$userArray[$key]);
            }   
        }

         $user->name = $userArray['name'];
         $user->surname = $userArray['surname'];
         $user->email = $userArray['email'];
         $user->identity_number = $userArray['identity_number'];
         $user->phone_number = $userArray['phone_number'];
         $user->sms_permission = $userArray['sms_permission'];
         $user->company_name = $userArray['company_name'];
         $user->company_tax_office = $userArray['company_tax_office'];
         $user->company_tax_id = $userArray['company_tax_id'];

         if(!$userArray['password'] == null) {
            Log::channel('Kullanıcı-Güncelleme')->info('KULLANICI GÜNCELLEME~'.'ID: '.$user->id.' E-mail: '.$user->email.' --'.'şifre'.'-- bilgisini güncelledi.');

             $user->password = Hash::make($userArray['password']);
         }
         
         $user->save();

         $request->session()->flash('status', 'Kullanıcı bilgileriniz başarıyla güncellendi.');	
         return redirect()->route('user.show', ['slug' => $user->slug]);        
    }

    public function showUserTenders($slug) {
        
        $user = User::where('slug', $slug)->firstOrFail();


        $userPosts = $user->posts();
        
        $posts = Post::where('tender_status', 1)->latest()->get();
        $userPostsIds = $userPosts->get()->pluck('id')->toArray();
        $userUnverifiedTenders = $posts
        ->whereIn('id', unserialize($user->mailed_posts))
        ->whereNotIn('id', $userPostsIds);   // Onay Bekleyen İhalelerim
        foreach($userUnverifiedTenders as $post) {
            if($post->end_time != NULL) {
                $now = Carbon::now('Europe/Istanbul');
                $endTimeStr = $post->end_time;
                $endTime = Carbon::parse($endTimeStr, 'Europe/Istanbul');
                if(!$now->gt($endTime)){
                    $diffInSeconds = $endTime->diffInSeconds($now);
                }
                else{
                    $diffInSeconds = 0;
                    $post->tender_status = 2;
                }
                $post->diffinseconds = $diffInSeconds;
            }
        }
        $userContiniousTenders = $userPosts->latest()->get()->where('tender_status', 1);   // Devam Eden ihalelelrim
        foreach($userContiniousTenders as $post) {
            if($post->end_time != NULL) {
                $now = Carbon::now('Europe/Istanbul');
                $endTimeStr = $post->end_time;
                $endTime = Carbon::parse($endTimeStr, 'Europe/Istanbul');
                if(!$now->gt($endTime)){
                    $diffInSeconds = $endTime->diffInSeconds($now);
                }
                else{
                    $diffInSeconds = 0;
                    $post->tender_status = 2;
                }
                $post->diffinseconds = $diffInSeconds;
            }
        }
        $userFinishedTenders = $userPosts->where('winner_id', $user->id)->with('offers')->whereNotIn('tender_status', [0, 1])->latest()->get(); // Sonuçlanmış İhalelerim

        $userFavoriteTenders = $posts
        ->whereIn('id', unserialize($user->favorite_posts));
        foreach($userFavoriteTenders as $post) {
            if($post->end_time != NULL) {
                $now = Carbon::now('Europe/Istanbul');
                $endTimeStr = $post->end_time;
                $endTime = Carbon::parse($endTimeStr, 'Europe/Istanbul');
                if(!$now->gt($endTime)){
                    $diffInSeconds = $endTime->diffInSeconds($now);
                }
                else{
                    $diffInSeconds = 0;
                    $post->tender_status = 2;
                }
                $post->diffinseconds = $diffInSeconds;
            }
        }

        if(isset(Auth::user()->favorite_posts)){    
            $favoritePosts = unserialize(Auth::user()->favorite_posts); 
        }   
        else{   
            $favoritePosts = [];    
        }
        return view('user.offer-favorite', compact('userUnverifiedTenders', 'userContiniousTenders', 'userFinishedTenders', 'userFavoriteTenders', 'favoritePosts'));
    }

    public function userCRUDFavoriteTenders($slug) {
        $user = User::findOrFail(Auth::user()->id);
        $postId = Property::where('slug', $slug)->first()->post->id;

        if(isset($user->favorite_posts)){	
            $userFavoriteTenders = unserialize($user->favorite_posts); 	
        }	
        else{	
            $userFavoriteTenders = [];	
        }
        
        if (($key = array_search($postId, $userFavoriteTenders)) !== false) {
            unset($userFavoriteTenders[$key]);
            $isPushOrPop = false;
        }
        else {
            array_push($userFavoriteTenders, $postId);
            $isPushOrPop = true;
        }
        $user->favorite_posts = serialize($userFavoriteTenders);
        $user->save();

        return response()->json($isPushOrPop);

    }



    public function smsSendForVerification($slug) {

        $this->authorize('smsSendForVerification', [Auth::user()]);

        $user = User::where('slug', $slug)->firstOrFail();


        // if($user->activation_code == NULL) {
        $user->activation_code = random_int(100000, 999999);
        $user->save();
        // }
        $user->sms_permission = 1;
 
        $notificationLogType = 'sms';
        $notificationLogName = 'SMS - Kullanıcı hesap aktivasyon kodu gönderimi'; //userAccountActivationSms
        $notificationLogDesc = str_replace('%20', ' ', userAccountActivationSms($user));
        NotificationLog::createNotificationLog(NULL, $user, $notificationLogType, $notificationLogName, $notificationLogDesc);

        sendSms($user, userAccountActivationSms($user));


        return view('user.account-activation');

    }

    public function smsVerification(Request $request, $slug) {
        $user = User::where('slug', $slug)->firstOrFail();
   
        if($user->activation_code == $request->all()['sms_code']) {
            $user->is_active = 1;
            $user->save();
            $user->sms_permission = 1;
            
            $notificationLogType = 'sms';
            $notificationLogName = 'SMS - Kullanıcı yeni kayıt'; //UserRegisterSMS
            $notificationLogDesc = str_replace('%20', ' ', UserRegisterSMS($user));
            NotificationLog::createNotificationLog(NULL, $user, $notificationLogType, $notificationLogName, $notificationLogDesc);

            sendSms($user, UserRegisterSMS($user));
            return redirect()->route('user.show', ['slug' => $slug])->with('status', 'Hesabınınz aktif edilmiştir.');
        }
        return redirect()->route('user.account-activation')->with('status', 'Yanlış şifre girdiniz. Lütfen doğru şifreyi giriniz.');
    }
}