<?php

namespace App\Http\Middleware;

use App\Models\Property;
use Closure;
use Illuminate\Http\Request;

class CheckPostBank
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $sessionSubdomain = session('subdomain');
        $bankSubdomain = Property::where('slug', $request->slug)->first()->post->bank->code;
        // dd(isset($sessionSubdomain));
        if($bankSubdomain != session('subdomain') && isset($sessionSubdomain))
        {
            return redirect('/');
        }
        return $next($request);
    }
}
