<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class DetectSubDomain
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $subdomain = null;
        $currentURL = $request->url();
        $partial = explode('://', $currentURL);
        if(count($partial) == 2)
        {
          $partial = explode('.propturk.com', $partial[1]);
          if(count($partial) > 1)
          {
            $subdomain = $partial[0];
          }
        }

        if($subdomain === 'www')
        {
          $subdomain = null;
        }
        
        session(['subdomain' => $subdomain]);
        
        return $next($request);
    }
}