<?php

namespace App\Mail;

use App\Models\Post;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use PhpParser\Node\Expr\Cast\String_;

class HigherOfferMail extends Mailable
{
    use Queueable, SerializesModels;
   
    public $user;
    public $post;


    public function __construct(User $user, Post $post)
    {
        $this->user = $user;
        $this->post = $post;
    }

    public function build()
    {
        $subject = $this->post->code.' Kodlu Gayrimenkule ait Yeni Teklif Verildi';
        return $this
        ->markdown('mail.higher-offer-mail')
        ->from('info@propturk.com')
        ->subject($subject);  
    }
}
