<?php

namespace App\Mail;

use App\Models\Post;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class TenderLoserMail extends Mailable
{
    use Queueable, SerializesModels;
   
    public $user;
    public $post;


    public function __construct(User $user, Post $post)
    {
        $this->user = $user;
        $this->post = $post;
    }

    public function build()
    {
        $subject =  $this->post->title.'('.$this->post->code.')'.'/ E-İhale Tamamlandı';
        return $this
        ->markdown('mail.tender-loser-mail')
        ->from('info@propturk.com')
        ->subject($subject);  
    }
}
