<?php

namespace App\Mail;

use App\Models\Post;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class TenderUserPermissionActivationMail extends Mailable
{
    use Queueable, SerializesModels;
   
    public $user;
    public $post;

    public function __construct(User $user, Post $post)
    {
        $this->user = $user;
        $this->post = $post;
    }

    public function build()
    {
        $subject = $this->post->code.' Kodlu Taşınmaza Ait Yetki Tanımlaması';
        return $this
        ->markdown('mail.tender-user-permission-activation-mail')
        ->from('info@propturk.com')
        ->subject($subject);  
    }
}
