<?php

namespace App\Mail;

use App\Models\Bank;
use App\Models\Post;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class TenderUserPermissionMail extends Mailable
{
    use Queueable, SerializesModels;
   
    public $user;
    public $post;
    public $contractArray;
    public $bank;

    public function __construct(User $user, Post $post, $contractArray, Bank $bank)
    {
        $this->user = $user;
        $this->post = $post;
        $this->contractArray =  $contractArray;
        $this->bank = $bank;
    }

    public function build()
    {
        $subject = $this->post->code.' Kodlu Taşınmaza Ait Başvuru İşlemleri';
        $email = $this
        ->markdown('mail.tender-user-permission-mail')
        ->from('info@propturk.com')
        ->subject($subject);
        //->attachFromStorage('/app/public/pdfs/'.$this->pdfName);
        
        foreach ($this->contractArray as $key => $contract) {
            $email
            ->attachData(base64_decode($contract['contractPdfHtmlData']), $contract['contractName'].'_'.$this->user->name.'_'.$this->user->surname.'.pdf');         
        }
        
        return $email;
    }
}
