<?php

namespace App\Mail;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class UserRegisterMail extends Mailable
{
    use Queueable, SerializesModels;
   
    public $user;


    public function __construct(User $user)
    {
        $this->user = $user;
    }

    public function build()
    {
        $subject = 'Yeni Kayıt Bilgilendirme- '.$this->user->name.' '.$this->user->surname;
        return $this
        ->markdown('mail.user-register-mail')
        ->from('info@propturk.com')
        ->subject($subject);  
    }
}
