<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;

class ArchiveFile extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'file_name', 'mime_type', 'size', 'notification_log_id', 'post_id', 'user_id'
    ];

    public function post()
    {
        return $this->belongsTo(Post::class);
    }

    public function notificationLog()
    {
        return $this->belongsTo(NotificationLog::class);
    }

    public function scopeNoNotificationLog(Builder $query)
    {
        return $query->whereNull('notification_log_id');
    }

    public static function boot()
    {
        parent::boot();

        static::creating(function(ArchiveFile $archiveFile) {
            $archiveFile->uuid = Str::uuid();
        });

        // static::deleting(function(ArchiveFile $archiveFile) {

        //     $folderName = $archiveFile->post->archive_folder;

        // });
    }
}
