<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NotificationLog extends Model
{
    use HasFactory;

    protected $fillable = ['type', 'name', 'desc', 'post_id', 'user_id'];

    public function post() {
        return $this->belongsTo(Post::class);
    }

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function archiveFiles() {
        return $this->hasMany(ArchiveFile::class);
    }
    
    public static function createNotificationLog($post, $user, $type, $name, $desc) {
        
        $notificationLog = new NotificationLog();

        $notificationLog->type = $type;
        $notificationLog->name = $name;
        if($desc != NULL) {
            $notificationLog->desc = $desc;
        }
        if($post != NULL) {
            $notificationLog->post_id = $post->id;
        }
        $notificationLog->user_id = $user->id;
        
        $notificationLog->save();

                return $notificationLog;
    }

}
