<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class Post extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $fillable = [
        'code', 'title', 'desc', 'is_opportunity', 'duration', 'start_price', 'offer_step', 'is_warrant',
        'entry_price', 'current_price', 'is_fast_buy', 'fast_buy_price', 'deposit_ratio', 'tender_status',
        'publish_time', 'first_offer_time', 'images_folder', 'postable_type', 'postable_id', 'user_id', 'bank_id',
        'short_link_code', 'tender_code', 'contracts'
    ];

    protected $casts = [
        'contracts' => 'array',
    ];

    public function notificationLogs() {
        return $this->hasMany(NotificationLog::class);
    }
    
    public function bank() {
        return $this->belongsTo(Bank::class);
    }
    
    public function offers() {
        return $this->hasMany(Offer::class);
    }

    public function postable() {
        return $this->morphTo();
    }

    public function postsViews() {
        return $this->hasMany(PostView::class);
    }
    
    public function users() {
        return $this->belongsToMany(User::class)->withTimestamps();
    }
    
    public function archiveFiles()
    {
        return $this->hasMany(ArchiveFile::class);
    }

    public static function boot()
    {
        parent::boot();

        static::creating(function(Post $post) {
            $archiveFolderName = 'archive_'.time().Str::random(5);

            $post->archive_folder = $archiveFolderName;

            File::makeDirectory(storage_path('app/public/post_archive/'.$archiveFolderName), 0755, true);
        });
    }
}
