<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;

class PostView extends Model
{
    use HasFactory;

    protected $fillable = ['title_slug', 'url', 'ip', 'session_id', 'agent', 'post_id', 'user_id'];

    public function post() {
        return $this->belongsTo(Post::class);
    }

    public function user() {
        return $this->belongsTo(User::class);
    }

    public static function createViewLog($post) {
        $user = Auth::user();
        $postsViews= new PostView();
        $postsViews->post_id = $post->id;
        $postsViews->title_slug = $post->postable->slug;
        $postsViews->url = Request::url();
        $postsViews->session_id = Request::getSession()->getId();
        if($user) {
            $postsViews->user_id = Auth::user()->id;
        }
        $postsViews->ip = Request::getClientIp();
        $postsViews->agent = Request::header('User-Agent');
        $postsViews->save();
}

}
