<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Cviebrock\EloquentSluggable\Sluggable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes, Sluggable;


    protected $fillable = [
        'name', 'surname', 'phone_number', 'identity_number', 'is_active', 'is_admin', 'email', 'password', 
        'slug', 'mailed_posts', 'sms_permission', 'address', 'company_name', 'company_tax_office', 'company_tax_id'
    ];


    protected $hidden = [
        'password',
        'remember_token',
    ];


    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'slug'
            ]
        ];
    }
    
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }
    public function getJWTCustomClaims()
    {
        return [];
    }
    
    public function offers() {
        return $this->hasMany(Offer::class);
    }

    public function posts() {
        return $this->belongsToMany(Post::class)->withTimestamps();
    }

    public function postsViews() {
        return $this->hasMany(PostView::class);
    }

    public function notificationLogs() {
        return $this->hasMany(NotificationLog::class);
    }
    
    public static function boot()
    {
        parent::boot();

        static::deleting(function (User $user) {
            $user->offers()->delete();
            $user->posts()->delete();
        });
    }
}
