<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class BankFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->name(),
            'code' => Str::random(6),
            'branch' => $this->faker->name(),
            'branch_no' => Str::random(10),
            'account_no' => Str::random(10),
            'iban' => Str::random(12),
            'deposit' => random_int(1, 5),
            'is_active' => random_int(0, 1)
        ];
    }
}
