<?php

namespace Database\Factories;

use App\Models\Bank;
use App\Models\Post;
use App\Models\Property;
use DateTime;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class PostFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {

        $price = random_int(200, 2500);
        $tenderStatus = ['Pasif', 'Aktif', 'Tamamlandi'];
        $timeStart = $this->faker->unixTime();
        $timeEnd = $this->faker->unixTime(new DateTime('+1 day'));



        return [
            'code' => Str::random(5),
            'title' => $this->faker->sentence(12),
            'desc' => $this->faker->paragraph(2, true),
            'is_opportunity' => random_int(0, 1),
            'duration' => random_int(50000, 100000),
            'start_price' => $price,
            'offer_step' => $price/100,
            'current_price' => $price,
            'is_warrant' => random_int(0, 1),
            'entry_price' => $price/10,
            'is_fast_buy' => random_int(0, 1),
            'deposit_ratio' => random_int(3, 10),
            'tender_status' => random_int(0, 2),
            'publish_time' => $this->faker->dateTimeBetween('now', '+5 days'),
            'first_offer_time' => $this->faker->dateTimeBetween('+1 days', '+2 days'),
            'images_folder' => Str::random(10),
            'bank_id' => Bank::all()->random()->id,
        ];
    }
}
