<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class PropertyFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $gross_m2 = random_int(80, 250);
        $floor = random_int(0, 10);
        $sides = ['Kuzey', 'Guney', 'Dogu', 'Bati'];
        $inside_properties = ['ADSL', 'Akilli Ev', 'Alarm', 'Balkon', 'Firin', 'Teras', 'Kiler', 'Boyali', 'Klima'];
        $outside_properties = ['Asansor', 'Kapici', 'Kres', 'uydu', 'Otopark', 'Sauna', 'Kablo TV'];

        $sides_Json =  [];

        for($i = 0; $i < random_int(1, count($sides)); $i++) {
            if(random_int(0, 1)) {
                array_push($sides_Json, $sides[$i]);
            }
        }
        //json_encode($sides_Json);

        $inside_Json = [];

        for($i = 0; $i < random_int(2, count($inside_properties)); $i++) {
            if(random_int(0, 1)) {
                array_push($inside_Json, $inside_properties[$i]);
            }
        }
        //json_encode($inside_Json);

        $outside_Json = [];

        for($i = 0; $i < random_int(3, count($outside_properties)); $i++) {
            if(random_int(0, 1)) {
                array_push($outside_Json, $outside_properties[$i]);
            }
        }
        //json_encode($outside_Json);
        
        return [
            'property_type'         => random_int(0, 2),
            'house_type'            => random_int(0, 2),
            'gross_m2'              => $gross_m2,
            'net_m2'                => random_int($gross_m2-10, $gross_m2),
            'building_age'          => random_int(0, 40),
            'heating_type'          => random_int(0, 10),
            'using_status'          => random_int(0, 2),
            'room_count'            => random_int(0, 30),
            'floor'                 => $floor,
            'total_floor'           => random_int($floor, $floor+5),
            'bath_count'            => random_int(1, 3),
            'is_balcony'            => random_int(0, 1),
            'is_furnished'          => random_int(0 ,1),
            'is_site'               => random_int(0, 1),
            'is_creditable'         => random_int(0, 1),
            'dues'                  => random_int(100, 400),
            'side'                  => serialize($sides_Json),
            'inside_properties'     => serialize($inside_Json),
            'outside_properties'    => serialize($outside_Json),
            'country'               => $this->faker->country(),
            'district'              => $this->faker->city(),
            'neighborhood'          => $this->faker->streetName(),
            'address'               => $this->faker->address(),
            'parsel_request_url'    => $this->faker->url(),
            'longitude'             => random_int(300, 400)/10,
            'langitude'             => random_int(300, 400)/10,
            'neighborhood_id'       => random_int(100, 200),

        ];
    }
}