<?php

namespace Database\Factories;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Faker\Generator as Faker;

class UserFactory extends Factory
{

    public function definition()
    {
        $name = $this->faker->firstName();
        $surname = $this->faker->lastName();
        return [
            'name'              => $name,
            'surname'           => $surname,
            'phone_number'      => $this->faker->phoneNumber(),
            'identity_number'   => random_int(100000000, 999999999),
            'is_active'         => rand(0, 1),
            'is_admin'          => false,
            'mailed_posts'      => NULL,
            'favorite_posts'    => NULL,
            'slug'              => SlugService::createSlug(User::class, 'slug', $name.'-'.$surname.'-'.Str::random(5)),
            'email'             => $this->faker->unique()->safeEmail(),
            'email_verified_at' => now(),
            'password'          => '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', // password
            'remember_token'    => Str::random(10),
        ];
    }


    public function unverified()
    {
        return $this->state(function (array $attributes) {
            return [
                'email_verified_at' => null,
            ];
        });
    }

    public function isAdmin()
    {
        return $this->state(function() {
            $name = 'John';
            $surname = 'Stone';
            return 
            [
                'name' => $name,
                'surname' => $surname,
                'is_admin' => true,
                'email' => 'johnstone@propturk.com',
                'slug' => SlugService::createSlug(User::class, 'slug', $name.'-'.$surname.'-'.Str::random(5)),
            ];
        }
        );
    }
}