<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('surname');
            $table->string('slug')->nullable();
            $table->string('phone_number');
            $table->string('identity_number')->nullable();
            $table->boolean('sms_permission')->default(0);
            $table->integer('activation_code')->nullable();
            $table->boolean('is_active')->default(false);
            $table->integer('is_admin')->default(0);
            $table->string('email')->unique();
            $table->string('password');
            $table->timestamp('email_verified_at')->nullable();
            $table->rememberToken();
            $table->longText('mailed_posts')->nullable();
            $table->longText('favorite_posts')->nullable();
            $table->longText('address')->nullable();

            $table->longText('company_name')->nullable();
            $table->longText('company_tax_office')->nullable();
            $table->longText('company_tax_id')->nullable();


            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
