<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBanksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('banks', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('code');
            $table->string('branch')->nullable();
            $table->string('branch_no')->nullable();
            $table->string('account_no')->nullable();
            $table->string('iban')->nullable();
            $table->integer('deposit')->nullable();
            $table->boolean('is_active')->default(0);
            $table->boolean('completed_tenders_is_visible')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

 
    public function down()
    {
        Schema::dropIfExists('banks');
    }
}
