<?php

namespace Database\Seeders;

use App\Models\Offer;
use App\Models\Post;
use App\Models\User;
use Illuminate\Database\Seeder;

class OfferSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $users = User::all();
        $posts = Post::all();

        Offer::factory()->count(50)->make()->each(function($offer) use($users, $posts) {
            $offer->user_id = $users->random()->id;
            $offer->post_id = $posts->random()->id;
            $offer->save();
        });

    }
}
