<?php

namespace Database\Seeders;

use App\Models\Post;
use App\Models\Property;
use Illuminate\Database\Seeder;

class PostSeeder extends Seeder
{
    public $i = 0;
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        
        Post::factory()->count(10)->make()->each(function($post, $key) {
            $post->postable_type = Property::class;
            $post->postable_id = $key+1;
            if($post->is_fast_buy) 
            {
                $post->fast_buy_price = $post->current_price + 1000;
            }
            $post->save();
        }); 


    }
}
