<!DOCTYPE html>
<html lang="zxx">
    <head>
        <meta charset="UTF-8"/>
        <meta http-equiv="X-UA-Compatible" content="ie=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta name="robots" content="noindex, nofollow"/>
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <link href="{{ asset('assets/img/favicon.png') }}" rel="shortcut icon"/>

        <title>@yield('title')</title>

        @include('admin.layout.include-css')
        @yield('styles')
        <style>
            #loader {
                border: 12px solid #f3f3f3;
                border-radius: 50%;
                border-top: 12px solid #444444;
                width: 70px;
                height: 70px;
                animation: spin 1s linear infinite;
            }
            
            @keyframes spin {
                100% {
                    transform: rotate(360deg);
                }
            }
            
            .loader-center {
                position: absolute;
                top: 0;
                bottom: 0;
                left: 0;
                right: 0;
                margin: auto;
            }

            .ui-hover-a a:hover{
                background-color: #ebeafc !important;
            }
            /* Chrome, Safari, Edge, Opera */
            /* input::-webkit-outer-spin-button,
            input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
            } */
            
            input[type=number] {
            -moz-appearance: textfield;
            }
        </style>
        <!--[if lt IE 9]><script src="assets/html5shiv.min.js"></script><![endif]-->
    </head>
    <body class="bg-light dashbord_content">
        <div id="loader" class="loader-center"></div>
        <div class="position-relative wrapper_content clearfix d-block float-left w-100">
            <nav class="navbar navbar-expand-md bg_theme navbar-dark" style="background: black !important;">
                <div class="container">
                    <a class="navbar-brand" href="{{ route('home') }}"><img style="width: 250px;" src="{{ asset('assets/img/logo-footer.png') }}" title="propturk.com" alt="propturk"/></a>
                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Open Navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav ml-auto">
                            <li class="nav-item active">
                                <a class="nav-link" href="{{ route('admin.home') }}">Anasayfa <span class="sr-only">(current)</span></a>
                            </li>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="#" id="uiInterfaceDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Hızlı Erişim
                                </a>
                                <div class="dropdown-menu dropdown-menu-right p-0 overflow-hidden ui-hover-a" aria-labelledby="uiInterfaceDropdown">
                                    <a class="dropdown-item py-3" href="{{ route('admin.properties.index') }}">Tüm İlanlar</a>
                                    <a class="dropdown-item py-3" href="{{ route('admin.users.index') }}">Tüm Kullanıcılar</a>
                                    <a class="dropdown-item py-3" href="{{ route('admin.banks.index') }}">Tüm Bankalar</a>
                                    <a class="dropdown-item py-3" href="{{ route('admin.logs') }}">Log Kayıtları</a>                                  
                                </div>
                            </li>
                            {{-- <li class="nav-item dropdown ">
                                <a class="nav-link dropdown-toggle" href="#" id="propertyDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    İlanlar
                                </a>
                                <div class="dropdown-menu dropdown-menu-right p-0 overflow-hidden ui-hover-a" aria-labelledby="propertyDropdown">
                                    <a class="dropdown-item py-3" href="dashboard-property-list.html"><i class="fas fa-home mr-2"></i> Tüm İlanlar</a>
                                    <a class="dropdown-item py-3" href="dashboard-property-submit.html"><i class="fas fa-sign mr-2"></i> Yayında</a>
                                    <a class="dropdown-item py-3" href="dashboard-property-report.html"><i class="fas fa-pause-circle mr-2"></i> Pasif</a>
                                    <a class="dropdown-item py-3" href="dashboard-property-list.html"><i class="fas fa-play-circle mr-2"></i> İhale Sürecinde</a>
                                    <a class="dropdown-item py-3" href="dashboard-property-submit.html"><i class="fas fa-check-circle mr-2"></i> Tamamlandı</a>
                                    <a class="dropdown-item py-3" href="dashboard-property-report.html"><i class="fas fa-times-circle mr-2"></i> İptal</a>
                                    <a class="dropdown-item py-3" href="dashboard-property-report.html"><i class="fas fa-pen-square mr-2"></i> Taslak</a>
                                </div>
                            </li> --}}
                            {{-- <li class="nav-item dropdown notifications_menu">

                                <a class="nav-link dropdown-toggle position-relative" href="#" id="navbarNotification" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="far fa-bell"></i> <span class="badge badge-warning j_alert">2</span>                               
                                </a>
                                <div class="dropdown-menu dropdown-menu-right p-0 overflow-hidden" aria-labelledby="navbarNotification">
                                    <a class="dropdown-item py-3" href="dashboard-property-inactive.html" title="Inactive Properties">
                                        3 İlanın İhalesi Sonlandı!                                
                                    </a>
                                    <a class="dropdown-item py-3" href="dashboard-profile.html" title="Inactive Properties">
                                        Yeni Kullanıcı Kayıt Oldu!                                 
                                    </a>
                                </div>
                            </li> --}}
                            <li class="nav-item dropdown ">
                                <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Merhaba <b>{{ Auth::user()->name }}</b>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right overflow-hidden p-0 overflow-hidden" aria-labelledby="navbarDropdown">
                                    <div class="dropdown-item disabled bg-info py-3 text-center text-white d-block px-lg-5">
                                        <h5 class="mb-0 mt-2">Admin Paneli</h5>
                                        <small>Super Admin (adm)</small>
                                    </div>
                                    {{-- <a class="dropdown-item py-3" href="dashboard-profile.html" title="My profile">
                                        <i class="far fa-id-badge mr-2"></i> My profile
                                    </a> --}}
                                    
                                    {{-- <div class="dropdown-divider"></div> --}}
                                    @if(auth()->user()->id == 1)
                                        <a class="dropdown-item py-3" href="{{ route('admin.users.edit', ['user' => auth()->user()->id]) }}" title="Bilgileri Düzenle">
                                            <i class="fas fa-sign-out-alt"></i> Bilgileri Düzenle
                                        </a>
                                    @endif
                                    <a class="dropdown-item py-3" href="{{ route('logout') }}" title="Çıkış" onclick="event.preventDefault();
                                    document.getElementById('logout-form').submit();">
                                        <i class="fas fa-sign-out-alt"></i> Çıkış Yap
                                    </a>
                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                        @csrf
                                    </form>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </nav>

            <!-- START MAIN CONTAINER -->
            <div class="container py-3">
                @yield('content')
            </div>
            <!-- END MAIN CONTAINER -->

            <footer class="border-top text-center bg-white text-dark d-block w-100 py-3 main_footer position-absolute text_small">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-6 text-center text-md-left">
                            <b  class="text-primary">Propturk</b> - Admin Panel <a href='#' title='' ></a>                        
                        </div>
                        <div class="col-sm-6 text-center text-md-right">
                            <b>Version: </b>1.0
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </body>
    @include('admin.layout.include-js')
    <script>
        document.onreadystatechange = function() {
            if (document.readyState !== "complete") {
                document.querySelector("body").style.visibility = "hidden";
                document.querySelector("#loader").style.visibility = "visible";
            } else {
                document.querySelector("#loader").style.display = "none";
                document.querySelector("body").style.visibility = "visible";
            }
        };
    </script>
    @yield('scripts')
</html>
