@extends('admin.layout.layout')

@section('title', 'İlan Detayları')

@section('styles')
    @parent
    <link href='https://api.mapbox.com/mapbox-gl-js/v2.3.1/mapbox-gl.css' rel='stylesheet' />
    <style>
        .card{
            border: 1px solid #e0e0e0;
            border-radius: 0px;
            padding: 25px;
            box-shadow: 0 0 5px rgb(0 0 0 / 10%);
            height: 100%;
        }
        .tender-detail-p{
            font-weight: 600;
            text-decoration: underline;
        }
        .tender-detail-p2{
            margin-left: 5px;
            overflow: hidden;
        }
        .mapboxgl-ctrl-bottom-left{
            display: none !important;
        }
        .mapboxgl-ctrl-bottom-right{
            display: none !important;
        }
    </style>
@stop

@section('content')
<nav aria-label="breadcrumb">
    <ol class="breadcrumb bg-transparent p-0 text_small">
        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Admin</a></li>
        <li class="breadcrumb-item"><a href="{{ route('admin.properties.index') }}">Tüm İlanlar</a></li>
        <li class="breadcrumb-item"><a href="#">Ön İzleme</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ $post->title }}</li>
    </ol>
</nav>
{{-- {{ dd($properties) }} --}}
<section class="mb-5 pb-5">
    @include('flash_message.flash')
    <header class="border-bottom mt-4">
        <h3 class="text-primary font-weight-light"><i class="far fa-list-alt"></i> İlan Detayları</h3>
    </header>
    
    {{-- <div class="d-block w-100 pb-2 export_document_box text-center text-md-right mt-md-n5 pb-md-4 pt-3 pt-md-0">
    </div> --}}
    <div class="py-3">
        <div class="">
            <div class="row">

                {{-- Temel --}}
                <div class="col-6 mb-4">
                    <div class="card">
                        <h5 class="text-center" style="text-decoration: underline;color: forestgreen;">Temel Detaylar</h5>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">İlan Kodu:</p>
                            <p class="tender-detail-p2">{{ $post->code }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Banka: </p>
                            <p class="tender-detail-p2">{{ $post->bank->name }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Banka Teminat Oranı: </p>
                            <p class="tender-detail-p2">%{{ $post->bank->deposit }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Emlak Tipi: </p>
                            <p class="tender-detail-p2">
                                {{ config('enums.property_type')[$property->property_type] }}
                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">İlan Başlığı: </p>
                            <p class="tender-detail-p2">{{ $post->title }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">İlan Açıklaması: </p>
                            <p class="tender-detail-p2">
                                {!! $post->desc !!}
                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Fırsat Butonu:</p>
                            <p class="tender-detail-p2">
                                @if ($post->is_opportunity == 0)
                                    <i class="fa fa-times" aria-hidden="true" style="color:red;"></i>
                                @elseif ($post->is_opportunity == 1)
                                    <i class="fa fa-check" aria-hidden="true" style="color:green;"></i>
                                @endif
                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">İlan Süresi: </p>
                            <p class="tender-detail-p2">{{ $postDay }} Gün {{ $postHour }} Saat</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Başlangıç Bedeli: </p>
                            <p class="tender-detail-p2">
                                {{ number_format($post->start_price, 0, '.', '.') }}&#x20BA;
                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Teklif Adımı: </p>
                            <p class="tender-detail-p2">
                                {{ number_format($post->offer_step, 0, '.', '.') }}&#x20BA;
                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Teminatı PropTürk Tutacak?: </p>
                            <p class="tender-detail-p2">
                                @if ($property->post->is_warrant == 0)
                                    Hayır
                                @elseif($property->post->is_warrant == 1)
                                    Evet
                                @endif
                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Banka İhale Teminat Bedeli: </p>
                            <p class="tender-detail-p2">
                                {{ number_format($post->entry_price, 0, '.', '.') }}&#x20BA;
                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">PropTürk İhale Katılım Bedeli: </p>
                            <p class="tender-detail-p2">{{ number_format($post->deposit_ratio, 0, '.', '.') }}&#x20BA;</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Hemen Al Açık?: </p>
                            <p class="tender-detail-p2">
                                @if ($property->post->is_fast_buy == 0)
                                    Hayır
                                @elseif($property->post->is_fast_buy == 1)
                                    Evet
                                @endif
                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Hemen Al Fiyatı: </p>
                            <p class="tender-detail-p2">
                                {{ number_format($post->fast_buy_price, 0, '.', '.') }}&#x20BA;
                            </p>
                        </div>
                        
                    </div>
                </div>

                {{-- Konut --}}
                @if ($property->property_type == 0)
                    <div class="col-6 mb-4">
                        <div class="card">
                            <h5 class="text-center" style="text-decoration: underline;color: forestgreen;">İlan Detayları</h5>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Konut Tipi:</p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->house_type))
                                    {{ config('enums.house_type')[$property->house_type] }}
                                    @endif
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Brüt m2: </p>
                                <p class="tender-detail-p2">{{ number_format($property->gross_m2, 0, '.', '.') }}m<sup>2</sup></p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Net m2: </p>
                                <p class="tender-detail-p2">{{ number_format($property->net_m2, 0, '.', '.') }}m<sup>2</sup></p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Bina Yaşı: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->building_age))
                                    {{ config('enums.building_age')[$property->building_age] }}
                                    @endif
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Isıtma: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->heating_type))
                                    {{ config('enums.heating_type')[$property->heating_type] }}
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Kullanım Durumu: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->using_status))
                                    {{ config('enums.using_status')[$property->using_status] }}
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Oda Sayısı:</p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->room_count))
                                    {{ config('enums.room_count')[$property->room_count] }}
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Bulunduğu Kat: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->floor))
                                    {{ config('enums.floor')[$property->floor] }}.Kat
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Kat Sayısı: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->total_floor))
                                    {{ config('enums.total_floor')[$property->total_floor] }}
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Banyo Sayısı: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->bath_count))
                                    {{ config('enums.bath_count')[$property->bath_count] }}
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Balkon: </p>
                                <p class="tender-detail-p2">
                                    @if ($property->is_balcony == 1)
                                        Var
                                    @else
                                        Yok
                                    @endif
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Eşyalı: </p>
                                <p class="tender-detail-p2">
                                    @if ($property->is_furnished == 1)
                                        Evet
                                    @else
                                        Hayır
                                    @endif
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Site İçerisinde: </p>
                                <p class="tender-detail-p2">
                                    @if ($property->is_site == 1)
                                        Evet
                                    @else
                                        Hayır
                                    @endif
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Kredi Uygun: </p>
                                <p class="tender-detail-p2">
                                    @if ($property->is_creditable == 1)
                                        Evet
                                    @else
                                        Hayır
                                    @endif
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Aidat: </p>
                                <p class="tender-detail-p2">{{ $property->dues }}</p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Cephe: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->side))
                                        @foreach (unserialize($property->side) as $key => $side)
                                            <span>{{ config('enums.side')[$key] }}</span>,
                                        @endforeach
                                    @endif
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">İç Özellikler: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->inside_properties))
                                        @foreach (unserialize($property->inside_properties) as $key => $inside_properties)
                                            <span>{{ config('enums.inside_properties')[$key] }}</span>,
                                        @endforeach
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Dış Özellikler: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->outside_properties))
                                        @foreach (unserialize($property->outside_properties) as $key => $outside_properties)
                                            <span>{{ config('enums.outside_properties')[$key] }}</span>,
                                        @endforeach
                                    @endif
                                    
                                </p>
                            </div>
                            
                        </div>
                    </div>
                @endif

                {{-- İş Yeri --}}
                @if ($property->property_type == 1)
                    <div class="col-6 mb-4">
                        <div class="card">
                            <h5 class="text-center" style="text-decoration: underline;color: forestgreen;">İlan Detayları</h5>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">İş Yeri Tipi:</p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->workplace_type))
                                    {{ config('enums.workplace_type')[$property->workplace_type] }}
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Brüt m2: </p>
                                <p class="tender-detail-p2">{{ number_format($property->gross_m2, 0, '.', '.') }}m<sup>2</sup></p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Net m2: </p>
                                <p class="tender-detail-p2">{{ number_format($property->net_m2, 0, '.', '.') }}m<sup>2</sup></p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Bina Yaşı: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->building_age))
                                    {{ config('enums.building_age')[$property->building_age] }}
                                    @endif
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Isıtma: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->heating_type))
                                    {{ config('enums.heating_type')[$property->heating_type] }}
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Kullanım Durumu: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->using_status))
                                    {{ config('enums.using_status')[$property->using_status] }}
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Aidat: </p>
                                <p class="tender-detail-p2">{{ $property->dues }}</p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Cephe: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->side))
                                        @foreach (unserialize($property->side) as $key => $side)
                                            <span>{{ config('enums.side')[$key] }}</span>,
                                        @endforeach
                                    @endif
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Genel Özellikler: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->general_properties))
                                        @foreach (unserialize($property->general_properties) as $key => $general_properties)
                                            <span>{{ config('enums.general_properties')[$key] }}</span>,
                                        @endforeach
                                    @endif
                                    
                                </p>
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Arsa --}}
                @if ($property->property_type == 2)
                    <div class="col-6 mb-4">
                        <div class="card">
                            <h5 class="text-center" style="text-decoration: underline;color: forestgreen;">İlan Detayları</h5>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Arsa Tipi:</p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->land_type))
                                    {{ config('enums.land_type')[$property->land_type] }}
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Net m2: </p>
                                <p class="tender-detail-p2">{{ number_format($property->net_m2, 0, '.', '.') }}m<sup>2</sup></p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Kaks(Emsal): </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->peer))
                                    {{ config('enums.peer')[$property->peer] }}
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Gabari: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->clearence))
                                    {{ config('enums.clearence')[$property->clearence] }}
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Tapu Durumu: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->land_state))
                                    {{ config('enums.land_state')[$property->land_state] }}
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Altyapı: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->infrastructure))
                                        @foreach (unserialize($property->infrastructure) as $key => $infrastructure)
                                            <span>{{ config('enums.infrastructure')[$key] }}</span>,
                                        @endforeach
                                    @endif
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Genel Özellikler: </p>
                                <p class="tender-detail-p2">
                                    @if (isset($property->general_properties_land))
                                        @foreach (unserialize($property->general_properties_land) as $key => $general_properties_land)
                                            <span>{{ config('enums.general_properties_land')[$key] }}</span>,
                                        @endforeach
                                    @endif
                                    
                                </p>
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Adres --}}
                <div class="col-6 mb-4">
                    <div class="card">
                        <h5 class="text-center" style="text-decoration: underline;color: forestgreen;">Adres</h5>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">İl:</p>
                            <p class="tender-detail-p2">{{ $property->country }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">İlçe: </p>
                            <p class="tender-detail-p2">{{ $property->district }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Semt/Mahalle: </p>
                            <p class="tender-detail-p2">{{ $property->neighborhood }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Adres: </p>
                            <p class="tender-detail-p2">{{ $property->address }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Ada No: </p>
                            <p class="tender-detail-p2">{{ $property->city_block_no }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Parsel No: </p>
                            <p class="tender-detail-p2">{{ $property->parcel_no }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Kat No: </p>
                            <p class="tender-detail-p2">{{ $property->floor_no }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Blok No: </p>
                            <p class="tender-detail-p2">{{ $property->block_no }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">BB No: </p>
                            <p class="tender-detail-p2">{{ $property->independent_section_no }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Parsel Sorgu Url: </p>
                            <p class="tender-detail-p2">{{ $property->parsel_request_url }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Enlem: </p>
                            <p class="tender-detail-p2">{{ $property->langitude }}</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Boylam: </p>
                            <p class="tender-detail-p2">{{ $property->longitude }}</p>
                        </div>
                    </div>
                </div>

                {{-- İlan Resimleri --}}
                <div class="col-6 mb-4">
                    <div class="card">
                        <h5 class="text-center" style="text-decoration: underline;color: forestgreen;">Resimler</h5>
                        <div class="form-row m-0">
                            @foreach(Storage::allFiles($property->post->images_folder) as $image)
                                <div class="col-4 mb-2">
                                    <img class="img-fluid" style="height: 150px;object-fit: cover;width: 100%;" src="{{ Storage::url($image) }}">
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

                <div class="col-12">
                    <div class="card">
                        <div id="map" style="width: 100%; height: 500px;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</section>
@stop

@section('scripts')
    @parent
    <script src='https://api.mapbox.com/mapbox-gl-js/v2.3.1/mapbox-gl.js'></script>
    <script>
        $(function () {
            var lantg = {!! $property->longitude !!};
            var lontg = {!! $property->langitude !!};
        
            mapboxgl.accessToken = 'pk.eyJ1IjoicHJvcHR1cmsiLCJhIjoiY2t6cDk0MWZtMDhtNTJvbzJ1MWtpYTdyeiJ9._g9p7Eb8o8IaUMLKnHyRag';
            const map = new mapboxgl.Map({
                container: 'map', // container ID
                style: 'mapbox://styles/mapbox/streets-v11', // style URL
                center: [lantg, lontg], // starting position [lng, lat]
                zoom: 15 // starting zoom
            });
            const marker = new mapboxgl.Marker()
            .setLngLat([lantg, lontg])
            .addTo(map);
        });
    </script>
@endsection