@extends('layout.layout')

@section('title', 'Giriş Yap')

@section('styles')
    @parent
@stop

@section('content')

    <!-- start main container -->
    <main class="bg-light bg_parallax">
        <div class="container py-5">
            <div class="row justify-content-center">
                <div class='py-5 px-3 px-md-5 my-3 col-md-8 col-xl-5 shadow bg-white text-left'>
                    <div class="text-center">
                        <a class="main_brand d-inline-block" href="{{ route('home') }}" title="propturk - Ana Sayfa">
                            <img class="d-block w-100" src="{{ asset('assets/img/logo.png') }}" alt="" title=""/>
                        </a>
                        <h2 class="font-weight-bold h4">Giriş Yap</h2>
                        <p class="tagline text-body mb-3">Lütfen giriş bilgilerinizi giriniz!</p>
                    </div>
                    <form method="POST" action="{{ route('login') }}" enctype="multipart/form-data">
                        @csrf
                        
                        <div class="form-group">
                            <label for="email">Eposta Adresi</label>
                            <input type="email" name="email"  class="form-control" id="email" placeholder="Eposta Adresi" required>
                        </div>
                        <div class="form-group">
                            <label for="password">Şifre</label>
                            <input type="password" name="password" class="form-control" id="password" placeholder="Şifre" required>
                        </div>

                        @if(env('GOOGLE_RECAPTCHA_KEY'))
                            <div class="g-recaptcha"
                                data-sitekey="{{env('GOOGLE_RECAPTCHA_KEY')}}">
                            </div>
                        @endif
                        
                        <button type="submit" class="btn btn-primary py-3 btn-block" style="margin-top: 1rem;">Giriş</button>

                        <div class="mt-1 d-flex justify-content-between">
                            <a class="float-left" title="Şifremi Unuttum!" href="">Şifremi Unuttum!</a>
                            <a class="float-right" title="Kayıt Ol!" href="{{ route('register') }}">Üye Ol!</a>
                        </div>
                    </form>
                    @if($errors->any())
                        <div class="mt-2 mb-2">
                            @foreach($errors->all() as $error)
                                <div class="alert alert-danger" role="alert">
                                    {{ $error }}
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>

            </div>
        </div>

    </main>
    <!-- end main container -->

@stop

@section('scripts')
    @parent
    <script src='https://www.google.com/recaptcha/api.js'></script>
    <script>
        
    </script>
@endsection