@extends('layout.layout')

@section('title', 'Anasayfa')

@section('styles')
    @parent
    <link href='https://api.mapbox.com/mapbox-gl-js/v2.3.1/mapbox-gl.css' rel='stylesheet' />
    <style>
        .mapboxgl-ctrl-bottom-left{
            display: none !important;
        }
        .mapboxgl-ctrl-bottom-right{
            display: none !important;
        }
    </style>
@stop

@section('content')
    <!-- start main container -->
    <main class="bg-light">        
        <section>
            <header class="text-center bg_parallax bg-white">
                <div class="bg_shadow py-5" style="background: #212529;">
                    <div class="container py-3 position-relative text_shadow text-white">
                        <div class="row justify-content-center">
                            <div class="col-md-10 col-lg-8 col-xl-6">
                                <h2 class="font-weight-bold h1 section_title">Bizimle İletişime Geç</h2>

                                <nav class="d-inline-block" aria-label="breadcrumb">
                                    <h2 class="sr-only">Breadcrumb</h2>
                                    <ol class="breadcrumb bg-transparent py-0">
                                        <li class="breadcrumb-item"><a class="text-light font-weight-bold" href="index.html">Anasayfa</a></li>
                                        <li class="breadcrumb-item active text-white" aria-current="page">İletişim</li>
                                    </ol>
                                </nav> 
                            </div>
                        </div>
                    </div>
                </div>
            </header>
            <div class="container py-5">
                <div class="row py-3">
                    <div class="col-lg-6 col-xl-7 mb-5 mb-lg-0">
                        <div class="bg-white p-4 p-lg-4 border" style="height: 100%;">
                            <div class="border-bottom border-dark mb-4">
                                <h4 class="text-dark font-weight-bold mb-3">İletişim Formu</h4>
                            </div>                                

                            <form class="text-muted" action="#" method="post" enctype="multipart/form-data">
                                <div class="form-row">
                                    <div class="col-xl-6">
                                        <div class="input-group border mb-3">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text bg-light border-0 text-muted">
                                                    <i class="far fa-user"></i>
                                                </span>
                                            </div>
                                            <input 
                                                type="text" 
                                                class="form-control text-muted border-0 bg-light"
                                                name="client_name" 
                                                value=""
                                                placeholder="Ad" 
                                                required
                                                >
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="input-group border mb-3">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text bg-light border-0 text-muted">
                                                    <i class="far fa-user"></i>
                                                </span>
                                            </div>
                                            <input 
                                                type="text" 
                                                class="form-control text-muted border-0 bg-light"
                                                name="client_surname" 
                                                value=""
                                                placeholder="Soyad" 
                                                required
                                                >
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="input-group border mb-3">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text border-0 text-muted bg-light">
                                                    <i class="far fa-envelope"></i>
                                                </span>
                                            </div>
                                            <input 
                                                type="text" 
                                                class="form-control border-0 text-muted bg-light"  
                                                name="client_email"
                                                value="" 
                                                placeholder="Eposta Adresi" 
                                                required
                                                >
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="input-group border mb-3">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text border-0 text-muted bg-light">
                                                    <i class="fas fa-phone"></i>
                                                </span>
                                            </div>
                                            <input 
                                                type="text" 
                                                class="form-control border-0 text-muted bg-light"  
                                                name="client_phone"
                                                value="" 
                                                placeholder="Telefon Numarası" 
                                                required
                                                >
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="message" class="sr-only">Mesajınız:</label>
                                    <textarea 
                                        class="form-control bg-light" 
                                        name="message" 
                                        id="message" 
                                        placeholder="Mesajınız" 
                                        rows="5"></textarea>
                                </div>

                                <div class="form-group">
                                    <button class="btn btn-block btn-lg btn-primary" type="submit">
                                        Gönder
                                    </button>
                                </div>
                            </form> 
                        </div>
                    </div>
                    <div class="col-lg-6 col-xl-5">
                        <div class="bg-dark border px-3 px-md-4 py-3">

                            <p class="h5 font-weight-bold footer_title mb-2 mt-4 text-light">Adres</p>
                            <p class="text-left py-3 mb-0" style="color:white;">
                                <i class="far fa-map"></i> 
                                Koşuyolu Mahallesi, Koşuyolu Caddesi,  No: 100/2
                            </p>
                            <p class="text-left" style="color: white;">Kadıköy / İSTANBUL</p>
                        </div>
                    </div>

                </div>


            </div>

            <div id="map" style="width: 100%; height: 500px;"></div>

           

        </section>
    </main>
    <!-- end main container -->
@stop

@section('scripts')
    @parent
    <script src='https://api.mapbox.com/mapbox-gl-js/v2.3.1/mapbox-gl.js'></script>
    <script>
        $(document).ready(function() {
        
            mapboxgl.accessToken = 'pk.eyJ1IjoicHJvcHR1cmsiLCJhIjoiY2t6cDk0MWZtMDhtNTJvbzJ1MWtpYTdyeiJ9._g9p7Eb8o8IaUMLKnHyRag';
            const map = new mapboxgl.Map({
                container: 'map', // container ID
                style: 'mapbox://styles/mapbox/streets-v11', // style URL
                center: [29.0364545, 41.00949462164493], // starting position [lng, lat]
                zoom: 12, // starting zoom
                interactive: false
            });
            const marker = new mapboxgl.Marker()
            .setLngLat([29.0364545, 41.00949462164493])
            .addTo(map);
            
        });
    </script>
@endsection