@extends('layout.layout')

@section('title', 'Anasayfa')

@section('styles')
    @parent
    <style>
        .nav-link{
            color: white !important;
            background: rgb(39, 34, 34) !important;
            border-color: rgb(39, 34, 34) !important;
        }

        .select2-selection__rendered {
            line-height: 48px !important;
            border-radius: 0 !important;
            border: none !important;
        }
        .select2-container .select2-selection--single {
            height: 48px !important;
            border-radius: 6px !important;
            border: none !important;
        }
        .select2-selection__arrow {
            height: 48px !important;
            border-radius: 0 !important;
            border: none !important;
        }
        .select2-container{
            max-width: 75% !important;
            border: none !important;
        }
        .select2-container--default .select2-selection--single{
            background-color: #f8f9fa !important;
            border: none !important;
        }
        .select2-container--default .select2-selection--single .select2-selection__rendered{
            font-size: 19px;
            color: #6c757d!important;
        }
        .search-select-span{
            background: #F5F8FA;
            border-bottom-left-radius: 6px;
            border-top-left-radius: 6px;
            border:none !important;
            color:#5E6278
        }
        .search-select-span i{
            font-size: 17px;
        }
        .search-select{
            background-color: #F5F8FA;
            border:none !important;
            border-bottom-right-radius: 6px !important;
            border-top-right-radius: 6px !important;
            color:#5E6278;
            font-size: 17px !important;
            line-height: 16px !important;
            padding-left: 5px !important;
        }
        .input-select2{
            display: flex !important;
            flex-wrap: nowrap !important;
        }

        @media screen and (max-width:900px) {
            .mobile-grid{
                grid-gap: 20px;
            }
            .select2-container{
                max-width: 100% !important;
            }
            .select2-container--default .select2-selection--single .select2-selection__rendered{
                padding-left: 2px;
                font-size: 17px
            }
        }

        .min-price{
            border-radius: 6px !important;
            font-size: 14px !important;
        }

        .max-price{
            border-radius: 6px !important;
            font-size: 14px !important;
        }

        .min-price:focus{
            box-shadow: 0 0 0 0.25rem rgb(13 110 253 / 0%) !important;
        }

        .max-price:focus{
            box-shadow: 0 0 0 0.25rem rgb(13 110 253 / 0%) !important;
        }

        .min-price::placeholder { /* Chrome, Firefox, Opera, Safari 10.1+ */
            font-size: 14px;
            opacity: 0.5;
        }

        .min-price:-ms-input-placeholder { /* Internet Explorer 10-11 */
            font-size: 14px;
            opacity: 0.5;
        }

        .min-price::-ms-input-placeholder { /* Microsoft Edge */
            font-size: 14px;
            opacity: 0.5;
        }

        .max-price::placeholder { /* Chrome, Firefox, Opera, Safari 10.1+ */
            font-size: 14px;
            opacity: 0.5; /* Firefox */
        }

        .max-price:-ms-input-placeholder { /* Internet Explorer 10-11 */
            font-size: 14px;
            opacity: 0.5;
        }

        .max-price::-ms-input-placeholder { /* Microsoft Edge */
            font-size: 14px;
            opacity: 0.5;
        }

        .currency-wrap{
            position:relative;
        }
        
        .currency-code{
            position:absolute;
            left:8px;
            top:12px;
            font-size: 15px;
            color: #5e6278;
        }
        
        .text-currency{
            padding:10px 25px;
            border:solid 1px #ccc;
            border-radius:5px;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow b{
            background-image: url("/assets/img/select2.svg") !important;
            background-color: transparent;
            border: none !important;
            height: 100% !important;
            width: 100% !important;
            margin: auto !important;
            top: auto !important;
            left: auto !important;
            background-size: auto 20%;
            background-repeat: no-repeat;
            background-position: right 10px center;
        }

        @media screen and (min-width:901px) and (max-width:1600px) {
            .search-select{
                font-size: 11px !important;
                padding-left: 0px !important;
            }
            .select2-container{
                max-width: 75% !important;
            }
            .select2-container--default .select2-selection--single .select2-selection__rendered{
                font-size: 13px;
            }
        }

        /* common */
        .ribbon {
            width: 150px;
            height: 150px;
            overflow: hidden;
            position: absolute;
        }
        .ribbon::before,
        .ribbon::after {
            position: absolute;
            z-index: -1;
            content: '';
            display: block;
            border: 5px solid #2980b9;
        }
        .ribbon span {
            position: absolute;
            display: block;
            width: 225px;
            padding: 15px 0;
            background-color: #db343f;
            box-shadow: 0 5px 10px rgba(0,0,0,.1);
            color: #fff;
            font: 700 18px/1 'Lato', sans-serif;
            text-shadow: 0 1px 1px rgba(0,0,0,.2);
            text-transform: uppercase;
            text-align: center;
        }

        /* top left*/
        .ribbon-top-left {
            top: -12px;
            left: -10px;
        }
        .ribbon-top-left::before,
        .ribbon-top-left::after {
            border-top-color: transparent;
            border-left-color: transparent;
        }
        .ribbon-top-left::before {
            top: 0;
            right: 0;
        }
        .ribbon-top-left::after {
            bottom: 0;
            left: 0;
        }
        .ribbon-top-left span {
            right: -25px;
            top: 30px;
            transform: rotate(-45deg);
        }

        .slick-list.draggable{
            padding-bottom: 1px;
        }

        .slick-arrow{
            opacity: 1 !important;
            top: 43%;
        }
    </style>
@stop

@section('content')
    @php
        // $routeName = Request::url();
        // dd($routeName);
        // $url = 0;
    @endphp
    @include('flash_message.flash')
    
    @if (session('subdomain') == 'turkiyefinanskatilim' || session('subdomain') == 'odeabank' || session('subdomain') == '')
        <!--start form find-->
        @include('search-component.search-component')
        <!--end form find-->
    
        <!-- İhale Sürecindeki İlanlar -->
        <section class="section_content py-5">
            <header class="container section_header text-center py-3">
                <div class="row justify-content-center">
                    <div class="col-md-10 col-lg-8 col-xl-6">
                        <h2 class="font-weight-bold text-dark section_title">İhale Sürecindeki Gayrimenkuller</h2>
                        <!-- <p class="tagline text-muted">Aktif ihaleler burada mevcuttur.</p>      -->
                    </div>
                </div>
            </header>
            <div class="container pb-3">
                <div class="row justify-content-center">
                    @foreach ($offeredPosts as $post)
                        @if ($post->tender_status == 1)
                            @include('new-card.new-card')                    
                        @endif
                    @endforeach
                    

                </div>
                {{-- <div class="text-center">
                    <a href="property-search.html" class="btn btn-primary btn-lg" title="See more properties">See more properties</a>
                </div> --}}
            </div>
        </section>
        <!-- End İhale Sürecindeki İlanlar -->

        <!-- Teklif Beklenen İlanlar -->
        <section class="section_content py-5">
            <header class="container section_header text-center py-3">
                <div class="row justify-content-center">
                    <div class="col-md-10 col-lg-8 col-xl-6">
                        <h2 class="font-weight-bold text-dark section_title">Teklif Beklenen Gayrimenkuller</h2>
                        <!-- <p class="tagline text-muted">Teklif beklenen ihaleler burada mevcuttur.</p>      -->
                    </div>
                </div>
            </header>
            <div class="container pb-3">
                <div class="row justify-content-center">
                    @foreach ($nonOfferedPosts as $post)
                        @include('new-card.new-card')
                    @endforeach
                    

                </div>
            </div>
        </section>
        <!-- End Section New Property -->

        <!-- Teklif Beklenen İlanlar -->
        <section class="section_content py-5">
            <header class="container section_header text-center py-3">
                <div class="row justify-content-center">
                    <div class="col-md-10 col-lg-8 col-xl-6">
                        <h2 class="font-weight-bold text-dark section_title">İhalesi Tamamlanan Gayrimenkuller</h2>
                        <!-- <p class="tagline text-muted">İhalesi tamamlanmış ilanlar.</p>      -->
                    </div>
                </div>
            </header>
            <div class="container pb-3">
                <div class="row justify-content-center">
                    <div class="slide_four slide_max">
                        @foreach ($completedPosts as $post)
                            <div class="post_item">
                                @include('new-card.new-slide-card')
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </section>
        <!-- End Section New Property --> 
    @elseif(session('subdomain') == 'ziraatkatilim')
        <div class="row _mobile--btn-ziraat">
            <div class="col-12 text-center">
                <button class="btn btn-dark _mobile--btn-ziraat-click"><i class="fa fa-search" aria-hidden="true"></i><span>Filtreler</span></button>
                <button class="btn btn-dark _mobile--btn-ziraat-click-hide" style="display: none;"><i class="fa fa-search" aria-hidden="true"></i><span>Gizle</span></button>
            </div>
        </div>
        <div class="row h-100">
            <div class="col-3 col-md-3 _mobile--responive">
                <div class="row">
                    <div class="content-filter-side">
                        <div class="col-12 pr-0 pl-0">
                            <div class="d-flex justify-content-center align-items-center" style="height: 70px;background-color: #eb1c23 !important;">
                                <h4 class="content-filter-heading mb-0" style="color: white;font-size: 1.1em;font-weight: bold;">Hızlı Arama</h4>
                            </div>
                        </div>
                        <div class="col-12">
                            <form action="{{ route('search') }}" method="get" class="loader_select" style="padding: 15px;display:none">
                                
                                {{-- @method('POST') --}}
                                <div class="form-group">
                                    <label for="languageSelect" class="mb-0">İl Seçin</label>
                                    <select name="city[]" multiple id="languageSelect">
                                        <option class="sa">Tümü</option>

                                        @foreach ($cities as $city)
                                            <option value="{{ $city->id }}"
                                                @isset(request()->city )
                                                    @foreach (request()->city as $item)
                                                        {{ $item == $city->id ? 'selected' : '' }}
                                                    @endforeach
                                                @endisset
                                                >
                                                {{ $city->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="form-group district--search">
                                    <label for="exampleInputEmail1" class="mb-0">İlçe Seçin</label>

                                    <select class="js-select2-district" name="district" id="property_district">
                                        
                                    </select>
                                </div>

                                <div class="form-group district-all">
                                    <label for="exampleInputEmail1" class="mb-0">İlçe Seçin</label>
                                    <select name="districtAll">
                                        <option value="all">Tümü</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="mb-0">Emlak Tipi</label>
                                    <select class="form-control" style="color: black;
                                    border: 1px solid #e2e2e2;
                                    height: 42px;
                                    border-radius: 5px !important;min-height: 42px;" name="property_type">
                                        <option value="" {{ request()->property_type == '' ? 'selected' : '' }}>Emlak Tipi</option>
                                        <option value="0" {{ request()->property_type == '0' ? 'selected' : '' }}>Konut</option>
                                        <option value="1" {{ request()->property_type == '1' ? 'selected' : '' }}>İş Yeri</option>
                                        <option value="2" {{ request()->property_type == '2' ? 'selected' : '' }}>Arsa</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="mb-0">Fiyat</label>
                                    <div class="d-flex" style="grid-gap: 5px;">
                                        <input type="text" class="form-control" value="{{ isset(request()->min_price) ? request()->min_price :  ''}}" 
                                        name="min_price" placeholder="Min" style="min-height: 42px;height:42px;">
                                        <input type="text" value="{{ isset(request()->max_price) ? request()->max_price :  ''}}"
                                        name="max_price" class="form-control" placeholder="Max" style="min-height: 42px;height:42px;">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="mb-0">Gayrimenkul Numarası</label>
                                    <input type="text" class="form-control" placeholder="G. No" name="g_no" style="min-height: 42px;height:42px;" value="{{ request()->g_no }}">
                                </div>

                                <div class="form-group">
                                    <label for="" class="mb-0">Sıralama</label>
                                    <select name="property_sort" class="form-control">
                                        <option value="0" value="" {{ request()->property_sort == '' ? 'selected' : '' }}>Varsayılan</option>
                                        <option value="1" {{ request()->property_sort == '1' ? 'selected' : '' }}>Fiyat Düşükten Yükseğe</option>
                                        <option value="2" {{ request()->property_sort == '2' ? 'selected' : '' }}>Fiyat Yüksekten Düşüğe</option>
                                    </select>
                                </div>

                                <div class="d-flex _mobile-filter-btn" style="grid-gap: 5px;">
                                    <input type="hidden" value="ziraat-katilim" name="ziraatKatilimSelector">
                                    <button type="submit" class="btn btn-primary btn-bank-search">Ara</button>
                                    <a href="{{ route('home') }}" class="btn btn-primary btn-bank-search">Temizle</a>
                                    <a href="{{ route('home') }}" class="btn btn-primary btn-bank-search">Tümü</a>
                                </div>
                                
                            </form>
                        </div>
                        
                    </div>
                    
                </div>
            </div>
            <div class="col-12 col-md-9 pl-0 _mobile--responsive-col">
                <div class="content-items-header">
                    <div>
                        <a href="" class="content-items-header-a">YENİ EKLENENLER</a>
                    </div>
                </div>
                
                @isset($z)

                    @foreach ($properties as $post)
                        @php
                            $post = $post->post; 
                        @endphp
                        @if ($post->first_offer_time == null)
                            @if($post->bank->code == 'ziraatkatilim')
                                <div class="bank-card">
                                    <div class="row">
                                        <div class="col-12 col-md-auto">
                                            <div class="bank-card-img-div">
                                                <a href="{{ route('post.show', ['slug' => $post->postable->slug]) }}">
                                                    @if (isset(Storage::allFiles($post->images_folder)[0]))
                                                        <img src="{{asset('storage/'.Storage::allFiles($post->images_folder)[0] )}}" class="card-img-top img-fluid bank-card-img" alt="Ürün Resmi">
                                                    @endif
                                                </a>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6 pl-0" style="max-width: 360px;">
                                            <div class="card-body pl-0 pr-0">
                                                <a href="{{ route('post.show', ['slug' => $post->postable->slug]) }}" class="bank-card-header">{{ $post->title }}</a>
                                                <span class="bank-card-location" style="display: block">{{ $post->postable->country }} / {{ $post->postable->district }}</span>
                                                <span class="bank-card-info" style="position: relative">
                                                    @if (isset($post->postable->house_type))
                                                        {{ config('enums.property_type')[$post->postable->property_type] }} - {{ config('enums.house_type')[$post->postable->house_type] }}
                                                    @endif
                                                    @if (isset($post->postable->workplace_type))
                                                        {{ config('enums.property_type')[$post->postable->property_type] }} - {{ config('enums.workplace_type')[$post->postable->workplace_type] }}
                                                    @endif
                                                    @if (isset($post->postable->land_type))
                                                        {{ config('enums.property_type')[$post->postable->property_type] }} - {{ config('enums.land_type')[$post->postable->land_type] }}
                                                    @endif
                                                </span>
                                                <span class="bank-card-info2" style="position: relative">{{ number_format($post->postable->net_m2, 0, '.', '.') }}m<sup>2</sup></span>
                                                <span class="bank-card-info3" style="position: relative">G. No: {{ $post->code }}</span>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-auto pl-0">
                                            <div class="d-flex flex-column bank-card-right-btn">
                                                <h3 class="bank-card-price mb-0x">{{ number_format($post->current_price, 0, '.', '.') }} TL</h3>
                                                <span class="bank-card-price-info">Başlangıç Bedeli</span>
                                                <a href="{{ route('post.show', ['slug' => $post->postable->slug]) }}" class="btn btn-danger btn-giver">Teklif Ver</a>
                                                <div class="bank-card-fg-div d-flex align-items-center">
                                                    <img src="{{ asset('assets/img/turkiye-finans/sand-watch.png') }}" alt="">
                                                    <h4 class="sand-icon mb-0">İLK TEKLİF BEKLENİYOR</h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @else
                            @if ($post->tender_status == 1)
                                @if($post->bank->code == 'ziraatkatilim')
                                    <div class="bank-card">
                                        <div class="row">
                                            <div class="col-12 col-md-auto">
                                                <div class="bank-card-img-div">
                                                    <a href="{{ route('post.show', ['slug' => $post->postable->slug]) }}">
                                                        @if (isset(Storage::allFiles($post->images_folder)[0]))
                                                            <img src="{{asset('storage/'.Storage::allFiles($post->images_folder)[0] )}}" class="card-img-top img-fluid bank-card-img" alt="Ürün Resmi">
                                                        @endif
                                                    </a>
                                                </div>
                                            </div>

                                            <div class="col-12 col-md-6 pl-0" style="max-width: 360px;">
                                                <div class="card-body pl-0 pr-0">
                                                    <a href="{{ route('post.show', ['slug' => $post->postable->slug]) }}" class="bank-card-header">{{ $post->title }}</a>
                                                    <span class="bank-card-location" style="display: block">{{ $post->postable->country }} / {{ $post->postable->district }}</span>
                                                    <span class="bank-card-info" style="position: relative">
                                                    @if (isset($post->postable->house_type))
                                                        {{ config('enums.property_type')[$post->postable->property_type] }} - {{ config('enums.house_type')[$post->postable->house_type] }}
                                                    @endif
                                                    @if (isset($post->postable->workplace_type))
                                                        {{ config('enums.property_type')[$post->postable->property_type] }} - {{ config('enums.workplace_type')[$post->postable->workplace_type] }}
                                                    @endif
                                                    @if (isset($post->postable->land_type))
                                                        {{ config('enums.property_type')[$post->postable->property_type] }} - {{ config('enums.land_type')[$post->postable->land_type] }}
                                                    @endif
                                                    </span>
                                                    <span class="bank-card-info2" style="position: relative">{{ number_format($post->postable->net_m2, 0, '.', '.') }}m<sup>2</sup></span>
                                                    <span class="bank-card-info3" style="position: relative">G. No: {{ $post->code }}</span>
                                                </div>
                                            </div>

                                            @if ($post->diffinseconds)
                                                <div class="timer-position-div" id="clockdiv-{{ $post->id }}">
                                                    <div class="d-flex">
                                                        <div style="width: 65px">
                                                            <span class="timer-span1">KALAN SÜRE</span>
                                                        </div>
                                                        <div>

                                                            <div class="d-flex timer-main-div">
                                                                <div>
                                                                    <span style="font-weight: 600" class="days"></span>
                                                                    <span style="font-size: 11px;color: darkgrey;">Gün</span>
                                                                </div>
                                                                <div>
                                                                    <span style="font-weight: 600" class="hours"></span>
                                                                    <span style="font-size: 11px;color: darkgrey;">SA</span>
                                                                </div>
                                                                <div>
                                                                    <span style="font-weight: 600" class="minutes"></span>
                                                                    <span style="font-size: 11px;color: darkgrey;">DK</span>
                                                                </div>
                                                                <div>
                                                                    <span style="font-weight: 600" class="seconds"></span>
                                                                    <span style="font-size: 11px;color: darkgrey;">SN</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="timer-right-bell">
                                                            <i class="fas fa-bell" style="font-size: 15px;"></i>
                                                            <div>Teklif Var</div>
                                                        </div>

                                                        <script>
                                                            var diffInSeconds = {!! $post->diffinseconds !!};
                                                            var postId = {!! $post->id !!};
                                                            function getTimeRemaining(endtime) {
                                                                var t = Date.parse(endtime) - Date.parse(new Date());
                                                                var seconds = Math.floor((t / 1000) % 60);
                                                                var minutes = Math.floor((t / 1000 / 60) % 60);
                                                                var hours = Math.floor((t / (1000 * 60 * 60)) % 24);
                                                                var days = Math.floor(t / (1000 * 60 * 60 * 24));
                                                                return {
                                                                    'total': t,
                                                                    'days': days,
                                                                    'hours': hours,
                                                                    'minutes': minutes,
                                                                    'seconds': seconds
                                                                };
                                                            }
                                                        
                                                            function initializeClock(id, endtime) {
                                                                
                                                                var clock = document.getElementById(id);
                                                                
                                                                var daysSpan = clock.querySelector('.days');
                                                                
                                                                var hoursSpan = clock.querySelector('.hours');
                                                                var minutesSpan = clock.querySelector('.minutes');
                                                                var secondsSpan = clock.querySelector('.seconds');
                                                        
                                                                function updateClock() {
                                                                    var t = getTimeRemaining(endtime);
                                                                    
                                                                    daysSpan.innerHTML = t.days;
                                                                    hoursSpan.innerHTML = ('0' + t.hours).slice(-2);
                                                                    minutesSpan.innerHTML = ('0' + t.minutes).slice(-2);
                                                                    secondsSpan.innerHTML = ('0' + t.seconds).slice(-2);
                                                        
                                                                    if (t.total <= 0) {
                                                                        clearInterval(timeinterval);
                                                                    }
                                                                }
                                                                var timeinterval = setInterval(updateClock, 1000);
                                                                updateClock();
                                                            }
                                                        
                                                            var deadline = new Date(Date.parse(new Date()) + diffInSeconds * 1000);
                                                            initializeClock('clockdiv-'+ postId, deadline);
                                                        </script>
                                                    </div>
                                                </div>
                                            @endif

                                            <div class="col-12 col-md-auto pl-0">
                                                <div class="d-flex flex-column bank-card-right-btn">
                                                    <h3 class="bank-card-price mb-0x">{{ number_format($post->start_price, 0, '.', '.') }} TL</h3>
                                                    <span class="bank-card-price-info">Başlangıç Bedeli</span>
                                                    <a href="{{ route('post.show', ['slug' => $post->postable->slug]) }}" class="btn btn-danger btn-giver">Teklif Ver</a>
                                                    <div class="bank-card-fg-div2 d-flex align-items-center justify-content-center flex-column">
                                                        <h5>{{ number_format($post->current_price, 0, '.', '.') }} TL</h5>
                                                        <span>TL / SON TEKLİF</span>
                                                    </div>
                                                </div>  
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @endif
                        @endif
                        
                    @endforeach

                @else
                    {{-- TEKLİF BEKLENİYOR --}}
                    @foreach ($nonOfferedPosts as $post)
                        
                        @if($post->bank->code == 'ziraatkatilim')
                            <div class="bank-card">
                                <div class="row">
                                    <div class="col-12 col-md-auto">
                                        <div class="bank-card-img-div">
                                            <a href="{{ route('post.show', ['slug' => $post->postable->slug]) }}">
                                                @if (isset(Storage::allFiles($post->images_folder)[0]))
                                                    <img src="{{asset('storage/'.Storage::allFiles($post->images_folder)[0] )}}" class="card-img-top img-fluid bank-card-img" alt="Ürün Resmi">
                                                @endif
                                            </a>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 pl-0" style="max-width: 360px;">
                                        <div class="card-body pl-0 pr-0">
                                            <a href="{{ route('post.show', ['slug' => $post->postable->slug]) }}" class="bank-card-header">{{ $post->title }}</a>
                                            <span class="bank-card-location" style="display: block">{{ $post->postable->country }} / {{ $post->postable->district }}</span>
                                            <span class="bank-card-info" style="position: relative">
                                                @if (isset($post->postable->house_type))
                                                    {{ config('enums.property_type')[$post->postable->property_type] }} - {{ config('enums.house_type')[$post->postable->house_type] }}
                                                @endif
                                                @if (isset($post->postable->workplace_type))
                                                    {{ config('enums.property_type')[$post->postable->property_type] }} - {{ config('enums.workplace_type')[$post->postable->workplace_type] }}
                                                @endif
                                                @if (isset($post->postable->land_type))
                                                    {{ config('enums.property_type')[$post->postable->property_type] }} - {{ config('enums.land_type')[$post->postable->land_type] }}
                                                @endif
                                            </span>
                                            <span class="bank-card-info2" style="position: relative">{{ number_format($post->postable->net_m2, 0, '.', '.') }}m<sup>2</sup></span>
                                            <span class="bank-card-info3" style="position: relative">G. No: {{ $post->code }}</span>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-auto pl-0">
                                        <div class="d-flex flex-column bank-card-right-btn">
                                            <h3 class="bank-card-price mb-0x">{{ number_format($post->current_price, 0, '.', '.') }} TL</h3>
                                            <span class="bank-card-price-info">Başlangıç Bedeli</span>
                                            <a href="{{ route('post.show', ['slug' => $post->postable->slug]) }}" class="btn btn-danger btn-giver">Teklif Ver</a>
                                            <div class="bank-card-fg-div d-flex align-items-center">
                                                <img src="{{ asset('assets/img/turkiye-finans/sand-watch.png') }}" alt="">
                                                <h4 class="sand-icon mb-0">İLK TEKLİF BEKLENİYOR</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                        
                    @endforeach
                
                    {{-- TEKLİF VERİLDİ  --}}
                    @foreach ($offeredPosts as $post)
                        @if ($post->tender_status == 1)
                            @if($post->code == 'ziraatkatilim')
                                <div class="bank-card">
                                    <div class="row">
                                        <div class="col-12 col-md-auto">
                                            <div class="bank-card-img-div">
                                                <a href="{{ route('post.show', ['slug' => $post->postable->slug]) }}">
                                                    @if (isset(Storage::allFiles($post->images_folder)[0]))
                                                        <img src="{{asset('storage/'.Storage::allFiles($post->images_folder)[0] )}}" class="card-img-top img-fluid bank-card-img" alt="Ürün Resmi">
                                                    @endif
                                                </a>
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-6 pl-0" style="max-width: 360px;">
                                            <div class="card-body pl-0 pr-0">
                                                <a href="{{ route('post.show', ['slug' => $post->postable->slug]) }}" class="bank-card-header">{{ $post->title }}</a>
                                                <span class="bank-card-location" style="display: block">{{ $post->postable->country }} / {{ $post->postable->district }}</span>
                                                <span class="bank-card-info" style="position: relative">
                                                @if (isset($post->postable->house_type))
                                                    {{ config('enums.property_type')[$post->postable->property_type] }} - {{ config('enums.house_type')[$post->postable->house_type] }}
                                                @endif
                                                @if (isset($post->postable->workplace_type))
                                                    {{ config('enums.property_type')[$post->postable->property_type] }} - {{ config('enums.workplace_type')[$post->postable->workplace_type] }}
                                                @endif
                                                @if (isset($post->postable->land_type))
                                                    {{ config('enums.property_type')[$post->postable->property_type] }} - {{ config('enums.land_type')[$post->postable->land_type] }}
                                                @endif
                                                </span>
                                                <span class="bank-card-info2" style="position: relative">{{ number_format($post->postable->net_m2, 0, '.', '.') }}m<sup>2</sup></span>
                                                <span class="bank-card-info3" style="position: relative">G. No: {{ $post->code }}</span>
                                            </div>
                                        </div>

                                        @if ($post->diffinseconds)
                                            <div class="timer-position-div" id="clockdiv-{{ $post->id }}">
                                                <div class="d-flex">
                                                    <div style="width: 65px">
                                                        <span class="timer-span1">KALAN SÜRE</span>
                                                    </div>
                                                    <div>

                                                        <div class="d-flex timer-main-div">
                                                            <div>
                                                                <span style="font-weight: 600" class="days"></span>
                                                                <span style="font-size: 11px;color: darkgrey;">Gün</span>
                                                            </div>
                                                            <div>
                                                                <span style="font-weight: 600" class="hours"></span>
                                                                <span style="font-size: 11px;color: darkgrey;">SA</span>
                                                            </div>
                                                            <div>
                                                                <span style="font-weight: 600" class="minutes"></span>
                                                                <span style="font-size: 11px;color: darkgrey;">DK</span>
                                                            </div>
                                                            <div>
                                                                <span style="font-weight: 600" class="seconds"></span>
                                                                <span style="font-size: 11px;color: darkgrey;">SN</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="timer-right-bell">
                                                        <i class="fas fa-bell" style="font-size: 15px;"></i>
                                                        <div>Teklif Var</div>
                                                    </div>

                                                    <script>
                                                        var diffInSeconds = {!! $post->diffinseconds !!};
                                                        var postId = {!! $post->id !!};
                                                        function getTimeRemaining(endtime) {
                                                            var t = Date.parse(endtime) - Date.parse(new Date());
                                                            var seconds = Math.floor((t / 1000) % 60);
                                                            var minutes = Math.floor((t / 1000 / 60) % 60);
                                                            var hours = Math.floor((t / (1000 * 60 * 60)) % 24);
                                                            var days = Math.floor(t / (1000 * 60 * 60 * 24));
                                                            return {
                                                                'total': t,
                                                                'days': days,
                                                                'hours': hours,
                                                                'minutes': minutes,
                                                                'seconds': seconds
                                                            };
                                                        }
                                                    
                                                        function initializeClock(id, endtime) {
                                                            
                                                            var clock = document.getElementById(id);
                                                            
                                                            var daysSpan = clock.querySelector('.days');
                                                            
                                                            var hoursSpan = clock.querySelector('.hours');
                                                            var minutesSpan = clock.querySelector('.minutes');
                                                            var secondsSpan = clock.querySelector('.seconds');
                                                    
                                                            function updateClock() {
                                                                var t = getTimeRemaining(endtime);
                                                                
                                                                daysSpan.innerHTML = t.days;
                                                                hoursSpan.innerHTML = ('0' + t.hours).slice(-2);
                                                                minutesSpan.innerHTML = ('0' + t.minutes).slice(-2);
                                                                secondsSpan.innerHTML = ('0' + t.seconds).slice(-2);
                                                    
                                                                if (t.total <= 0) {
                                                                    clearInterval(timeinterval);
                                                                }
                                                            }
                                                            var timeinterval = setInterval(updateClock, 1000);
                                                            updateClock();
                                                        }
                                                    
                                                        var deadline = new Date(Date.parse(new Date()) + diffInSeconds * 1000);
                                                        initializeClock('clockdiv-'+ postId, deadline);
                                                    </script>
                                                </div>
                                            </div>
                                        @endif

                                        <div class="col-12 col-md-auto pl-0">
                                            <div class="d-flex flex-column bank-card-right-btn">
                                                <h3 class="bank-card-price mb-0x">{{ number_format($post->start_price, 0, '.', '.') }} TL</h3>
                                                <span class="bank-card-price-info">Başlangıç Bedeli</span>
                                                <a href="{{ route('post.show', ['slug' => $post->postable->slug]) }}" class="btn btn-danger btn-giver">Teklif Ver</a>
                                                <div class="bank-card-fg-div2 d-flex align-items-center justify-content-center flex-column">
                                                    <h5>{{ number_format($post->current_price, 0, '.', '.') }} TL</h5>
                                                    <span>TL / SON TEKLİF</span>
                                                </div>
                                            </div>  
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endif
                    @endforeach
                @endisset

                
                
                <div class="content-bank-footer" style="margin-top: 120px;">
                    <p class="text-center">Gayrimenkullerle ilgili olarak Banka tarafından verilen tüm bilgiler, resimler, açıklamalar ve basında, internette yayınlanan her türlü ilanlar (satış listesi, tanıtım metni, gazete ilanı, internet, afiş vb.) taahhüt niteliğinde olmayıp genel bilgi niteliğindedir. Gayrimenkulün fiili durumuyla Banka tarafından verilen bilgilerin farklı olması halinde Banka’nın herhangi bir yükümlülüğü bulunmayacaktır. Müşteri, bu hususu kabul etmiş sayılır.</p>
                </div>
            </div>
        </div>
    @endif
@stop

@section('scripts')
    @parent
    <script>
        $('.money').mask("#.##0", {reverse: true});

        $(document).ready(function () {
            $('.js-select2-cities').select2({
                dropdownAutoWidth : true,
                // width: 'auto'
            });

            $('.district--search').hide();
            $('.district-all').hide();

            $('#languageSelect').change(function (e) {
                var count = $("#languageSelect :selected").length;
                var selectedSubject = $("#languageSelect option:selected").val();

                if (count > 1) {
                    $('.district--search').hide();
                    $('.district-all').show();
                }else if (count == 1) {
                    $('.district-all').hide();
                    $('.district--search').show();
                    console.log(selectedSubject);
                    $.ajax({
                        type:'GET',
                        url: "{!! route('home.getDistrictsHome', '') !!}" + "/" + selectedSubject,
                        success:function(data){
                            console.log(data);
                            $('.js-select2-district').empty().select2({
                                dropdownAutoWidth : true,
                                width: 'auto',
                                placeholder: "Lütfen İlçe Seçiniz",
                                data: data
                            });
                            $('.js-select2-district').val(1).trigger('change.select2');
                        }
                    });
                    //ajax
                } 
                else {
                    $('.district--search').hide();
                    $('.district-all').hide();
                }
            });

            $('._mobile--btn-ziraat-click').click(function (e) {
                $('._mobile--responive').fadeIn();
                $(this).hide();
                $('._mobile--btn-ziraat-click-hide').show();
            });

            $('._mobile--btn-ziraat-click-hide').click(function (e) { 
                $('._mobile--responive').fadeOut();
                $(this).hide();
                $('._mobile--btn-ziraat-click').show();
            });
            
            // $('.btn_favourite').click(function(){
            //     var slug = $(this).data("slug");
            //     var id = $(this).attr('id');
            //     //var berk = $(this).dataset.slug;
            //     //var berk = article.dataset.slug;
            //     $.ajax({
            //         type:'GET',
            //         url: "{!! route('updateFavoritePosts', '') !!}" + "/" + slug,
            //         success:function(data){
            //             if(data){
            //                 $("#" + id).attr('data-bs-original-title', 'Favorilerimden çıkar.').tooltip('show');
            //             }
            //             else{
            //                 $("#" + id).attr('data-bs-original-title', 'Favorilerime ekle.').tooltip('show');
            //             }
            //         }
            //     });
            // });
        });        
    </script>
@endsection