<!DOCTYPE html>
<html lang="zxx">
    <head>
        <meta name="yandex-verification" content="4d4641c993eb093c" />
        <meta charset="UTF-8"/>
        <meta http-equiv="X-UA-Compatible" content="ie=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link href="{{ asset('assets/img/favicon.jpeg') }}" rel="shortcut icon"/>

        {{-- Get full url --}}
        @php
            // $routeName = Request::url();
            // dd($routeName);
            // $url = 3;
        @endphp

        <title>@yield('title')</title>

        @include('layout.include-css')
        <!--[if lt IE 9]><script src="assets/html5shiv.min.js"></script><![endif]-->
        <link rel="stylesheet" href="https://phpcoder.tech/multiselect/css/jquery.multiselect.css">
        @yield('styles')
        <style>
            /* .hover-navlink{
                color: #878C93 !important;
            } */
            .auth-btn{
                background-color: #0d6efd;
                border-color: #0d6efd;
                color: white !important;
                font-weight: 600;
                width: 150px;
                height: 45px;
                display: flex;
                flex-direction: row;
                align-items: center;
                justify-content: center;
            }
            .hover-navlink:hover{
                background-color: white !important;
                border-color: #0d6efd !important;
                color: #0d6efd !important;
            }
            .list-a-btn{
                color: black;
                background-color: white;
            }

            .propturk-logo{
                width: 250px;
            }

            .cookies-policy-row{
                position: fixed;
                bottom: 14px;
                width: 100%;
                z-index: 3;
            }

            .cookies-policy-div{
                width: 550px;
                padding:17px;
                background: rgba(0,0,0,0.9);
            }

            .cookies-policy-title{
                color: white;
                font-size: 12px;
                font-weight:600;
            }

            .cookies-policy-btn{
                background: white;
                border-color: white;
            }

            @media screen and (max-width:900px) {
                .propturk-logo{
                    width: 200px;
                }

                .propturk-logo-menu{
                    width: 180px;
                }

                .d-none-login-register{
                    display: none !important;
                }
                .compare_box{
                    display: none !important;
                }
                .cookies-policy-title{
                    font-size: 9px;
                }
                .cookies-policy-btn{
                    font-size: 12px;
                }
            }

            

            /* #loader {
                border: 12px solid #f3f3f3;
                border-radius: 50%;
                border-top: 12px solid #444444;
                width: 70px;
                height: 70px;
                animation: spin 1s linear infinite;
            }
            
            @keyframes spin {
                100% {
                    transform: rotate(360deg);
                }
            }
            
            .loader-center {
                position: absolute;
                top: 0;
                bottom: 0;
                left: 0;
                right: 0;
                margin: auto;
            } */

            .ms-options{
                max-height: 270px !important;
            }

            .ms-options ul{
                list-style: none;
                padding-left: 0px;
            }

            .ms-options-wrap > .ms-options > ul input[type="checkbox"]{
                top: 13px;
            }

            .ms-options-wrap > button:focus, .ms-options-wrap > button{
                color: black;
                border: 1px solid #e2e2e2;
                padding: 0.8em 1em;
                height: 42px;
                border-radius: 5px;
            }

            .ms-options-wrap > .ms-options{
                border: 1px solid #ddd;
            }

            .ms-options-wrap > .ms-options > ul label{
                font-size: 13px;
            }

            .border-btm{
                border-bottom: 1px solid #ddd;
            }
            
        </style>

        {{-- Ziraat Bankası İçin Renk/Img Değişikliği Yapılacak --}}
        @if (session('subdomain') == 'ziraatkatilim')
            <link rel="stylesheet" href="{{ asset('css/ziraat.css') }}">
            <style>
                .auth-btn{
                    background-color: #0d243b !important;
                }   
            </style>
        @endif

        @if (session('subdomain') == 'turkiyefinanskatilim')
            <link rel="stylesheet" href="{{ asset('css/tr-finans.css') }}">
        @endif
    </head>
    <body>
        {{-- <div id="loader" class="loader-center"></div> --}}

        @if (request()->hasCookie('propturk_cookie') != true)
            {{-- COOKIES --}}
            <div class="container-fluid remove-cookies">
                <div class="row cookies-policy-row">
                    <div class="col-12 text-center d-flex justify-content-center">
                        <div class="d-flex cookies-policy-div">
                            <p class="mb-0 cookies-policy-title">Çerezler ile toplanan kişisel verileriniz, <a href="{{ route('cookiesPolicy') }}" style="color: white;">çerez politikamızda</a> belirtilen amaçlarla sınırlı ve mevzuata uygun şekilde kullanılacaktır.</p>
                            <button class="btn btn-info cookies-policy-btn">Kapat</button>
                        </div>
                    </div>
                </div>
            </div>
        @endif
       
        {{-- Finans Bankası İçin --}}
        @if (session('subdomain') == 'turkiyefinanskatilim')
            <!-- start header -->
            <header class="main_header d-print-none">
                <h1 class="sr-only">Propturk</h1>

                <div class="header_bottom slow_7s py-2 shadow-sm bg-white w-100">
                    <div class="container">
                        <nav class="d-flex justify-content-between no-gutters align-items-center">
                            <h2 class="sr-only">Propturk</h2>
                            <a class="main_brand d-inline-block" href="/" title="PropTurk Anasayfa">
                                <img class="d-block propturk-logo" src="{{ asset('assets/img/turkiye-finans/header_logo.png') }}" alt="Propturk" title="Propturk"/>
                            </a>
                            <div class="d-flex" style="align-items: center;">
                                <div class="d-none d-xl-inline-block">
                                    <ul class="main_nav list-unstyled mb-0 pr-0">
                                        <li class="float-left">
                                            <a class="btn btn-outline-dark border-0 py-3 font-weight-bold hover-navlink" title="" href="{{ url(env('APP_URL')) }}">
                                                Ana Sayfa
                                            </a>
                                        </li>
                                        <li class="float-left position-relative has_sub">
                                            <a class="btn btn-outline-dark border-0 py-3 font-weight-bold hover-navlink">
                                                Hakkımızda
                                            </a>
                                            <ul class="list-unstyled position-absolute slow_3s shadow-sm" style="border: 1px solid #5e6278;border-radius: 12px;">
                                                <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('aboutus') }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Biz Kimiz
                                                    </a>
                                                </li>
                                                <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('ourjob') }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Ne Yapıyoruz?
                                                    </a>
                                                </li>
                                                <li class="w-100" style="border-radius: 0px !important;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('buy-realestate') }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Gayrimenkulü Nasıl Edinirim?
                                                    </a>
                                                </li>
                                            </ul>
                                        </li>
                                        <li class="float-left">
                                            <a class="btn btn-outline-dark border-0 py-3 font-weight-bold hover-navlink" title="" href="{{ route('contact') }}">
                                                İletişim
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                @auth
                                    <div class="d-none d-md-inline-block">
                                        <ul class="main_nav list-unstyled mb-0 pr-0">
                                            <li class="float-left position-relative has_sub">
                                                <a class="btn btn-outline-dark border-0 py-3 font-weight-bold auth-btn" title="">
                                                    {{ Auth::user()->name }} {{ Auth::user()->surname }}
                                                </a>
                                                @if (Auth::user()->is_admin == 1 || Auth::user()->is_admin == 2)
                                                    <ul class="list-unstyled position-absolute slow_3s shadow-sm" style="border-radius: 12px;border: 1px solid #5e6278;">
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn"  style="border-radius: 0px !important;" title="" href="{{ route('admin.home') }}">
                                                                <i class="fas fa-chevron-right mr-2"></i> Admin Paneli
                                                            </a>
                                                        </li>
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                            document.getElementById('logout-form').submit();">
                                                                <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                            </a>
                                                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                                @csrf
                                                            </form>
                                                        </li>
                                                    </ul>
                                                @else
                                                    <ul class="list-unstyled position-absolute slow_3s shadow-sm" style="border-radius: 12px;border: 1px solid #5e6278;">

                                                        @if (!Auth::user()->is_active)
                                                            <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                                <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;"  href="{{ route('user.smsPage', ['slug' => Auth::user()->slug]) }}">
                                                                    <i class="fas fa-chevron-right mr-2"></i> Hesap Aktivasyonu
                                                                </a>
                                                            </li>
                                                        @endif
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn"  style="border-radius: 0px !important;" title="" href="{{ route('user.show', ['slug' => Auth::user()->slug]) }}">
                                                                <i class="fas fa-chevron-right mr-2"></i> Kullanıcı Bilgileri
                                                            </a>
                                                        </li>
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('user.showUserTenders', ['slug' => Auth::user()->slug]) }}">
                                                                <i class="fas fa-chevron-right mr-2"></i> Tekliflerim ve Favorilerim
                                                            </a>
                                                        </li>
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                            document.getElementById('logout-form').submit();">
                                                                <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                            </a>
                                                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                                @csrf
                                                            </form>
                                                        </li>
                                                    </ul>
                                                @endif
                                                
                                            </li>
                                        </ul>
                                    </div>
                                @endauth


                                @guest
                                    <div class="d-flex d-none-login-register" style="grid-gap: 10px;">
                                        <a class="btn btn-outline-primary" href="{{ route('login') }}" style="width: 100px;height: 45px;
                                        display: flex;
                                        flex-direction: row;
                                        align-items: center;
                                        justify-content: center;" title="Giriş Yap">Giriş</a>
                                        <a class="btn btn-primary" style="width: 100px;height: 45px;
                                        display: flex;
                                        flex-direction: row;
                                        align-items: center;
                                        justify-content: center;" href="{{ route('register') }}">Kayıt Ol</a>
                                    </div>
                                @endguest
                                
                                <div class="d-xl-none">
                                    <div class="nav-icon menu_action">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </div>
                                </div>
                            </div>

                        </nav>
                    </div>
                </div>

                <!-- menu mobile -->
                <div class="menu_mobile_box position-fixed d-block w-100 slow_3s">
                    <div class="main_nav_mobile position-fixed bg-white accordion py-3" id="accordion_menumobile" style="padding-left: 5px;padding-right: 5px !important;">
                        
                        <div class="d-block">
                            <a class="main_brand d-inline-block" href="/" title="PropTurk Anasayfa">
                                <img class="d-block propturk-logo-menu" src="{{ asset('assets/img/logo.png') }}" alt="Propturk" title="Propturk"/>
                            </a>
                            <div class="nav-icon menu_action float-right d-block mb-3">
                                <span></span>
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </div>
                        <ul class="list-unstyled mb-0 pr-0" style="margin-top: 20px;padding-left: 5px;padding-right: 5px !important;">
                            @auth
                                @if (Auth::user()->is_admin == 1 || Auth::user()->is_admin == 2)
                                    <li class="has_sub" style="border-top: 1px solid #ddd;">
                                        <a
                                            class="btn btn-outline-dark border-0 w-100 text-left py-4 font-weight-bold"
                                            title="Property"
                                            href=""
                                            data-toggle="collapse"
                                            data-target="#login-1"
                                            aria-expanded="false"
                                            aria-controls="collapse-1"
                                            style="text-decoration: underline;">
                                            {{ Auth::user()->name }} {{ Auth::user()->surname }}
                                        </a>
                                        <ul id="login-1"
                                            class="collapse slow_3s list-unstyled pl-2 py-2 border-bottom border-dark"
                                            data-parent="#accordion_menumobile"
                                            >
                                        
                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('admin.home') }}">
                                                    <i class="fas fa-chevron-right mr-2"></i> Admin Paneli
                                                </a>
                                            </li>

                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                document.getElementById('logout-form').submit();">
                                                    <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                </a>
                                                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                    @csrf
                                                </form>
                                            </li>
                                        </ul>
                                    </li>
                                @else
                                    <li class="has_sub" style="border-top: 1px solid #ddd;">
                                        <a
                                            class="btn btn-outline-primary border-0 w-100 text-left py-4 font-weight-bold"
                                            title="Property"
                                            href=""
                                            data-toggle="collapse"
                                            data-target="#login-1"
                                            aria-expanded="false"
                                            aria-controls="collapse-1" style="text-decoration: underline;"
                                            >
                                            {{ Auth::user()->name }} {{ Auth::user()->surname }}
                                        </a>
                                        <ul id="login-1"
                                            class="collapse slow_3s list-unstyled pl-2 py-2 pr-2 border-bottom border-dark"
                                            data-parent="#accordion_menumobile"
                                            >
                                            @if (!Auth::user()->is_active)
                                                <li class="list-inline-item">
                                                    <a class="btn btn-outline-primary border-0 w-100 text-left py-3" href="{{ route('user.smsPage', ['slug' => Auth::user()->slug]) }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Hesap Aktivasyonu
                                                    </a>
                                                </li>
                                            @endif
                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-primary border-0 w-100 text-left py-3" href="{{ route('user.show', ['slug' => Auth::user()->slug]) }}">
                                                    <i class="fas fa-chevron-right mr-2"></i> Kullanıcı Bilgileri
                                                </a>
                                            </li>
                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-primary border-0 w-100 text-left py-3" href="{{ route('user.showUserTenders', ['slug' => Auth::user()->slug]) }}">
                                                    <i class="fas fa-chevron-right mr-2"></i> Tekliflerim ve Favorilerim
                                                </a>
                                            </li>
                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-primary border-0 w-100 text-left py-3" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                document.getElementById('logout-form').submit();">
                                                    <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                </a>
                                                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                    @csrf
                                                </form>
                                            </li>
                                        </ul>
                                    </li>
                                @endif
                            @endauth
                            

                            <li class="list-inline-item" style="border-bottom: 1px solid #ddd;border-top: 1px solid #ddd;">
                                <a class="btn btn-outline-dark border-0 w-100 text-left py-4 font-weight-bold" href="{{ route('home') }}" title="Anasayfa">
                                    Anasayfa
                                </a>
                            </li>

                            <li class="has_sub" style="border-bottom: 1px solid #ddd;">
                                <a
                                    class="btn btn-outline-dark border-0 w-100 text-left py-4 font-weight-bold"
                                    title="Property"
                                    href="property-search.html"
                                    data-toggle="collapse"
                                    data-target="#collapse-1"
                                    aria-expanded="false"
                                    aria-controls="collapse-1"
                                    >
                                    Hakkımızda
                                </a>
                                <ul
                                    id="collapse-1"
                                    class="collapse slow_3s list-unstyled pl-2 py-2 border-bottom border-dark"
                                    data-parent="#accordion_menumobile"
                                    >
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('aboutus') }}">
                                            <i class="fas fa-chevron-right mr-2"></i> Biz Kimiz
                                        </a>
                                    </li>
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('ourjob') }}">
                                            <i class="fas fa-chevron-right mr-2"></i> Ne Yapıyoruz?
                                        </a>
                                    </li>
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('buy-realestate') }}">
                                            <i class="fas fa-chevron-right mr-2"></i> Gayrimenkulü Nasıl Edinirim?
                                        </a>
                                    </li>
                                </ul>
                            </li>

                            {{-- <li class="has_sub">
                                <a
                                    class="btn btn-outline-dark border-0 w-100 text-left py-4 font-weight-bold"
                                    title="Blog"
                                    href="JavaScript:Void(0);"
                                    data-toggle="collapse"
                                    data-target="#collapse-2"
                                    aria-expanded="false"
                                    aria-controls="collapse-2"
                                    >
                                    Blog
                                </a>
                                <ul
                                    id="collapse-2"
                                    class="collapse slow_3s list-unstyled pl-2 py-2 border-bottom border-dark"
                                    data-parent="#accordion_menumobile"
                                    >
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" title="" href="blog-home.html">
                                            <i class="fas fa-chevron-right mr-2"></i> Blog - Home
                                        </a>
                                    </li>
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" title="" href="blog-single.html">
                                            <i class="fas fa-chevron-right mr-2"></i> Blog - Single
                                        </a>
                                    </li>
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" title="" href="blog-search.html">
                                            <i class="fas fa-chevron-right mr-2"></i> Blog - Search
                                        </a>
                                    </li>
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" title="" href="blog-category.html">
                                            <i class="fas fa-chevron-right mr-2"></i> Blog - Category
                                        </a>
                                    </li>
                                </ul>
                            </li> --}}

                            <li class="list-inline-item" style="border-bottom: 1px solid #ddd;">
                                <a class="btn btn-outline-dark border-0 w-100 text-left py-4 font-weight-bold" href="{{ route('contact') }}">
                                    İletişim
                                </a>
                            </li>
                        </ul>
                        @guest
                            <div class="px-1 mt-3">
                                <a class="btn btn-block btn-outline-success p-3" href="{{ route('login') }}">Giriş Yap</a>
                                <a class="btn btn-block btn-success p-3 mt-2" href="{{ route('register') }}">Kayıt Ol</a>
                            </div>
                        @endguest

                        {{-- @auth
                            <div class="d-md-inline-block" style="margin-top: 20px;">
                                <ul class="main_nav list-unstyled mb-0 pr-0">
                                    <li class="float-left position-relative has_sub" style="padding-left: 10px;padding-right:10px;">
                                        <a class="btn btn-outline-dark border-0 py-3 font-weight-bold auth-btn" style="width: 100%;">
                                            {{ Auth::user()->name }} {{ Auth::user()->surname }}
                                        </a>
                                        @if (Auth::user()->is_admin == 1)
                                            <ul class="list-unstyled position-absolute slow_3s shadow-sm" style="border-radius: 12px;border: 1px solid #5e6278;">
                                                <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn"  style="border-radius: 0px !important;" title="" href="{{ route('admin.home') }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Admin Paneli
                                                    </a>
                                                </li>
                                                <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                    document.getElementById('logout-form').submit();">
                                                        <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                    </a>
                                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                        @csrf
                                                    </form>
                                                </li>
                                            </ul>
                                        @else
                                            <ul class="list-unstyled position-absolute slow_3s shadow-sm" style="border-radius: 12px;border: 1px solid #5e6278;">

                                                @if (!Auth::user()->is_active)
                                                    <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                        <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;"  href="{{ route('user.smsPage', ['slug' => Auth::user()->slug]) }}">
                                                            <i class="fas fa-chevron-right mr-2"></i> Hesap Aktivasyonu
                                                        </a>
                                                    </li>
                                                @endif
                                                <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn"  style="border-radius: 0px !important;" title="" href="{{ route('user.show', ['slug' => Auth::user()->slug]) }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Kullanıcı Bilgileri
                                                    </a>
                                                </li>
                                                <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('user.showUserTenders', ['slug' => Auth::user()->slug]) }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Tekliflerim ve Favorilerim
                                                    </a>
                                                </li>
                                                <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                    document.getElementById('logout-form').submit();">
                                                        <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                    </a>
                                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                        @csrf
                                                    </form>
                                                </li>
                                            </ul>
                                        @endif
                                        
                                    </li>
                                </ul>
                            </div>
                        @endauth --}}
                    </div>
                </div>
            </header>
            <!-- end header-->

            <div class="container-fluid">
                @yield('content')
            </div>

            <!-- start main footer -->
            <footer class="main_footer bg-dark text-light d-print-none">
                <div class="container">
                    <div class="row pt-5">
                        <div class="col-sm-6 col-lg-3 pb-5">
                            <a class="main_brand d-inline-block mb-3 w-100" href="{{ route('home') }}" title="propturk - Ana Sayfa">
                                <img class="d-block w-100" src="{{ asset('assets/img/logo-footer.png') }}" alt="" title=""/>
                            </a>
                            <div>
                                <p class="h5 font-weight-bold footer_title mb-4" style="margin-bottom: 0.5px !important;">Ekibimiz</p>
                                <p style="font-size: 14px;">
                                    Ekibimizde yer alan şehir plancıları, mimarlar, inşaat mühendisleri, iktisatçılar ve gayrimenkul değerleme uzmanları ile birlikte oluşturduğumuz multi disipliner bir anlayışla kurumsal firmaların portföylerinde yer alan gayrimenkullerin teknolojik altyapı ve yapay zeka kullanımı ile gayrimenkul ekosistemini (danışmanlık, yönetim, pazarlama ve satış süreci) oluşturmak ve firmalara kaynak sağlamak hedefiyle kurulduk.
                                </p>
                            </div>
                        </div>

                        <div class="col-sm-6 col-lg-3 pb-5">
                            <p class="h5 font-weight-bold footer_title mb-4">Hızlı Ulaşım</p>

                            <ul class="list-unstyled">
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="" title="">
                                        <i class="fas fa-angle-double-right"></i> Biz Kimiz
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="" title="">
                                        <i class="fas fa-angle-double-right"></i> Ne Yapıyoruz?
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="" title="">
                                        <i class="fas fa-angle-double-right"></i> Gayrimenkulü Nasıl Edinirim?
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="" title="">
                                        <i class="fas fa-angle-double-right"></i> İletişim
                                    </a>
                                </li>
                            </ul>
                        </div>

                        <div class="col-sm-6 col-lg-3 pb-5">
                            <p class="h5 font-weight-bold footer_title mb-4">İletişim</p>
                            <ul class="list-unstyled">
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="tel:05332952118" title="Phone">
                                        <i class="fas fa-phone-alt mr-2"></i>0 (533) 295 21 18
                                    </a>
                                </li>
                                {{-- <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="#"  title="Whatsapp">
                                        <i class="fab fa-whatsapp mr-2"></i> (88) 98888-8888
                                    </a>
                                </li> --}}
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1 text_small" href="mailto:info@propturk.com" title="E-mail">
                                        <i class="far fa-envelope mr-2"></i> info@propturk.com
                                    </a>
                                </li>
                                {{-- <li class="list-inline-item">
                                    <a class="btn btn-lg btn-dark" href="#" title="Facebook" >
                                        <i class="fab fa-facebook-f"></i>
                                    </a>
                                    <a class="btn btn-lg btn-dark" href="#" title="Youtube" >
                                        <i class="fab fa-youtube"></i>
                                    </a>
                                    <a class="btn btn-lg btn-dark" href="#" title="Instagram" >
                                        <i class="fab fa-instagram"></i>
                                    </a>
                                    <a class="btn btn-lg btn-dark" href="#" title="Twitter" >
                                        <i class="fab fa-twitter"></i>
                                    </a>
                                </li> --}}
                            </ul>
                        </div>

                        <div class="col-sm-6 col-lg-3 pb-5">
                            <p class="h5 font-weight-bold footer_title mb-4">Özel Sayfalar</p>

                            <ul class="list-unstyled">
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="https://odeabank.propturk.com" title="">
                                        <i class="fas fa-angle-double-right"></i> Odeabank
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="https://ziraatkatilim.propturk.com" title="">
                                        <i class="fas fa-angle-double-right"></i> Ziraat Katılım
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="https://turkiyefinanskatilim.propturk.com" title="">
                                        <i class="fas fa-angle-double-right"></i> Türkiye Finans Katılım
                                    </a>
                                </li>
                            </ul>

                            {{--  <form action="#" method="post" class="validate" novalidate="">
                                <div class="input-group input-group-lg w-100">
                                    <input type="text" class="form-control bg-dark" placeholder="Enter e-mail address" required>
                                    <div class="input-group-prepend">
                                        <button class="input-group-text btn bg-primary text-white border border-primary">
                                            <i class="far fa-paper-plane"></i>
                                        </button>
                                    </div>
                                </div>
                            </form>  --}}
                        </div>
                    </div>
                </div>
                {{-- <div class="content_copy bg-primary text-light text-center py-3">
                    <div class="container text_small">
                        MaxRealty © 2020. All rights reserved.
                    </div>
                </div> --}}
            </footer>
            <!-- end main footer -->

        {{-- Ziraat Bankası İçin --}}
        @elseif(session('subdomain') == 'ziraatkatilim')
            <!-- start header -->
            <header class="bank-header-fixed d-print-none">
                {{-- <h1 class="sr-only">Propturk</h1> --}}

                <div class="header_bottom bg-white w-100">
                    <div class="container pl-0 pr-0" style="max-width: 1127px;">
                        <nav class="d-flex justify-content-between no-gutters align-items-center">
                            {{-- <h2 class="sr-only">Propturk</h2> --}}
                            <a class="main_brand d-inline-block" href="/" title="PropTurk Anasayfa">
                                <img class="d-block propturk-logo" src="{{ asset('assets/img/ziraat/header_logo.png') }}" alt="Propturk" title="Propturk"/>
                            </a>
                            <div class="d-flex" style="align-items: center;">
                                <div class="d-none d-xl-inline-block">
                                    <ul class="main_nav list-unstyled mb-0 pr-0">
                                        <li class="float-left bank-header-link bank-header-link-a">
                                            <a title="Ara" class="bank-header-after-a" href="tel:+90 533 295 21 18">
                                                {{-- <span> --}}
                                                    <i class="fa fa-phone" aria-hidden="true" style="transform: rotate(90deg);font-size:12px;position: relative;top:-2px;"></i>  
                                                    +90 533 295 21 18
                                                {{-- </span> --}}
                                                
                                            </a>
                                        </li>
                                        <li class="float-left bank-header-link bank-header-link-a">
                                            <a class="bank-header-after-a" title="Mail At" href="mailto:info@propturk.com">
                                                <i class="far fa-envelope"></i> info@propturk.com
                                            </a>
                                        </li>
                                        <li class="float-left bank-header-link bank-header-link-a">
                                            <a title="Yardım" href="" class="bank-header-after-a">
                                                <i class="fas fa-info" style="font-size: 12px;"></i> Yardım
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                {{-- @auth
                                    <div class="d-none d-md-inline-block">
                                        <ul class="main_nav list-unstyled mb-0 pr-0">
                                            <li class="float-left position-relative has_sub">
                                                <a class="btn btn-outline-dark border-0 py-3 font-weight-bold auth-btn" title="">
                                                    {{ Auth::user()->name }} {{ Auth::user()->surname }}
                                                </a>
                                                @if (Auth::user()->is_admin == 1 || Auth::user()->is_admin == 2)
                                                    <ul class="list-unstyled position-absolute slow_3s shadow-sm" style="border-radius: 12px;border: 1px solid #5e6278;">
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn"  style="border-radius: 0px !important;" title="" href="{{ route('admin.home') }}">
                                                                <i class="fas fa-chevron-right mr-2"></i> Admin Paneli
                                                            </a>
                                                        </li>
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                            document.getElementById('logout-form').submit();">
                                                                <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                            </a>
                                                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                                @csrf
                                                            </form>
                                                        </li>
                                                    </ul>
                                                @else
                                                    <ul class="list-unstyled position-absolute slow_3s shadow-sm" style="border-radius: 12px;border: 1px solid #5e6278;">

                                                        @if (!Auth::user()->is_active)
                                                            <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                                <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;"  href="{{ route('user.smsPage', ['slug' => Auth::user()->slug]) }}">
                                                                    <i class="fas fa-chevron-right mr-2"></i> Hesap Aktivasyonu
                                                                </a>
                                                            </li>
                                                        @endif
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn"  style="border-radius: 0px !important;" title="" href="{{ route('user.show', ['slug' => Auth::user()->slug]) }}">
                                                                <i class="fas fa-chevron-right mr-2"></i> Kullanıcı Bilgileri
                                                            </a>
                                                        </li>
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('user.showUserTenders', ['slug' => Auth::user()->slug]) }}">
                                                                <i class="fas fa-chevron-right mr-2"></i> Tekliflerim ve Favorilerim
                                                            </a>
                                                        </li>
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                            document.getElementById('logout-form').submit();">
                                                                <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                            </a>
                                                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                                @csrf
                                                            </form>
                                                        </li>
                                                    </ul>
                                                @endif
                                                
                                            </li>
                                        </ul>
                                    </div>
                                @endauth --}}


                                {{-- @guest
                                    <div class="d-flex d-none-login-register" style="grid-gap: 10px;">
                                        <a class="btn btn-outline-primary" href="{{ route('login') }}" style="width: 100px;height: 45px;
                                        display: flex;
                                        flex-direction: row;
                                        align-items: center;
                                        justify-content: center;" title="Giriş Yap">Giriş</a>
                                        <a class="btn btn-primary" style="width: 100px;height: 45px;
                                        display: flex;
                                        flex-direction: row;
                                        align-items: center;
                                        justify-content: center;" href="{{ route('register') }}">Kayıt Ol</a>
                                    </div>
                                @endguest --}}
                                
                                <div class="d-xl-none">
                                    <div class="nav-icon menu_action">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </div>
                                </div>
                            </div>

                        </nav>
                    </div>  
                    <div class="container-fluid bank-header2-cf">
                        <div class="container h-100 pl-0 pr-0" style="max-width: 1127px;">
                            <nav class="d-flex justify-content-end no-gutters align-items-center h-100">
                                {{-- <a class="main_brand d-flex justify-content-center align-items-center" style="background-color: #0d243b;height:44px;width:120px;color:white;text-decoration:none;" href="/" title="PropTurk Anasayfa">
                                    <i class="fas fa-home"></i>
                                    <span style="margin-left: 10px;">Ana Sayfa</span>
                                </a> --}}
                                {{-- <div class="d-flex" style="align-items: center;"> --}}
                                @guest
                                    <a href="{{ route('login') }}" class="main_brand d-flex justify-content-center align-items-center" style="background-color: #0d243b;height:44px;color:white;text-decoration:none;width:170px;border-radius:5px;" href="/" title="PropTurk Anasayfa">
                                        <img src="{{ asset('assets/img/ziraat/login-icon.png') }}" alt="">
                                        <span style="margin-left:5px;">Sisteme Giriş</span>
                                    </a>
                                @endguest
                                @auth
                                    <div class="d-none d-md-inline-block">
                                        <ul class="main_nav list-unstyled mb-0 pr-0">
                                            <li class="float-left position-relative has_sub">
                                                <a class="btn btn-outline-dark border-0 py-3 font-weight-bold auth-btn" title="">
                                                    {{ Auth::user()->name }} {{ Auth::user()->surname }}
                                                </a>
                                                @if (Auth::user()->is_admin == 1 || Auth::user()->is_admin == 2)
                                                    <ul class="list-unstyled position-absolute slow_3s shadow-sm" style="border-radius: 12px;border: 1px solid #5e6278;">
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn"  style="border-radius: 0px !important;" title="" href="{{ route('admin.home') }}">
                                                                <i class="fas fa-chevron-right mr-2"></i> Admin Paneli
                                                            </a>
                                                        </li>
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                            document.getElementById('logout-form').submit();">
                                                                <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                            </a>
                                                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                                @csrf
                                                            </form>
                                                        </li>
                                                    </ul>
                                                @else
                                                    <ul class="list-unstyled position-absolute slow_3s shadow-sm" style="border-radius: 12px;border: 1px solid #5e6278;">

                                                        @if (!Auth::user()->is_active)
                                                            <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                                <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;"  href="{{ route('user.smsPage', ['slug' => Auth::user()->slug]) }}">
                                                                    <i class="fas fa-chevron-right mr-2"></i> Hesap Aktivasyonu
                                                                </a>
                                                            </li>
                                                        @endif
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn"  style="border-radius: 0px !important;" title="" href="{{ route('user.show', ['slug' => Auth::user()->slug]) }}">
                                                                <i class="fas fa-chevron-right mr-2"></i> Kullanıcı Bilgileri
                                                            </a>
                                                        </li>
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('user.showUserTenders', ['slug' => Auth::user()->slug]) }}">
                                                                <i class="fas fa-chevron-right mr-2"></i> Tekliflerim ve Favorilerim
                                                            </a>
                                                        </li>
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                            document.getElementById('logout-form').submit();">
                                                                <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                            </a>
                                                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                                @csrf
                                                            </form>
                                                        </li>
                                                    </ul>
                                                @endif
                                                
                                            </li>
                                        </ul>
                                    </div>
                                @endauth


                                    {{-- @guest
                                        <div class="d-flex d-none-login-register" style="grid-gap: 10px;">
                                            <a class="btn btn-outline-primary" href="{{ route('login') }}" style="width: 100px;height: 45px;
                                            display: flex;
                                            flex-direction: row;
                                            align-items: center;
                                            justify-content: center;" title="Giriş Yap">Giriş</a>
                                            <a class="btn btn-primary" style="width: 100px;height: 45px;
                                            display: flex;
                                            flex-direction: row;
                                            align-items: center;
                                            justify-content: center;" href="{{ route('register') }}">Kayıt Ol</a>
                                        </div>
                                    @endguest --}}
                                    
                                    {{-- <div class="d-xl-none">
                                        <div class="nav-icon menu_action">
                                            <span></span>
                                            <span></span>
                                            <span></span>
                                            <span></span>
                                        </div>
                                    </div> --}}
                                {{-- </div> --}}

                            </nav>
                        </div>
                    </div>
                </div>

                <!-- menu mobile -->
                <div class="menu_mobile_box position-fixed d-block w-100 slow_3s">
                    <div class="main_nav_mobile position-fixed bg-white accordion py-3" id="accordion_menumobile" style="padding-left: 5px;padding-right: 5px !important;">
                        
                        <div class="d-block">
                            <a class="main_brand d-inline-block" href="/" title="PropTurk Anasayfa">
                                <img class="d-block propturk-logo-menu" src="{{ asset('assets/img/logo.png') }}" alt="Propturk" title="Propturk"/>
                            </a>
                            <div class="nav-icon menu_action float-right d-block mb-3">
                                <span></span>
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </div>
                        <ul class="list-unstyled mb-0 pr-0" style="margin-top: 20px;padding-left: 5px;padding-right: 5px !important;">
                            @auth
                                @if (Auth::user()->is_admin == 1 || Auth::user()->is_admin == 2)
                                    <li class="has_sub" style="border-top: 1px solid #ddd;">
                                        <a
                                            class="btn btn-outline-dark border-0 w-100 text-left py-4 font-weight-bold"
                                            title="Property"
                                            href=""
                                            data-toggle="collapse"
                                            data-target="#login-1"
                                            aria-expanded="false"
                                            aria-controls="collapse-1"
                                            style="text-decoration: underline;">
                                            {{ Auth::user()->name }} {{ Auth::user()->surname }}
                                        </a>
                                        <ul id="login-1"
                                            class="collapse slow_3s list-unstyled pl-2 py-2 border-bottom border-dark"
                                            data-parent="#accordion_menumobile"
                                            >
                                        
                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('admin.home') }}">
                                                    <i class="fas fa-chevron-right mr-2"></i> Admin Paneli
                                                </a>
                                            </li>

                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                document.getElementById('logout-form').submit();">
                                                    <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                </a>
                                                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                    @csrf
                                                </form>
                                            </li>
                                        </ul>
                                    </li>
                                @else
                                    <li class="has_sub" style="border-top: 1px solid #ddd;">
                                        <a
                                            class="btn btn-outline-primary border-0 w-100 text-left py-4 font-weight-bold"
                                            title="Property"
                                            href=""
                                            data-toggle="collapse"
                                            data-target="#login-1"
                                            aria-expanded="false"
                                            aria-controls="collapse-1" style="text-decoration: underline;"
                                            >
                                            {{ Auth::user()->name }} {{ Auth::user()->surname }}
                                        </a>
                                        <ul id="login-1"
                                            class="collapse slow_3s list-unstyled pl-2 py-2 pr-2 border-bottom border-dark"
                                            data-parent="#accordion_menumobile"
                                            >
                                            @if (!Auth::user()->is_active)
                                                <li class="list-inline-item">
                                                    <a class="btn btn-outline-primary border-0 w-100 text-left py-3" href="{{ route('user.smsPage', ['slug' => Auth::user()->slug]) }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Hesap Aktivasyonu
                                                    </a>
                                                </li>
                                            @endif
                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-primary border-0 w-100 text-left py-3" href="{{ route('user.show', ['slug' => Auth::user()->slug]) }}">
                                                    <i class="fas fa-chevron-right mr-2"></i> Kullanıcı Bilgileri
                                                </a>
                                            </li>
                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-primary border-0 w-100 text-left py-3" href="{{ route('user.showUserTenders', ['slug' => Auth::user()->slug]) }}">
                                                    <i class="fas fa-chevron-right mr-2"></i> Tekliflerim ve Favorilerim
                                                </a>
                                            </li>
                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-primary border-0 w-100 text-left py-3" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                document.getElementById('logout-form').submit();">
                                                    <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                </a>
                                                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                    @csrf
                                                </form>
                                            </li>
                                        </ul>
                                    </li>
                                @endif
                            @endauth
                            

                            <li class="list-inline-item" style="border-bottom: 1px solid #ddd;border-top: 1px solid #ddd;">
                                <a class="btn btn-outline-dark border-0 w-100 text-left py-4 font-weight-bold" href="{{ route('home') }}" title="Anasayfa">
                                    Anasayfa
                                </a>
                            </li>

                            <li class="has_sub" style="border-bottom: 1px solid #ddd;">
                                <a
                                    class="btn btn-outline-dark border-0 w-100 text-left py-4 font-weight-bold"
                                    title="Property"
                                    href="property-search.html"
                                    data-toggle="collapse"
                                    data-target="#collapse-1"
                                    aria-expanded="false"
                                    aria-controls="collapse-1"
                                    >
                                    Hakkımızda
                                </a>
                                <ul
                                    id="collapse-1"
                                    class="collapse slow_3s list-unstyled pl-2 py-2 border-bottom border-dark"
                                    data-parent="#accordion_menumobile"
                                    >
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('aboutus') }}">
                                            <i class="fas fa-chevron-right mr-2"></i> Biz Kimiz
                                        </a>
                                    </li>
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('ourjob') }}">
                                            <i class="fas fa-chevron-right mr-2"></i> Ne Yapıyoruz?
                                        </a>
                                    </li>
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('buy-realestate') }}">
                                            <i class="fas fa-chevron-right mr-2"></i> Gayrimenkulü Nasıl Edinirim?
                                        </a>
                                    </li>
                                </ul>
                            </li>

                            {{-- <li class="has_sub">
                                <a
                                    class="btn btn-outline-dark border-0 w-100 text-left py-4 font-weight-bold"
                                    title="Blog"
                                    href="JavaScript:Void(0);"
                                    data-toggle="collapse"
                                    data-target="#collapse-2"
                                    aria-expanded="false"
                                    aria-controls="collapse-2"
                                    >
                                    Blog
                                </a>
                                <ul
                                    id="collapse-2"
                                    class="collapse slow_3s list-unstyled pl-2 py-2 border-bottom border-dark"
                                    data-parent="#accordion_menumobile"
                                    >
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" title="" href="blog-home.html">
                                            <i class="fas fa-chevron-right mr-2"></i> Blog - Home
                                        </a>
                                    </li>
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" title="" href="blog-single.html">
                                            <i class="fas fa-chevron-right mr-2"></i> Blog - Single
                                        </a>
                                    </li>
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" title="" href="blog-search.html">
                                            <i class="fas fa-chevron-right mr-2"></i> Blog - Search
                                        </a>
                                    </li>
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" title="" href="blog-category.html">
                                            <i class="fas fa-chevron-right mr-2"></i> Blog - Category
                                        </a>
                                    </li>
                                </ul>
                            </li> --}}

                            <li class="list-inline-item" style="border-bottom: 1px solid #ddd;">
                                <a class="btn btn-outline-dark border-0 w-100 text-left py-4 font-weight-bold" href="{{ route('contact') }}">
                                    İletişim
                                </a>
                            </li>
                        </ul>
                        @guest
                            <div class="px-1 mt-3">
                                <a class="btn btn-block btn-outline-success p-3" href="{{ route('login') }}">Giriş Yap</a>
                                <a class="btn btn-block btn-success p-3 mt-2" href="{{ route('register') }}">Kayıt Ol</a>
                            </div>
                        @endguest

                        {{-- @auth
                            <div class="d-md-inline-block" style="margin-top: 20px;">
                                <ul class="main_nav list-unstyled mb-0 pr-0">
                                    <li class="float-left position-relative has_sub" style="padding-left: 10px;padding-right:10px;">
                                        <a class="btn btn-outline-dark border-0 py-3 font-weight-bold auth-btn" style="width: 100%;">
                                            {{ Auth::user()->name }} {{ Auth::user()->surname }}
                                        </a>
                                        @if (Auth::user()->is_admin == 1)
                                            <ul class="list-unstyled position-absolute slow_3s shadow-sm" style="border-radius: 12px;border: 1px solid #5e6278;">
                                                <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn"  style="border-radius: 0px !important;" title="" href="{{ route('admin.home') }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Admin Paneli
                                                    </a>
                                                </li>
                                                <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                    document.getElementById('logout-form').submit();">
                                                        <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                    </a>
                                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                        @csrf
                                                    </form>
                                                </li>
                                            </ul>
                                        @else
                                            <ul class="list-unstyled position-absolute slow_3s shadow-sm" style="border-radius: 12px;border: 1px solid #5e6278;">

                                                @if (!Auth::user()->is_active)
                                                    <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                        <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;"  href="{{ route('user.smsPage', ['slug' => Auth::user()->slug]) }}">
                                                            <i class="fas fa-chevron-right mr-2"></i> Hesap Aktivasyonu
                                                        </a>
                                                    </li>
                                                @endif
                                                <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn"  style="border-radius: 0px !important;" title="" href="{{ route('user.show', ['slug' => Auth::user()->slug]) }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Kullanıcı Bilgileri
                                                    </a>
                                                </li>
                                                <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('user.showUserTenders', ['slug' => Auth::user()->slug]) }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Tekliflerim ve Favorilerim
                                                    </a>
                                                </li>
                                                <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                    document.getElementById('logout-form').submit();">
                                                        <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                    </a>
                                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                        @csrf
                                                    </form>
                                                </li>
                                            </ul>
                                        @endif
                                        
                                    </li>
                                </ul>
                            </div>
                        @endauth --}}
                    </div>
                </div>
            </header>
            <!-- end header-->

            <div class="container-fluid bank-mt-fixed">
                @yield('content')
            </div>

            {{-- <div class="container bank-mt-fixed" style="width: 1127px;box-shadow: 0px 20px 16px 4px rgb(0 0 0 / 20%);background:white;min-height:100vh;">
                
            </div> --}}

            <footer class="d-flex align-items-center" style="z-index: 999999999;position: relative;">
                <div class="container-fluid">
                    <div class="row" style="background-color: #c8c8c8;padding: 12px 0px;">
                        <div class="col-12 text-center">
                            <a class="main_brand d-inline-block" href="https://www.propturk.com/" title="PropTurk Anasayfa">
                                <img class="d-block propturk-logo" src="{{ asset('assets/img/logo.png') }}" alt="Propturk" title="Propturk"/>
                            </a>
                        </div>
                    </div>
                    {{-- <div class="row" style="background-color: #969696;">
                        <div class="col-12 text-center">
                            <h3 style="font-size: 12px;" class="mb-0" style="height: 15px;"></h3>
                        </div>
                    </div> --}}
                </div>
            </footer>
        @else
            <!-- start header -->
            <header class="main_header d-print-none">
                <h1 class="sr-only">Propturk</h1>

                <div class="header_bottom slow_7s py-2 shadow-sm bg-white w-100">
                    <div class="container">
                        <nav class="d-flex justify-content-between no-gutters align-items-center">
                            <h2 class="sr-only">Propturk</h2>
                            <a class="main_brand d-inline-block" href="/" title="PropTurk Anasayfa">
                                <img class="d-block propturk-logo" src="{{ asset('assets/img/logo.png') }}" alt="Propturk" title="Propturk"/>
                            </a>
                            <div class="d-flex" style="align-items: center;">
                                <div class="d-none d-xl-inline-block">
                                    <ul class="main_nav list-unstyled mb-0 pr-0">
                                        <li class="float-left">
                                            <a class="btn btn-outline-dark border-0 py-3 font-weight-bold hover-navlink" title="" href="{{ url(env('APP_URL')) }}">
                                                Ana Sayfa
                                            </a>
                                        </li>
                                        <li class="float-left position-relative has_sub">
                                            <a class="btn btn-outline-dark border-0 py-3 font-weight-bold hover-navlink">
                                                Hakkımızda
                                            </a>
                                            <ul class="list-unstyled position-absolute slow_3s shadow-sm" style="border: 1px solid #5e6278;border-radius: 12px;">
                                                <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('aboutus') }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Biz Kimiz
                                                    </a>
                                                </li>
                                                <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('ourjob') }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Ne Yapıyoruz?
                                                    </a>
                                                </li>
                                                <li class="w-100" style="border-radius: 0px !important;">
                                                    <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('buy-realestate') }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Gayrimenkulü Nasıl Edinirim?
                                                    </a>
                                                </li>
                                            </ul>
                                        </li>
                                        <li class="float-left">
                                            <a class="btn btn-outline-dark border-0 py-3 font-weight-bold hover-navlink" title="" href="{{ route('contact') }}">
                                                İletişim
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                @auth
                                    <div class="d-none d-md-inline-block">
                                        <ul class="main_nav list-unstyled mb-0 pr-0">
                                            <li class="float-left position-relative has_sub">
                                                <a class="btn btn-outline-dark border-0 py-3 font-weight-bold auth-btn" title="">
                                                    {{ Auth::user()->name }} {{ Auth::user()->surname }}
                                                </a>
                                                @if (Auth::user()->is_admin == 1 || Auth::user()->is_admin == 2)
                                                    <ul class="list-unstyled position-absolute slow_3s shadow-sm" style="border-radius: 12px;border: 1px solid #5e6278;">
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn"  style="border-radius: 0px !important;" title="" href="{{ route('admin.home') }}">
                                                                <i class="fas fa-chevron-right mr-2"></i> Admin Paneli
                                                            </a>
                                                        </li>
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                            document.getElementById('logout-form').submit();">
                                                                <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                            </a>
                                                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                                @csrf
                                                            </form>
                                                        </li>
                                                    </ul>
                                                @else
                                                    <ul class="list-unstyled position-absolute slow_3s shadow-sm" style="border-radius: 12px;border: 1px solid #5e6278;">

                                                        @if (!Auth::user()->is_active)
                                                            <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                                <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;"  href="{{ route('user.smsPage', ['slug' => Auth::user()->slug]) }}">
                                                                    <i class="fas fa-chevron-right mr-2"></i> Hesap Aktivasyonu
                                                                </a>
                                                            </li>
                                                        @endif
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn"  style="border-radius: 0px !important;" title="" href="{{ route('user.show', ['slug' => Auth::user()->slug]) }}">
                                                                <i class="fas fa-chevron-right mr-2"></i> Kullanıcı Bilgileri
                                                            </a>
                                                        </li>
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('user.showUserTenders', ['slug' => Auth::user()->slug]) }}">
                                                                <i class="fas fa-chevron-right mr-2"></i> Tekliflerim ve Favorilerim
                                                            </a>
                                                        </li>
                                                        <li class="w-100" style="border-radius: 0px !important;border-bottom: 1px solid #ddd;">
                                                            <a class="btn btn-dark w-100 text-left py-3 list-a-btn" style="border-radius: 0px !important;" title="" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                            document.getElementById('logout-form').submit();">
                                                                <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                            </a>
                                                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                                @csrf
                                                            </form>
                                                        </li>
                                                    </ul>
                                                @endif
                                                
                                            </li>
                                        </ul>
                                    </div>
                                @endauth


                                @guest
                                    <div class="d-flex d-none-login-register" style="grid-gap: 10px;">
                                        <a class="btn btn-outline-primary" href="{{ route('login') }}" style="width: 100px;height: 45px;
                                        display: flex;
                                        flex-direction: row;
                                        align-items: center;
                                        justify-content: center;" title="Giriş Yap">Giriş</a>
                                        <a class="btn btn-primary" style="width: 100px;height: 45px;
                                        display: flex;
                                        flex-direction: row;
                                        align-items: center;
                                        justify-content: center;" href="{{ route('register') }}">Kayıt Ol</a>
                                    </div>
                                @endguest
                                
                                <div class="d-xl-none">
                                    <div class="nav-icon menu_action">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </div>
                                </div>
                            </div>

                        </nav>
                    </div>
                </div>

                <!-- menu mobile -->
                <div class="menu_mobile_box position-fixed d-block w-100 slow_3s">
                    <div class="main_nav_mobile position-fixed bg-white accordion py-3" id="accordion_menumobile" style="padding-left: 5px;padding-right: 5px !important;">
                        
                        <div class="d-block">
                            <a class="main_brand d-inline-block" href="/" title="PropTurk Anasayfa">
                                <img class="d-block propturk-logo-menu" src="{{ asset('assets/img/logo.png') }}" alt="Propturk" title="Propturk"/>
                            </a>
                            <div class="nav-icon menu_action float-right d-block mb-3">
                                <span></span>
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </div>
                        <ul class="list-unstyled mb-0 pr-0" style="margin-top: 20px;padding-left: 5px;padding-right: 5px !important;">
                            @auth
                                @if (Auth::user()->is_admin == 1 || Auth::user()->is_admin == 2)
                                    <li class="has_sub" style="border-top: 1px solid #ddd;">
                                        <a
                                            class="btn btn-outline-dark border-0 w-100 text-left py-4 font-weight-bold"
                                            title="Property"
                                            href=""
                                            data-toggle="collapse"
                                            data-target="#login-1"
                                            aria-expanded="false"
                                            aria-controls="collapse-1"
                                            style="text-decoration: underline;">
                                            {{ Auth::user()->name }} {{ Auth::user()->surname }}
                                        </a>
                                        <ul id="login-1"
                                            class="collapse slow_3s list-unstyled pl-2 py-2 border-bottom border-dark"
                                            data-parent="#accordion_menumobile"
                                            >
                                        
                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('admin.home') }}">
                                                    <i class="fas fa-chevron-right mr-2"></i> Admin Paneli
                                                </a>
                                            </li>

                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                document.getElementById('logout-form').submit();">
                                                    <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                </a>
                                                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                    @csrf
                                                </form>
                                            </li>
                                        </ul>
                                    </li>
                                @else
                                    <li class="has_sub" style="border-top: 1px solid #ddd;">
                                        <a
                                            class="btn btn-outline-primary border-0 w-100 text-left py-4 font-weight-bold"
                                            title="Property"
                                            href=""
                                            data-toggle="collapse"
                                            data-target="#login-1"
                                            aria-expanded="false"
                                            aria-controls="collapse-1" style="text-decoration: underline;"
                                            >
                                            {{ Auth::user()->name }} {{ Auth::user()->surname }}
                                        </a>
                                        <ul id="login-1"
                                            class="collapse slow_3s list-unstyled pl-2 py-2 pr-2 border-bottom border-dark"
                                            data-parent="#accordion_menumobile"
                                            >
                                            @if (!Auth::user()->is_active)
                                                <li class="list-inline-item">
                                                    <a class="btn btn-outline-primary border-0 w-100 text-left py-3" href="{{ route('user.smsPage', ['slug' => Auth::user()->slug]) }}">
                                                        <i class="fas fa-chevron-right mr-2"></i> Hesap Aktivasyonu
                                                    </a>
                                                </li>
                                            @endif
                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-primary border-0 w-100 text-left py-3" href="{{ route('user.show', ['slug' => Auth::user()->slug]) }}">
                                                    <i class="fas fa-chevron-right mr-2"></i> Kullanıcı Bilgileri
                                                </a>
                                            </li>
                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-primary border-0 w-100 text-left py-3" href="{{ route('user.showUserTenders', ['slug' => Auth::user()->slug]) }}">
                                                    <i class="fas fa-chevron-right mr-2"></i> Tekliflerim ve Favorilerim
                                                </a>
                                            </li>
                                            <li class="list-inline-item">
                                                <a class="btn btn-outline-primary border-0 w-100 text-left py-3" href="{{ route('logout')}}" onclick="event.preventDefault();
                                                document.getElementById('logout-form').submit();">
                                                    <i class="fas fa-chevron-right mr-2"></i> Çıkış
                                                </a>
                                                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                                    @csrf
                                                </form>
                                            </li>
                                        </ul>
                                    </li>
                                @endif
                            @endauth
                            

                            <li class="list-inline-item" style="border-bottom: 1px solid #ddd;border-top: 1px solid #ddd;">
                                <a class="btn btn-outline-dark border-0 w-100 text-left py-4 font-weight-bold" href="{{ route('home') }}" title="Anasayfa">
                                    Anasayfa
                                </a>
                            </li>

                            <li class="has_sub" style="border-bottom: 1px solid #ddd;">
                                <a
                                    class="btn btn-outline-dark border-0 w-100 text-left py-4 font-weight-bold"
                                    title="Property"
                                    href="property-search.html"
                                    data-toggle="collapse"
                                    data-target="#collapse-1"
                                    aria-expanded="false"
                                    aria-controls="collapse-1"
                                    >
                                    Hakkımızda
                                </a>
                                <ul
                                    id="collapse-1"
                                    class="collapse slow_3s list-unstyled pl-2 py-2 border-bottom border-dark"
                                    data-parent="#accordion_menumobile"
                                    >
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('aboutus') }}">
                                            <i class="fas fa-chevron-right mr-2"></i> Biz Kimiz
                                        </a>
                                    </li>
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('ourjob') }}">
                                            <i class="fas fa-chevron-right mr-2"></i> Ne Yapıyoruz?
                                        </a>
                                    </li>
                                    <li class="list-inline-item">
                                        <a class="btn btn-outline-dark border-0 w-100 text-left py-3" href="{{ route('buy-realestate') }}">
                                            <i class="fas fa-chevron-right mr-2"></i> Gayrimenkulü Nasıl Edinirim?
                                        </a>
                                    </li>
                                </ul>
                            </li>

                            <li class="list-inline-item" style="border-bottom: 1px solid #ddd;">
                                <a class="btn btn-outline-dark border-0 w-100 text-left py-4 font-weight-bold" href="{{ route('contact') }}">
                                    İletişim
                                </a>
                            </li>
                        </ul>
                        @guest
                            <div class="px-1 mt-3">
                                <a class="btn btn-block btn-outline-success p-3" href="{{ route('login') }}">Giriş Yap</a>
                                <a class="btn btn-block btn-success p-3 mt-2" href="{{ route('register') }}">Kayıt Ol</a>
                            </div>
                        @endguest

                    </div>
                </div>
            </header>
            <!-- end header-->

            <div class="container-fluid">
                @yield('content')
            </div>

            <!-- start main footer -->
            <footer class="main_footer bg-dark text-light d-print-none">
                <div class="container">
                    <div class="row pt-5">
                        <div class="col-sm-6 col-lg-3 pb-5">
                            <a class="main_brand d-inline-block mb-3 w-100" href="{{ route('home') }}" title="propturk - Ana Sayfa">
                                <img class="d-block w-100" src="{{ asset('assets/img/logo-footer.png') }}" alt="" title=""/>
                            </a>
                            <div>
                                <p class="h5 font-weight-bold footer_title mb-4" style="margin-bottom: 0.5px !important;">Ekibimiz</p>
                                <p style="font-size: 14px;">
                                    Ekibimizde yer alan şehir plancıları, mimarlar, inşaat mühendisleri, iktisatçılar ve gayrimenkul değerleme uzmanları ile birlikte oluşturduğumuz multi disipliner bir anlayışla kurumsal firmaların portföylerinde yer alan gayrimenkullerin teknolojik altyapı ve yapay zeka kullanımı ile gayrimenkul ekosistemini (danışmanlık, yönetim, pazarlama ve satış süreci) oluşturmak ve firmalara kaynak sağlamak hedefiyle kurulduk.
                                </p>
                            </div>
                        </div>

                        <div class="col-sm-6 col-lg-3 pb-5">
                            <p class="h5 font-weight-bold footer_title mb-4">Hızlı Ulaşım</p>

                            <ul class="list-unstyled">
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="" title="">
                                        <i class="fas fa-angle-double-right"></i> Biz Kimiz
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="" title="">
                                        <i class="fas fa-angle-double-right"></i> Ne Yapıyoruz?
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="" title="">
                                        <i class="fas fa-angle-double-right"></i> Gayrimenkulü Nasıl Edinirim?
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="" title="">
                                        <i class="fas fa-angle-double-right"></i> İletişim
                                    </a>
                                </li>
                            </ul>
                        </div>

                        <div class="col-sm-6 col-lg-3 pb-5">
                            <p class="h5 font-weight-bold footer_title mb-4">İletişim</p>
                            <ul class="list-unstyled">
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="tel:05332952118" title="Phone">
                                        <i class="fas fa-phone-alt mr-2"></i>0 (533) 295 21 18
                                    </a>
                                </li>
                                {{-- <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="#"  title="Whatsapp">
                                        <i class="fab fa-whatsapp mr-2"></i> (88) 98888-8888
                                    </a>
                                </li> --}}
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1 text_small" href="mailto:info@propturk.com" title="E-mail">
                                        <i class="far fa-envelope mr-2"></i> info@propturk.com
                                    </a>
                                </li>
                                {{-- <li class="list-inline-item">
                                    <a class="btn btn-lg btn-dark" href="#" title="Facebook" >
                                        <i class="fab fa-facebook-f"></i>
                                    </a>
                                    <a class="btn btn-lg btn-dark" href="#" title="Youtube" >
                                        <i class="fab fa-youtube"></i>
                                    </a>
                                    <a class="btn btn-lg btn-dark" href="#" title="Instagram" >
                                        <i class="fab fa-instagram"></i>
                                    </a>
                                    <a class="btn btn-lg btn-dark" href="#" title="Twitter" >
                                        <i class="fab fa-twitter"></i>
                                    </a>
                                </li> --}}
                            </ul>
                        </div>

                        <div class="col-sm-6 col-lg-3 pb-5">
                            <p class="h5 font-weight-bold footer_title mb-4">Özel Sayfalar</p>

                            <ul class="list-unstyled">
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="https://odeabank.propturk.com" title="">
                                        <i class="fas fa-angle-double-right"></i> Odeabank
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="https://ziraatkatilim.propturk.com" title="">
                                        <i class="fas fa-angle-double-right"></i> Ziraat Katılım
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn btn-block btn_height btn-dark text-left border-0 px-1" href="https://turkiyefinanskatilim.propturk.com" title="">
                                        <i class="fas fa-angle-double-right"></i> Türkiye Finans Katılım
                                    </a>
                                </li>
                            </ul>

                            {{--  <form action="#" method="post" class="validate" novalidate="">
                                <div class="input-group input-group-lg w-100">
                                    <input type="text" class="form-control bg-dark" placeholder="Enter e-mail address" required>
                                    <div class="input-group-prepend">
                                        <button class="input-group-text btn bg-primary text-white border border-primary">
                                            <i class="far fa-paper-plane"></i>
                                        </button>
                                    </div>
                                </div>
                            </form>  --}}
                        </div>
                    </div>
                </div>
                {{-- <div class="content_copy bg-primary text-light text-center py-3">
                    <div class="container text_small">
                        MaxRealty © 2020. All rights reserved.
                    </div>
                </div> --}}
            </footer>
            <!-- end main footer -->
        @endif

        <!-- Start Compare -->
        <div class="compare_box d-print-none position-fixed d-block w-100 slow_3s" style="display: none !important;">
            <section class="compare_sidebar position-fixed slow_3s">
                <span class="px-2 py-3 py-lg-5 bg-primary text-white d-inline-block position-absolute btn_side_compare j_compareSidebar">
                    <i class="fas fa-random fa-2x slow_7s my-xl-5"></i>
                </span>
                <div class="compare_sidebar_container bg-light">
                    <header class="bg-primary text-white text-center px-1 py-3">
                        <h2 class="h6 mb-0">Fırsatlar</h2>
                    </header>
                    <div class="compare_sidebar_content p-3">

                        {{--  <article class="position-relative bg-white pb-3 border w-100 mb-4 overflow-hidden">
                            <a class="text-decoration-none d-block" title="" href="#">
                                <img class="d-block w-100 slow_3s" title="" alt="" src="assets/img/1200x628.jpg">
                                <header class="text-center">
                                    <div class="d-flex align-items-center px-1" style="height: 70px">
                                        <h3 class="h6 mb-0 text-dark">Casa na lagoa da conceição</h3>
                                    </div>
                                    <p class="mb-0 text-success">
                                        <sup>$</sup><span class="mb-0 h5 pb-0">3.500.000.00</span>
                                    </p>
                                </header>
                                <span 
                                    class="btn_compare active text-danger j_compare position-absolute text_shadow fa-2x py-1 px-2 text-white" 
                                    data-toggle="tooltip" 
                                    data-placement="top" 
                                    title="Remove this property">
                                    <i class="fas fa-heart"></i>
                                </span>
                            </a>
                        </article>

                        <article class="position-relative bg-white pb-3 border w-100 mb-4 overflow-hidden">
                            <a class="text-decoration-none d-block" title="" href="#">
                                <img class="d-block w-100 slow_3s" title="" alt="" src="assets/img/1200x628.jpg">
                                <header class="text-center">
                                    <div class="d-flex align-items-center px-1" style="height: 70px">
                                        <h3 class="h6 mb-0 text-dark">Casa na lagoa da conceição</h3>
                                    </div>
                                    <p class="mb-0 text-success">
                                        <sup>$</sup><span class="mb-0 h5 pb-0">2.500.000.00</span>
                                    </p>
                                </header>
                                <span 
                                    class="btn_compare active text-danger j_compare position-absolute text_shadow fa-2x py-1 px-2 text-white" 
                                    data-toggle="tooltip" 
                                    data-placement="top" 
                                    title="Remove this property">
                                    <i class="fas fa-heart"></i>
                                </span>
                            </a>
                        </article>  --}}

                        {{--  <a class="btn btn-block btn-primary btn_height" href="property-compare.html" title="">Compare</a>  --}}
                    </div>
                </div>
            </section>
        </div>
        <!-- end Compare -->

    </body>

    @include('layout.include-js')

    <script src="https://phpcoder.tech/multiselect/js/jquery.multiselect.js"></script>

    {{-- Ziraat Bankası İçin Renk/Img Değişikliği Yapılacak --}}
    @if (session('subdomain') == 'ziraatkatilim')
        <script src="{{ asset('js/tr-finans.js') }}"></script>
    @endif

    {{-- <script>
        document.onreadystatechange = function() {
            if (document.readyState !== "complete") {
                document.querySelector("body").style.visibility = "hidden";
                document.querySelector("#loader").style.visibility = "visible";
            } else {
                document.querySelector("#loader").style.display = "none";
                document.querySelector("body").style.visibility = "visible";
            }
        };
    </script> --}}
    @yield('scripts')

</html>