@extends('layout.layout')

@section('title', $property->post->title)

@section('styles')
    @parent
    <link href='https://api.mapbox.com/mapbox-gl-js/v2.3.1/mapbox-gl.css' rel='stylesheet' />
    <style>
        .bid_amount{
            pointer-events: none;
            font-size: 20px;
        }
        .currency-wrap{
            position:relative;
        }
        .currency-wrap input{
            height: 55px;
            border: 2px solid #212529;
            border-radius: 6px !important;
            text-align: center;
            width: 100%;
        }

        .currency-code{
            position:absolute;
            left:12px;
            top:14px;
        }
        
        .text-currency{
            padding:10px 20px;
            border:solid 1px #ccc;
            border-radius:5px;
        }
        #clockdiv{
            font-family: sans-serif;
            color: #fff;
            display: flex;
            grid-gap: 40px;
            font-weight: 100;
            text-align: center;
            font-size: 30px;
        }



        #clockdiv > div{
            /* background: #00816A; */
            display: inline-block;
        }

        #clockdiv div > span{
            /* padding: 15px; */
            /* border-radius: 3px; */
            /* background: #00816A; */
            display: inline-block;
            font-weight: 600;
            color: #464E5F;
            /* font-size: 18px; */
            font-size: 24px;
            line-height: 36px;
        }


        .smalltext{
            /* padding-top: 5px; */
            font-size: 18px;
            line-height: 36px;
            font-weight: 600;
            /* font-size: 14px; */
            color: #464E5F;
        }
        .clock{
            width: 100%;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 25px;
            text-align: center;
            background-color: #F7F7F7;
            border: 2px dashed #878C93;
            flex-direction: column;
        }
        .clock-main{
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }
        .product-container{
            padding-top: 5px;
            padding-bottom: 15px;
        }

        .property-perm p {
            color: black;
            font-weight: 600;
        }
        .property-perm h5 {
            font-size: 1rem;
        }

        .property-img{
            max-height: 500px;
            min-height:500px;
            object-fit:cover;
        }

        .property-thumbnail-img{
            max-height: 175px;
            min-height: 175px;
            object-fit: cover;
        }

        .property-info-div{
            background-color: #F7F7F7;
            border-radius: 6px;
            padding:18px;
            display: inline-block;
            max-height: 670px;
        }

        .mobile-price-row{
            justify-content: space-between;
        }

        .property-footer-info{
            margin-top: 20px;
        }
        
        .show-page-padding{
            padding-left: 100px;
            padding-right: 100px;   
        }

        @media screen and (min-width:1024px) and (max-width:1850px){
            .show-page-padding{
                padding-left: 0px;
                padding-right: 0px;   
            }  
        }

        @media screen and (max-width:900px) {
            .property-img{
                max-height: 300px;
                min-height: 300px;
                object-fit: cover;
            }
            .property-thumbnail-img{
                min-height: 83px;
                max-height: 83px;
                object-fit: cover;
            }
            .property-info-div{
                max-height: 100%;
            }
            .m-mb-20{
                margin-bottom: 20px;
            }
            .mobile-price-row{
                flex-direction: column !important;
                grid-gap: 20px;
            }
            .clock-img{
                display: none !important;
            }
            #clockdiv{
                grid-gap: 20px;
            }
            .property-footer-info{
                flex-direction: column;
                grid-gap: 20px;
            }
            .show-page-padding{
                padding-left: 0px;
                padding-right: 0px;
            }
        }


        .user-tender-status-higher{
            top: 81px;
            position: fixed;
            justify-content: flex-end;
            z-index:91;
            right: 7px;
        }

        .user-tender-status-higher-div{
            background: #198754;
            width: 100%;
            border-radius: 12px;
            opacity: 1;
            box-shadow: 0 .125rem .25rem rgba(0,0,0,.075)!important;
        }

        .user-tender-status-lower-div{
            background: #df0808;
            width: 100%;
            border-radius: 12px;
            opacity: 1;
            box-shadow: 0 .125rem .25rem rgba(0,0,0,.075)!important;
        }
        .winner-div{
            display: block;
        }
        .winner-div-none{
            display: none;
        }
        .loser-div{
            display: block;
        }
        .loser-div-none{
            display: none;
        }
        .mapboxgl-ctrl-bottom-left{
            display: none !important;
        }
        .mapboxgl-ctrl-bottom-right{
            display: none !important;
        }
        .btn-parsel-url{
            position: absolute;
            z-index: 2;
            right: 35px;
            background: #e0e0e0;
            font-size: 14px;
            background-color: black;
            border-color: black !important;
            border-radius: 0px !important;
        }
        .btn-parsel-url:hover{
            opacity: 0.9;
            background-color: rgba(21,21,21,0.85);
            border-color: rgba(21,21,21,0.85) !important;
        }
        .btn-parsel-url:focus {
            color: #fff;
            background-color: rgba(21,21,21,0.85);
            border-color: rgba(21,21,21,0.85) !important;
            box-shadow: 0 0 0 0rem rgb(0 0 0 / 0%);
        }
        
        .order-2 .slick-current{
            opacity: 0.7;
        }

        #mapModal .modal-dialog{
            width: 100%;
            height: 100%;
            margin: 0;
            padding: 0;
            min-width: 100%;
        }
        #mapModal .modal-content{
            height: auto;
            min-height: 100%;
            border-radius: 0;
        }
        .mobile-map-btn{
            background-color: black !important;
            color:white !important;
            border-color:white !important;
            border-radius:24px !important; 
            box-shadow: 0 0 5px rgb(0 0 0 / 10%) !important;
            border: 1px solid #E0E0E0 !important;
            margin-left: 21%;
            position: fixed;
            bottom: 10px;
            z-index: 2
        }
        @media screen and (min-width:950px) {
            .mobile-map-btn{
                display: none;
            }
            ..btn-parsel-url{
                font-size: 9px;
            }
        }

        .btn-teklif-login{
            height: 55px;
            width: 100%;
            font-size:15px;
            display: flex;
            justify-content: center;
            align-items: center;border-radius:6px;
        }
    </style>

    @php
        // $url = 1;
    @endphp
    @if (session('subdomain') == 'ziraatkatilim')
        <style>
            .bank-mt-fixed{
                width: 100% !important;
            }
            .btn-teklif-login{
                height: 55px;
                width: 100%;
                font-size:15px;
                display: flex;
                justify-content: center;
                align-items: center;border-radius:6px;
                background-color: #eb1c23;
                border-color: #eb1c23;
                background-image: url('/assets/img/ziraat/header-background.png');;
            }

            .btn-teklif-login:hover{
                background-color: #eb1c2386/* !important*/;
                border-color: #eb1c2386/* !important*/;
            }

            .slick-arrow:after{
                background-color: #eb1c23;
            }
            .property-content--bank{
                padding-top: 10px;
            }
        </style>
    @endif
@stop

@section('content')
    @include('flash_message.flash')

    <!-- start main container -->
    {{-- En yüksek teklif size ait --}}
    @if(Auth::user())
        <div class="user-tender-status-higher
         
        {{  Auth::user()->id == $property->post->winner_id ? 'winner-div' : 'winner-div-none' }}
        "
          id="winner-alert" >
            <div class="user-tender-status-higher-div">
                <div style="padding: 10px;">
                    <p class="mb-0" style="color: white;font-weight: 600;">En yüksek teklif size ait.</p>
                </div>
            </div>
        </div>
    
    {{-- En yüksek teklif size ait --}}

    {{-- En yüksek teklif bir başkasına ait --}}
   
        <div class="user-tender-status-higher 
        {{ in_array(Auth::user()->id, $property->post->offers->pluck('user_id')->toArray()) && Auth::user()->id != $property->post->winner_id ? 'loser-div' : 'loser-div-none' }}
        " id="loser-alert"
           >
            <div class="user-tender-status-lower-div">
                <div style="padding: 10px;">
                    <p class="mb-0" style="color: white;font-weight: 600;">En yüksek teklif bir başkasına ait.</p>
                </div>
            </div>
        </div>
    @endif
    {{-- En yüksek teklif bir başkasına ait --}}
    <main class="show-page-padding" style="margin-top: 15px;">
        <article class="pb-3 property-content--bank" style="padding-left: 20px;padding-right:20px;">
            <div class="row no-gutter">
                <div class="col-12 col-lg-7 order-0 position-relative m-mb-20">
                    <div class="slider-for slide_max arrow_inner d-none">
                        @foreach(Storage::allFiles($property->post->images_folder) as $image)
                            <a class="d-block w-100" href="{{ Storage::url($image) }}" data-lightbox="roadtrip">
                                <img class="d-block w-100 slow_3s h-100 property-img" src="{{ Storage::url($image) }}">
                            </a>
                        @endforeach
                    </div>

                    <span class="btn_compare  j_compare position-absolute text_shadow fa-2x py-1 px-2 btn_favourite 
                        @if(in_array($property->post->id, $favoritePosts))
                            active
                        @endif" 
                        title="@if(in_array($property->post->id, $favoritePosts))
                            Favorilerimden çıkar.
                        @else
                            Favorilerime ekle.
                        @endif" id = {{ $property->slug }} data-slug={{ $property->slug }} data-imovel="108" data-action="addCompare" data-toggle="tooltip" data-placement="top" title="Compare">
                        <i class="fas fa-heart"></i>
                    </span>

                    <div class="order-2 d-print-none">
                        <div class="slider-nav pt-1 d-none" style="background-color: rgb(247 247 247);">
                            @foreach(Storage::allFiles($property->post->images_folder) as $image)  
                                <div class="item-slick pr-1 overflow-hidden">
                                    <img class="d-block w-100 slow_3s property-thumbnail-img" alt="" src="{{ Storage::url($image) }}">
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                

                <div class="col-12 col-lg-5">
                    <div class="pr-lg-2 pr-xl-5 px-sm-4" style="height: 100%;">
                        {{-- Teklif Süresi --}}
                        @if (isset($property->post->end_time))
                            <div class="clock-main">
                                <div class="clock">
                                    <div class="d-flex" style="grid-gap: 40px;">
                                        <div class="clock-img d-flex">
                                            <i class="far fa-clock" style="font-size: 50px;color:#7E8299;display: flex;align-items: center" aria-hidden="true"></i>
                                        </div>
                                        <div id="clockdiv">
                                            <div>
                                                <span class="days"></span>
                                                <div class="smalltext">Gün</div>
                                            </div>
                                            <div>
                                                <span class="hours"></span>
                                                <div class="smalltext">Saat</div>
                                            </div>
                                            <div>
                                                <span class="minutes"></span>
                                                <div class="smalltext">Dakika</div>
                                            </div>
                                            <div>
                                                <span class="seconds"></span>
                                                <div class="smalltext">Saniye</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div style="margin-top: 15px;">
                                        <h6 id="postEndDate" class="mb-0" style="color: #7E8299">Bitiş Tarihi : {{ $endTimeDay }} {{ $endTimeMonth }} {{ $endTimeYear }} - {{ $endTimeClock }}</h6>
                                    </div>
                                </div>
                                
                            </div>
                        @endif


                        <div class="property-info-div">
                            {{-- İlan Bilgileri --}}
                            <div>
                                <h3 style="font-weight: 600;font-size: 23px;line-height: 27px;">{{ $property->post->title }}</h3>
                                <p style="color:#5E6278;font-size: 15px;line-height: 18px;">{{ $property->country }} - {{ $property->district }} - {{ $property->neighborhood }}</p>
                                <p style="color:black;font-size: 15px;line-height: 18px;font-weight:600;margin-bottom: 0px;"><b>İlan Kodu:{{ $property->post->code }}</b></p>
                                <p style="color:black;font-size: 15px;line-height: 18px;font-weight:600;"><b>İlan Kodu:{{ $property->post->tender_code }}</b></p>
                            </div>

                            {{-- İlan Fiyatı --}}
                            <div class="d-flex mobile-price-row">
                                <div class="d-flex" style="flex-direction: column;">

                                    <div style="display: flex;align-items: center;">
                                        <span style="font-size: 17px;line-height: 19px;color:#5E6278;font-weight: bold;">Şuanki Fiyat</span>
                                    </div>
                                    <div>
                                        <span class="mb-1 font-weight-bold">
                                            <span id="current_price" class="h2 money" style="font-size: 20px;line-height: 21px;color: #464E5F;">{{ $property->post->current_price }}</span><span style="font-size: 20px;color: #464E5F;">&#x20BA;</span>
                                       </span>
                                    </div>
                                    
                                </div>
                                <div class="d-flex" style="flex-direction: column;">

                                    <div style="display: flex;align-items: center;">
                                        <span style="font-size: 17px;line-height: 19px;color:#5E6278;font-weight: bold;">Başlangıç Fiyatı</span>
                                    </div>
                                    <div>
                                        <span class="mb-1 font-weight-bold">
                                            <span class="h2 money" style="font-size: 20px;line-height: 21px;color: #464E5F;">{{ $property->post->start_price }}</span><span style="font-size: 20px;color: #464E5F;">&#x20BA;</span>
                                       </span>
                                    </div>
                                    
                                </div>
                                <div class="d-flex" style="flex-direction: column;">

                                    <div style="display: flex;align-items: center;">
                                        <span style="font-size: 17px;line-height: 19px;color:#5E6278;font-weight: bold;">Teklif Adımı</span>
                                    </div>
                                    <div>
                                        <span class="text-success mb-1 font-weight-bold">
                                            <span class="h2 money" style="font-size: 20px;line-height: 21px;color: #464E5F;">{{ $property->post->offer_step }}</span><span style="font-size: 20px;color: #464E5F;">&#x20BA;</span> 
                                        </span>
                                    </div>
                                   
                                </div>
                                
                            </div>

                            {{-- Teklif Ver Butonu --}}
                            @guest
                                <div style="display: flex;justify-content: center;">
                                    <div style="width: 100%;">
                                        <div class="product-container text-center">
                                            <div class="product-info text-left">
                                                <h3 class="mb-0 mt-3" style="color: #212529;">Sonraki Teklif</h3>
                                            </div>
                                            <div class="product-quantity" style="display: flex;justify-content: center;">
                                                <div class="currency-wrap" style="width: 100%;">
                                                    <span class="currency-code">&#x20BA;</span>
                                                    <input type="text" class="form-control bid_amount text-currency money" value="{{ $newOffer }}" id="bid_amountId"/>
                                                </div>
                                            </div>
                                            <div class="mt-2" style="display: flex;justify-content:center;">
                                                <a class="btn btn-success btn-teklif-login" href="{{ route('login') }}" >Teklif Verebilmek İçin Oturum Açınız!</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endguest
                            @auth
                                @if ($userTenderStatus == 2 && Auth::user()->is_admin == 0)
                                    <div style="display: flex;justify-content: center;">
                                        <form action="{{ route('bidCheck', ['slug' => $property->slug]) }}" method="post"  style="width: 100%;">
                                            @csrf
                                            @method('PUT')
                                            <div class="product-container text-center">
                                                <div class="product-info text-left">
                                                    <h3 class="mb-0 mt-3" style="color: #212529;">Sonraki Teklif</h3>
                                                </div>
                                                <div class="product-quantity" style="display: flex;justify-content: center;">
                                                    <div class="currency-wrap" style="width: 100%;">
                                                        <span class="currency-code">&#x20BA;</span>
                                                        <input type="text" class="form-control bid_amount text-currency money" name="offer_amount" value="{{ $newOffer }}" id="bid_amountId"/>
                                                    </div>
                                                </div>
                                                <div class="mt-2">
                                                    <a class="btn btn-success d-flex" id="userOfferSure" style="height: 55px;width: 100%;border-radius:6px;align-items: center;justify-content: center;">Teklif Ver</a>
                                                    <button class="btn btn-success" type="submit" id="tenderSubmit" style="height: 55px;width: 100%;border-radius:6px;display: none;">Teklif Ver</button>
                                                </div>
                                                
                                                @if ($property->post->is_fast_buy == 1)
                                                    <div class="mt-2" id="fast-buy-btn">
                                                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#FastUserOfferModal"style="height: 55px;width: 100%;border-radius:6px;">
                                                            <span class="money">{{ $property->post->fast_buy_price }}</span> <span>&#x20BA;</span> Hemen Al
                                                        </button>
                                                        <a class="btn btn-primary" id="FastBuyBtn" href="{{ route('fastBuy', ['slug' => $property->slug]) }}" style="height: 55px;width: 100%;border-radius:6px;display: flex;flex-direction: row;align-items: center;justify-content: center;display:none !important;"><span class="money">{{ $property->post->fast_buy_price }}</span> <span>&#x20BA;</span> Hemen Al</a>
                                                    </div>

                                                    <!-- Button trigger modal -->
                                                    
                                                    
                                                    <!-- Modal -->
                                                    <div class="modal fade" id="FastUserOfferModal" tabindex="-1" role="dialog" aria-labelledby="FastUserOfferModalLabel" aria-hidden="true">
                                                        <div class="modal-dialog" role="document">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="FastUserOfferModalLabel">Satın Al Onayı</h5>
                                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </div>
                                                                <div class="modal-body text-center">
                                                                    <p>Hemen satın almak istediğinize emin misiniz?</p>
                                                                    <p style="font-weight: 600;">Miktar: <span class="money">{{ $property->post->fast_buy_price }}</span>&#x20BA;</p>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal" id="fast-buy-close">İptal Et</button>
                                                                    <button type="button" class="btn btn-primary" id="FastApprovalUser">Satın Al</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                @endif                                               
                                            </div>
                                        </form>
                                    </div>
                                @endif

                                <!-- Button trigger modal -->
                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#userOfferModal" id="userOfferSureModal" style="display:none !important;">
                                    Teklif Modal
                                </button>
                                
                                <!-- Modal -->
                                <div class="modal fade" id="userOfferModal" tabindex="-1" role="dialog" aria-labelledby="userOfferModallLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="userOfferModallLabel">Teklif Onayı</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body text-center">
                                                <p>Teklif vermek istediğinize emin misiniz?</p>
                                                <p style="font-weight: 600;">Miktar: <span class="money" id="modal-new-offer">{{ $newOffer }}</span>&#x20BA; <span style="color: red" id="modal-new-offer-title"></span></p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">İptal Et</button>
                                                <button type="button" class="btn btn-success" id="approvalUser">Teklif Ver</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                @if ($userTenderStatus == 1 && Auth::user()->is_admin == 0)
                                    <div style="display: flex;justify-content: center;">
                                        <div  style="width: 100%;">
                                            <div class="product-container text-center">
                                                <div class="product-info text-left">
                                                    <h3 class="mb-0 mt-3" style="color: #212529;">Sonraki Teklif</h3>
                                                </div>
                                                <div class="product-quantity" style="display: flex;justify-content: center;">
                                                    <div class="currency-wrap" style="width: 100%;">
                                                        <span class="currency-code">&#x20BA;</span>
                                                        <input type="text" class="form-control bid_amount text-currency money" value="{{ $newOffer }}" id="bid_amountId"/>
                                                    </div>
                                                </div>
                                                <div class="mt-2" style="display: flex;justify-content:center;">
                                                <p>Teklif verebilmeniz için gerekli adımlar mail adresinize gönderilmiştir. Adımları tamamladıysanız Admin tarafından onay beklenmektedir.</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                @if ($userTenderStatus == 0 && Auth::user()->is_admin == 0)
                                    <div style="display: flex;justify-content: center;">
                                        <div  style="width: 100%;">
                                            <div class="product-container text-center">
                                                <div class="product-info text-left">
                                                    <h3 class="mb-0 mt-3" style="color: #212529;">Sonraki Teklif</h3>
                                                </div>
                                                <div class="product-quantity" style="display: flex;justify-content: center;">
                                                    <div class="currency-wrap" style="width: 100%;">
                                                        <span class="currency-code">&#x20BA;</span>
                                                        <input type="text" class="form-control bid_amount text-currency money" value="{{ $newOffer }}" id="bid_amountId"/>
                                                    </div>
                                                </div>
                                                <div class="mt-2" style="display: flex;justify-content:center;">
                                                    @if (Auth::user()->is_active == 1)
                                                        <button class="btn btn-success" data-toggle="modal" data-target="#mailModal"
                                                        style="height: 55px;width: 100%;font-size:15px;
                                                        display: flex;
                                                        justify-content: center;
                                                        align-items: center;border-radius:6px;">Teklif Vermek İstiyorum!</button>
                                                    @endif
                                                    @if (Auth::user()->is_active == 0)
                                                        <a href="{{ route('user.smsPage', ['slug' => Auth::user()->slug]) }}" class="btn btn-danger" style="height: 55px;width: 100%;font-size:15px;
                                                        display: flex;
                                                        justify-content: center;
                                                        align-items: center;border-radius:6px;">Teklif Verebilmeniz İçin Hesabınızı Aktive Ediniz!</a>
                                                    @endif
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                                            
                                @endif
                            @endauth
                            
                            <div class="d-flex property-footer-info">
                                <div class="col-12 col-md-6 pr-0 pl-0" style="color:black">
                                    <div>
                                        <h6 style="font-weight:600;">Hizmet Bedeli (KDV Dahildir.)</h6>
                                    </div>
                                    <div style="display: flex;flex-direction: row;align-items: center;">
                                        <h6 class="money mb-0" style="font-weight: bold;">{{ $property->post->deposit_ratio }}</h6>
                                        <span style="font-size: 14px;color: #000000;">&#x20BA;</span>
                                    </div>
                                    <div>
                                        <h6>İhaleye katılabilmeniz için belirlenmiş hizmet bedelini Proptürk hesabına yatırmanız gerekmektedir.</h6>
                                    </div>
                                    <div>
                                        {{-- Statik --}}
                                        <h6 style="font-weight:600;">TR82 0014 6000 0014 6691 3000 01</h6>
                                    </div>
                                </div>
    
                                <div class="col-12 col-md-6 pr-0 pl-0" style="color:black;">
                                    <div>
                                        <h6 style="font-weight:600;"><span>{{ $property->post->bank->name }}</span> Teminat Tutarı</h6>
                                    </div>
                                    <div style="display: flex;flex-direction: row;align-items: center;font-weight: bold;">
                                        <h6 class="money mb-0" style="font-weight: bold;">{{ $property->post->entry_price }}</h6><span style="font-size: 14px;color: #000000;">&#x20BA; </span>
                                    </div>
                                    <div>
                                        <h6>İhaleye katılabilmeniz için belirlenmiş teminat tutarını bankaya yatırmanız gerekmektedir.</h6>
                                    </div>
                                    <div>
                                        {{-- Banka İbanı --}}
                                        <h6 style="font-weight:600;"style="font-weight: bold;">TR{{ $property->post->bank->iban }}</h6>
                                    </div>
                                </div>
                            </div>
                            
                            
                        </div>

                    </div>
                </div>

                <!-- Mail Modal -->
                <div class="modal fade" id="mailModal" tabindex="-1" role="dialog" aria-labelledby="mailModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                            <h5 class="modal-title" id="mailModalLabel">Gerekli Adımlar</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            </div>
                            <div class="modal-body">
                                <p>Teklif verebilmeniz için gerekli adımları bitirmeniz gerekmektedir. Gerekli adımları mail adresinize göndermek istiyor musunuz?</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Hayır</button>
                                <a href="{{ route('mail.tenderUserPermission', ['slug' => $property->slug]) }}" class="btn btn-primary">Evet</a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </article>

        {{--  <article class="pb-3" style="padding-left: 20px;padding-right:20px;">
            <div class="row no-gutter">
                <div class="col-12 col-lg-7 order-0 position-relative m-mb-20">
                    <div class="slider-for slide_max arrow_inner d-none">  --}}

        <div class="pb-3" style="padding-left: 20px;padding-right:20px;">
            <div class="row no-gutter">
                <div class="col-12 col-lg-7 order-0 position-relative m-mb-20">
                    <section class="bg-white p-3 px-lg-4 pt-4 pb-5 border mb-4">
                        <a href="{{ $property->parsel_request_url }}" class="btn btn-primary btn-parsel-url" target="_blank">Parseli Sorgula</a>
                        <header class="border-bottom border-dark mb-4">
                            <h4 class="text-dark font-weight-bold mb-3">Ana Özellikler</h4>
                        </header>
                        <div class="text-center text-muted text_small imovel_content d-flex flex-wrap justify-content-around align-items-center" style="margin-bottom: 30px;border-bottom: 1px solid #ddd;">
                            <span class="p-3" style="color: black;">
                                <i class="far fa-building fa-2x text-muted"></i>
                                <br>
                                {{ config('enums.property_type')[$property->property_type] }}
                                <br>
                                @if (isset($property->house_type))
                                    {{ config('enums.house_type')[$property->house_type] }}
                                @elseif (isset($property->workplace_type))
                                    {{ config('enums.workplace_type')[$property->workplace_type] }}
                                @elseif (isset($property->land_type))
                                    {{ config('enums.land_type')[$property->land_type] }}
                                @endif
                            </span>

                            @if (isset($property->room_count))
                                <span class="p-3" style="color: black;">
                                    <i class="fas fa-columns fa-2x text-muted"></i><br>
                                    {{ config('enums.room_count')[$property->room_count] }}
                                </span>
                            @endif

                            @if (isset($property->floor))
                                <span class="p-3" style="color: black;">
                                    <i class="fas fa-warehouse fa-2x text-muted"></i><br>
                                    {{ config('enums.floor')[$property->floor] }}.Kat
                                </span>
                            @endif
                            
                            @if (isset($property->net_m2))
                                <span class="p-3" style="color: black;"><i class="fas fa-border-style fa-2x text-muted"></i><br>Net: 
                                    {{ number_format($property->net_m2, 0, '.', '.') }}
                                    m<sup>2</sup></span>
                            @endif

                            @if (isset($property->gross_m2))
                                <span class="p-3" style="color: black;"><i class="fas fa-border-none fa-2x text-muted"></i><br>Brüt: {{ number_format($property->gross_m2, 0, '.', '.') }}m<sup>2</sup></span> 
                            @endif
                            
                        </div>

                        {{-- Arsa --}}
                        @if ($property->property_type == 2)
                            <div class="text-muted text_small imovel_content d-flex flex-wrap justify-content-flex-start property-perm">
                                @isset($property->city_block_no)
                                    <div class="col-4 col-lg-3 text-center">
                                        <h5>Ada No</h5>
                                        <p>{{ $property->city_block_no }}</p>
                                    </div>
                                @endisset
                                @isset($property->parcel_no)
                                    <div class="col-4 col-lg-3 text-center">
                                        <h5>Parsel</h5>
                                        <p>{{ $property->parcel_no }}</p>
                                    </div>
                                @endisset
                                
                                @isset($property->independent_section_no)
                                    <div class="col-4 col-lg-3 text-center">
                                        <h5>BB No</h5>
                                        <p>{{ $property->independent_section_no }}</p>
                                    </div>
                                @endisset
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Tapu Durumu</h5>
                                    @isset($property->land_state)
                                        <p>{{ config('enums.land_state')[$property->land_state] }}</p>
                                    @endisset
                                </div>
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Kaks(Emsal)</h5>
                                    @isset($property->peer)
                                        <p>{{ config('enums.peer')[$property->peer] }}</p>
                                    @endisset
                                </div>
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Gabari</h5>
                                    @isset($property->clearence)
                                        <p>{{ config('enums.clearence')[$property->clearence] }}</p>
                                    @endisset
                                </div>
                            </div>
                        @endif

                        {{-- İş Yeri --}}
                        @if ($property->property_type == 1)
                            <div class="text-muted text_small imovel_content d-flex flex-wrap justify-content-flex-start property-perm">
                                @isset($property->city_block_no)
                                    <div class="col-4 col-lg-3 text-center">
                                        <h5>Ada No</h5>
                                        <p>{{ $property->city_block_no }}</p>
                                    </div>
                                @endisset
                                @isset($property->parcel_no)
                                    <div class="col-4 col-lg-3 text-center">
                                        <h5>Parsel</h5>
                                        <p>{{ $property->parcel_no }}</p>
                                    </div>
                                @endisset
                                
                                @isset($property->independent_section_no)
                                    <div class="col-4 col-lg-3 text-center">
                                        <h5>BB No</h5>
                                        <p>{{ $property->independent_section_no }}</p>
                                    </div>
                                @endisset
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Kullanım Durumu</h5>
                                    @isset($property->using_status)
                                        <p>{{ config('enums.using_status')[$property->using_status] }}</p>
                                    @endisset
                                </div>
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Bina Yaşı</h5>
                                    @isset($property->building_age)
                                        <p>{{ config('enums.building_age')[$property->building_age] }}</p>
                                    @endisset
                                </div>
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Isıtma</h5>
                                    @isset($property->heating_type)
                                        <p>{{ config('enums.heating_type')[$property->heating_type] }}</p>
                                    @endisset
                                </div> 
                            </div>
                        @endif

                        {{-- Konut --}}
                        @if ($property->property_type == 0)
                            <div class="text-muted text_small imovel_content d-flex flex-wrap justify-content-flex-start property-perm">
                                @isset($property->city_block_no)
                                    <div class="col-4 col-lg-3 text-center">
                                        <h5>Ada No</h5>
                                        <p>{{ $property->city_block_no }}</p>
                                    </div>
                                @endisset
                                @isset($property->parcel_no)
                                    <div class="col-4 col-lg-3 text-center">
                                        <h5>Parsel</h5>
                                        <p>{{ $property->parcel_no }}</p>
                                    </div>
                                @endisset
                                
                                @isset($property->independent_section_no)
                                    <div class="col-4 col-lg-3 text-center">
                                        <h5>BB No</h5>
                                        <p>{{ $property->independent_section_no }}</p>
                                    </div>
                                @endisset
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Kullanım Durumu</h5>
                                    @isset($property->using_status)
                                        <p>{{ config('enums.using_status')[$property->using_status] }}</p>
                                    @endisset
                                </div>
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Bina Yaşı</h5>
                                    @isset($property->building_age)
                                        <p>{{ config('enums.building_age')[$property->building_age] }}</p>
                                    @endisset
                                </div>
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Isıtma</h5>
                                    @isset($property->heating_type)
                                        <p>{{ config('enums.heating_type')[$property->heating_type] }}</p>
                                    @endisset
                                </div>
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Oda Sayısı</h5>
                                    @isset($property->room_count)
                                        <p>{{ config('enums.room_count')[$property->room_count] }}</p>
                                    @endisset
                                </div>
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Kat Sayısı</h5>
                                    @isset($property->total_floor)
                                        <p>{{ config('enums.total_floor')[$property->total_floor] }}</p>
                                    @endisset
                                </div>
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Banyo Sayısı</h5>
                                    @isset($property->bath_count)
                                        <p>{{ config('enums.bath_count')[$property->bath_count] }}</p>
                                    @endisset
                                </div>
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Balkon</h5>
                                    @if ($property->is_balcony == 1)
                                        <p>Var</p>
                                    @else
                                        <p>Yok</p>
                                    @endif
                                </div>
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Eşyalı</h5>
                                    @if ($property->is_furnished == 1)
                                        <p>Evet</p>
                                    @else
                                        <p>Hayır</p>
                                    @endif
                                </div>
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Site İçerisinde</h5>
                                    @if ($property->is_site == 1)
                                        <p>Evet</p>
                                    @else
                                        <p>Hayır</p>
                                    @endif
                                </div>
                                <div class="col-4 col-lg-3 text-center">
                                    <h5>Kredi Uygun</h5>
                                    @if ($property->is_creditable == 1)
                                        <p>Evet</p>
                                    @else
                                        <p>Hayır</p>
                                    @endif
                                </div>
                            </div>
                        @endif
                        
                    </section>

                    <section class="bg-white p-3 px-lg-4 pt-4 pb-5 border mb-4">
                        <header class="border-bottom border-dark mb-4">
                            <h4 class="text-dark font-weight-bold mb-3">Özellikler</h4>
                        </header>
                        {{-- Arsa --}}
                        @if ($property->property_type == 2)
                            @isset($property->general_properties_land)
                                <div class="col-12" style="margin-bottom: 20px;">
                                    <h5 class="text-dark font-weight-bold mb-3" style="text-decoration: underline">Genel Özellikler</h5>
                                </div>
                                <ul class="imovel_elements list-unstyled text-muted text-center clearfix" style="margin-bottom: 30px;">
                                    @isset($property->general_properties_land)
                                        @foreach (unserialize($property->general_properties_land) as $key => $general_properties_land)
                                            <li class="list-inline-item mr-3">{{ config('enums.general_properties_land')[$key] }}</li>
                                        @endforeach
                                    @endisset
                                </ul>
                            @endisset
                            @isset($property->infrastructure)
                                <div class="col-12" style="margin-bottom: 20px;">
                                    <h5 class="text-dark font-weight-bold mb-3" style="text-decoration: underline">Altyapı</h5>
                                </div>
                                <ul class="imovel_elements list-unstyled text-muted text-center clearfix">
                                    @isset($property->infrastructure)
                                        @foreach (unserialize($property->infrastructure) as $key => $infrastructure)
                                            <li class="list-inline-item mr-3">{{ config('enums.infrastructure')[$key] }}</li>
                                        @endforeach
                                    @endisset
                                </ul>
                            @endisset
                        @endif
                        {{-- İş Yeri --}}
                        @if ($property->property_type == 1)
                            @isset($property->side)
                                <div class="col-12" style="margin-bottom: 20px;">
                                    <h5 class="text-dark font-weight-bold mb-3" style="text-decoration: underline">Cephe</h5>
                                </div>
                                <ul class="imovel_elements list-unstyled text-muted text-center clearfix" style="margin-bottom: 30px;">
                                    @isset($property->side)
                                        @foreach (unserialize($property->side) as $key => $side)
                                            <li class="list-inline-item mr-3">{{ config('enums.side')[$key] }}</li>
                                        @endforeach
                                    @endisset
                                </ul>
                            @endisset
                            @isset($property->general_properties)
                                <div class="col-12" style="margin-bottom: 20px;">
                                    <h5 class="text-dark font-weight-bold mb-3" style="text-decoration: underline">Genel Özellikler</h5>
                                </div>
                                <ul class="imovel_elements list-unstyled text-muted text-center clearfix" style="margin-bottom: 30px;">
                                    @isset($property->general_properties)
                                        @foreach (unserialize($property->general_properties) as $key => $general_properties)
                                            <li class="list-inline-item mr-3">{{ config('enums.general_properties')[$key] }}</li>
                                        @endforeach
                                    @endisset
                                </ul>
                            @endisset
                        @endif
                        {{-- Konut --}}
                        @if ($property->property_type == 0)
                            @isset($property->side)
                                <div class="col-12" style="margin-bottom: 20px;">
                                    <h5 class="text-dark font-weight-bold mb-3" style="text-decoration: underline">Cephe</h5>
                                </div>
                                <ul class="imovel_elements list-unstyled text-muted text-center clearfix" style="margin-bottom: 30px;">
                                    @isset($property->side)
                                        @foreach (unserialize($property->side) as $key => $side)
                                            <li class="list-inline-item mr-3">{{ config('enums.side')[$key] }}</li>
                                        @endforeach
                                    @endisset
                                </ul>
                            @endisset
                            @isset($property->inside_properties)
                                <div class="col-12" style="margin-bottom: 20px;">
                                    <h5 class="text-dark font-weight-bold mb-3" style="text-decoration: underline">İç Özellikler</h5>
                                </div>
                                <ul class="imovel_elements list-unstyled text-muted text-center clearfix" style="margin-bottom: 30px;">
                                    @isset($property->inside_properties)
                                        @foreach (unserialize($property->inside_properties) as $key => $inside_properties)
                                            <li class="list-inline-item mr-3">{{ config('enums.inside_properties')[$key] }}</li>
                                        @endforeach
                                    @endisset
                                </ul>
                            @endisset
                            @isset($property->outside_properties)
                                <div class="col-12" style="margin-bottom: 20px;">
                                    <h5 class="text-dark font-weight-bold mb-3" style="text-decoration: underline">Dış Özellikler</h5>
                                </div>
                                <ul class="imovel_elements list-unstyled text-muted text-center clearfix">
                                    @isset($property->outside_properties)
                                        @foreach (unserialize($property->outside_properties) as $key => $outside_properties)
                                            <li class="list-inline-item mr-3">{{ config('enums.outside_properties')[$key] }}</li>
                                        @endforeach
                                    @endisset
                                </ul>
                            @endisset
                        @endif
                        
                    </section>

                    <section class="bg-white p-3 px-lg-4 pt-4 pb-5 border mb-4">
                        <header class="border-bottom border-dark mb-4">
                            <h4 class="text-dark font-weight-bold mb-3">Açıklama</h4>
                        </header>
                        <div class="text-muted summernote">
                            @isset($property->post->desc)
                                {!! $property->post->desc !!}
                            @endisset
                        </div>
                    </section>

                    <section class="bg-white p-3 px-lg-4 pt-4 pb-5 border mb-4">
                        <header class="border-bottom border-dark mb-4">
                            <h4 class="text-dark font-weight-bold mb-3">Adres</h4>
                        </header>
                        <p class="text-body">{{ $property->country }} - {{ $property->district }} - {{ $property->neighborhood }}</p>
                        <p class="text-body"><i class="far fa-map"></i> {{ $property->address }}</p>
                        
                        <div id="map" style="width: 100%; height: 500px;"></div>
                    </section>
                </div>

                {{--  <div class="col-12 col-lg-5">
                    <div class="pr-lg-2 pr-xl-5 px-sm-4" style="height: 100%;">  --}}

                <!--sidebar-->
                <div class="col-12 col-lg-5">
                    <div class="pr-lg-2 pr-xl-5 px-sm-4" style="height: 100%;">
                        
                        <div class="col-md-6 col-lg-12 mb-4 pl-0 pr-0">
                            <section class="bg-white border p-3 px-lg-4 pt-4">
                                <header class="border-bottom border-dark pb-3 mb-4">
                                    <h4 class="text-dark font-weight-bold mb-0">Nasıl Gayrimenkül edinirim?</h4>
                                </header>
                                <div>
                                    <h6 style="text-align: justify;line-height: 1.4rem;letter-spacing: 0.1rem;">
                                        Web sitemize ücretsiz olarak üye olun.

                                        Sitemizde bulunan gayrimenkullerden size uygun olan taşınmaz hakkında sitede yer alan detaylı bilgileri inceleyin.

                                        İlgilendiğiniz gayrimenkulü ziyaret ederek yerinde görün ve satış süreçleri hakkında uzmanlarımız ile görüşün bilgi alın.

                                        İhale şartnamesini imzalayın ve ihaleye katılım koşullarını sağlayın.

                                        İhale katılım bedelini ilgili hesaba ödeyin.

                                        Artık ilgilendiğiniz gayrimenkul için ihaleye katılım sağlayarak teklifinizi sunabilirsiniz.

                                        İhaleyi kazandığınız tutar üzerinden ödemeyi tapu alım esnasında veya öncesinde ödeyerek satış işlemini tamamlayın.</h6>
                                </div>
                            </section>
                        </div>


                        <div class="col-md-6 col-lg-12 pl-0 pr-0">
                            <section class="bg-white border p-3 px-lg-4 pt-4 mb-4">
                                <header class="border-bottom border-dark pb-3 mb-4">
                                    <h4 class="text-dark font-weight-bold mb-0">İletişim</h4>
                                    <p class="tagline mb-0 text-muted">Bizimle İletişime Geçin!</p>
                                </header>

                                <form class="pb-4" action="#" method="post" enctype="multipart/form-data">
                                    <div class="input-group border mb-3">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text bg-light border-0 text-muted">
                                                <i class="far fa-user"></i>
                                            </span>
                                        </div>
                                        <input 
                                            type="text" 
                                            class="form-control text-muted border-0 bg-light"
                                            name="client_name" 
                                            value=""
                                            id="name"
                                            placeholder="İsim" 
                                            required
                                            >
                                    </div>

                                    <div class="input-group border mb-3">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text border-0 text-muted bg-light">
                                                <i class="far fa-envelope"></i>
                                            </span>
                                        </div>
                                        <input 
                                            type="text" 
                                            class="form-control border-0 text-muted bg-light"  
                                            name="client_email"
                                            value="" 
                                            id="email"
                                            placeholder="Eposta Adresi" 
                                            required
                                            >
                                    </div>

                                    <div class="input-group border mb-3">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text border-0 text-muted bg-light">
                                                <i class="fas fa-phone-alt"></i>
                                            </span>
                                        </div>
                                        <input type="tel" 
                                                class="form-control text-muted border-0 bg-light"
                                                name="client_phone"
                                                id="phone"
                                                placeholder="Telefon Numarası"
                                                value=""  
                                                required
                                                >
                                    </div>

                                    <div class="form-group mt-2 border">
                                        <textarea 
                                            class="form-control border-0 bg-light" 
                                            name="client_message" 
                                            rows="5" 
                                            id="message"
                                            >Bu mülkü beğendim ve sizinle iletişime geçmek istiyorum.</textarea>
                                    </div>

                                    <button class="btn btn-primary btn-block py-3" style="pointer-events: none;" type="submit">
                                        Mesaj Gönder
                                    </button>
                                </form>
                            </section>
                        </div>

                        <!--<div class="col-md-8 col-lg-12 pl-0 pr-0">
                            <section class="bg-white border p-3 px-lg-4 pt-4">
                                <header class="border-bottom border-dark pb-3 mb-4">
                                    <h4 class="text-dark font-weight-bold mb-0">Benzer Ürünler</h4>
                                    <p class="tagline mb-0 text-muted">
                                        İlginizi Çekebilecek İlanlara Göz Atın!
                                    </p>
                                </header>

                                <div class="slide_single slide_max">

                                    

                                </div>
                            </section>
                        </div>-->

                    </div>
                </div>
            </div>
        </div>
        
    </main>
    <!-- end main container -->

    <!-- Button trigger modal -->
    <button type="button" class="btn btn-primary mobile-map-btn" data-toggle="modal" data-target="#mapModal">
        <i class='fas fa-globe'></i> Gayrimenkul Konumu
    </button>
    
    <!-- Modal -->
    <div class="modal fade" id="mapModal" tabindex="-1" role="dialog" aria-labelledby="mapModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="col-12 text-center">
                        <h5 class="modal-title" id="mapModalLabel" style="font-size: 13px;"><i class='fas fa-map-marker-alt'></i>{{ $property->country }} - {{ $property->district }} - {{ $property->neighborhood }}</h5>
                    </div>
                    
                    {{-- <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button> --}}
                </div>
                <div class="modal-body">
                    <div id="map-mobile" style="width: 100%; height: 300px;"></div>
                    <p class="text-body mb-1 mt-4"><i class="far fa-map"></i> {{ $property->address }}</p>
                </div>
                <div class="modal-footer" style="justify-content: center;">
                    <button type="button" class="btn btn-dark" style="border-radius:0 !important;" data-dismiss="modal">Kapat</button>
                </div>
            </div>
        </div>
    </div>
@stop

@section('scripts')
    @parent
    <script src='https://api.mapbox.com/mapbox-gl-js/v2.3.1/mapbox-gl.js'></script>
    <script src="{{ asset('js/rodanjor.js') }}"></script>
        @if(Auth::user())
        <script>
            
            window.Echo.private('posts.{!! $property->post->id !!}')
            .listen('TenderOfferValueUpdateEvent', (e) => {
                if(e.post.winner_id == {!! Auth::user()->id !!}) {
                    $('#winner-alert').removeClass('winner-div-none');
                    $('#winner-alert').addClass('winner-div');
                    $('#loser-alert').removeClass('loser-div');
                    $('#loser-alert').addClass('loser-div-none');
                }
                // console.log(jQuery.in_array({!! Auth::user()->id !!}, e.post.offersIds));
                else if(e.post.winner_id != {!! Auth::user()->id !!} && jQuery.inArray({!! Auth::user()->id !!}, e.post.offersIds) !== -1 ) {
                    $('#winner-alert').removeClass('winner-div');
                    $('#winner-alert').addClass('winner-div-none');
                    $('#loser-alert').removeClass('loser-div-none');
                    $('#loser-alert').addClass('loser-div');
                }
                


                if(e.post.pageRefreshForFirstOffer || e.post.tender_status == 2) {
                    location.reload(true);
                }
                $('#current_price').html(e.post.current_price);
                $('#bid_amountId').val(e.post.new_offer);
                $('#modal-new-offer').html(e.post.new_offer);
                $('#modal-new-offer-title').html('Yeni Teklif Gelmiştir.');
                
                $('#postEndDate').html('Bitiş Tarihi : '+e.post.endTimeDay+' '+e.post.endTimeMonth+' '+e.post.endTimeYear+' - '+e.post.endTimeClock)
                function getTimeRemaining(endtime) {
                    var t = Date.parse(endtime) - Date.parse(new Date());
                    var seconds = Math.floor((t / 1000) % 60);
                    var minutes = Math.floor((t / 1000 / 60) % 60);
                    var hours = Math.floor((t / (1000 * 60 * 60)) % 24);
                    var days = Math.floor(t / (1000 * 60 * 60 * 24));
                    return {
                        'total': t,
                        'days': days,
                        'hours': hours,
                        'minutes': minutes,
                        'seconds': seconds
                    };
                }

                // Get a reference to the last interval + 1


                function initializeClock(id, endtime) {
                    const interval_id = window.setInterval(function(){}, Number.MAX_SAFE_INTEGER);

                    // Clear any timeout/interval up to that id
                    for (let i = 1; i < interval_id; i++) {
                    window.clearInterval(i);
                    }
                    var clock = document.getElementById(id);
                    var daysSpan = clock.querySelector('.days');
                    var hoursSpan = clock.querySelector('.hours');
                    var minutesSpan = clock.querySelector('.minutes');
                    var secondsSpan = clock.querySelector('.seconds');

                    
                    function updateClock() {
                        var t = getTimeRemaining(endtime);

                        daysSpan.innerHTML = t.days;
                        hoursSpan.innerHTML = ('0' + t.hours).slice(-2);
                        minutesSpan.innerHTML = ('0' + t.minutes).slice(-2);
                        secondsSpan.innerHTML = ('0' + t.seconds).slice(-2);

                        if (t.total <= 0) {
                            clearInterval(timeinterval);
                            setTimeout(function(){
                                window.location.href = "{{ route('home')}}"
                            }, 1200);
                        }
                    }
                    var timeinterval = setInterval(updateClock, 1000);
                    updateClock();
                }

                
                var deadline = new Date(Date.parse(new Date()) + e.post.diffInSeconds * 1000);
                
                initializeClock('clockdiv', deadline);
            });
        </script>
        @endif

    <script>
        $(document).ready(function() {
            if (window.matchMedia('(max-width: 900px)').matches) {
                $('#map').remove();
                
                var lantg = {!! $property->longitude !!};
                var lontg = {!! $property->langitude !!};
            
                mapboxgl.accessToken = 'pk.eyJ1IjoicHJvcHR1cmsiLCJhIjoiY2t6cDk0MWZtMDhtNTJvbzJ1MWtpYTdyeiJ9._g9p7Eb8o8IaUMLKnHyRag';
                const map = new mapboxgl.Map({
                    container: 'map-mobile', // container ID
                    style: 'mapbox://styles/mapbox/streets-v11', // style URL
                    center: [lantg, lontg], // starting position [lng, lat]
                    zoom: 15 // starting zoom
                });
                const marker = new mapboxgl.Marker()
                .setLngLat([lantg, lontg])
                .addTo(map);
            }
        });
    </script>
    <script>
        $(document).ready(function() {

            if (window.matchMedia('(min-width: 950px)').matches) {
                $('#map-mobile').remove();

                var lantg = {!! $property->longitude !!};
                var lontg = {!! $property->langitude !!};
            
                mapboxgl.accessToken = 'pk.eyJ1IjoicHJvcHR1cmsiLCJhIjoiY2t6cDk0MWZtMDhtNTJvbzJ1MWtpYTdyeiJ9._g9p7Eb8o8IaUMLKnHyRag';
                const map = new mapboxgl.Map({
                    container: 'map', // container ID
                    style: 'mapbox://styles/mapbox/streets-v11', // style URL
                    center: [lantg, lontg], // starting position [lng, lat]
                    zoom: 15 // starting zoom
                });
                const marker = new mapboxgl.Marker()
                .setLngLat([lantg, lontg])
                .addTo(map);
            }


            // mapboxgl.accessToken = 'pk.eyJ1IjoicHJvcHR1cmsiLCJhIjoiY2t6cDk0MWZtMDhtNTJvbzJ1MWtpYTdyeiJ9._g9p7Eb8o8IaUMLKnHyRag';
            //     const map = new mapboxgl.Map({
            //     style: 'mapbox://styles/mapbox/light-v10',
            //     center: [lantg, lontg],
            //     zoom: 15.5,
            //     pitch: 45,
            //     bearing: -17.6,
            //     container: 'map',
            //     antialias: true
            // });

            // map.on('load', () => {
            //     // Insert the layer beneath any symbol layer.
            //     const layers = map.getStyle().layers;
            //     const labelLayerId = layers.find(
            //     (layer) => layer.type === 'symbol' && layer.layout['text-field']
            //     ).id;

            //     // The 'building' layer in the Mapbox Streets
            //     // vector tileset contains building height data
            //     // from OpenStreetMap.
            //     map.addLayer(
            //     {
            //         'id': 'add-3d-buildings',
            //         'source': 'composite',
            //         'source-layer': 'building',
            //         'filter': ['==', 'extrude', 'true'],
            //         'type': 'fill-extrusion',
            //         'minzoom': 15,
            //         'paint': {
            //         'fill-extrusion-color': '#aaa',

            //         // Use an 'interpolate' expression to
            //         // add a smooth transition effect to
            //         // the buildings as the user zooms in.
            //         'fill-extrusion-height': [
            //             'interpolate',
            //             ['linear'],
            //             ['zoom'],
            //             15,
            //             0,
            //             15.05,
            //             ['get', 'height']
            //             ],
            //             'fill-extrusion-base': [
            //             'interpolate',
            //             ['linear'],
            //             ['zoom'],
            //             15,
            //             0,
            //             15.05,
            //             ['get', 'min_height']
            //         ],
            //         'fill-extrusion-opacity': 0.6
            //         }
            //     },
            //     labelLayerId
            //     );
            // });
            // const marker = new mapboxgl.Marker()
            // .setLngLat([lantg, lontg])
            // .addTo(map);



            
            $('.money').mask("#.##0", {reverse: true});

            var isClock = '{!! $property->post->end_time !!}';
            //console.log(isClock);
            var diffInSeconds = {!! $diffInSeconds !!};
            function getTimeRemaining(endtime) {
                var t = Date.parse(endtime) - Date.parse(new Date());
                var seconds = Math.floor((t / 1000) % 60);
                var minutes = Math.floor((t / 1000 / 60) % 60);
                var hours = Math.floor((t / (1000 * 60 * 60)) % 24);
                var days = Math.floor(t / (1000 * 60 * 60 * 24));
                return {
                    'total': t,
                    'days': days,
                    'hours': hours,
                    'minutes': minutes,
                    'seconds': seconds
                };
            }

            function initializeClock(id, endtime) {
                var clock = document.getElementById(id);
                var daysSpan = clock.querySelector('.days');
                var hoursSpan = clock.querySelector('.hours');
                var minutesSpan = clock.querySelector('.minutes');
                var secondsSpan = clock.querySelector('.seconds');

                function updateClock() {
                    var t = getTimeRemaining(endtime);

                    daysSpan.innerHTML = t.days;
                    hoursSpan.innerHTML = ('0' + t.hours).slice(-2);
                    minutesSpan.innerHTML = ('0' + t.minutes).slice(-2);
                    secondsSpan.innerHTML = ('0' + t.seconds).slice(-2);

                    if (t.total <= 0) {
                        clearInterval(timeinterval);
                        setTimeout(function(){
                            window.location.href = "{{ route('home')}}"
                        }, 1200);
                    }
                }
                var timeinterval = setInterval(updateClock, 1000);
                updateClock();
            }
            if (isClock != '') {
                var deadline = new Date(Date.parse(new Date()) + diffInSeconds * 1000);
                initializeClock('clockdiv', deadline);
            }
        });
    </script>
@endsection