@extends('layout.layout')

@section('title', 'Kullanıcı Bilgileri')

@section('styles')
    @parent
    <style>
        .card {
            box-shadow: 0 1px 3px 0 rgba(0,0,0,.1), 0 1px 2px 0 rgba(0,0,0,.06);
        }

        .card {
            position: relative;
            display: flex;
            flex-direction: column;
            min-width: 0;
            word-wrap: break-word;
            background-color: #fff;
            background-clip: border-box;
            border: 0 solid rgba(0,0,0,.125);
            border-radius: .25rem;
        }

        .card-body {
            flex: 1 1 auto;
            min-height: 1px;
            padding: 1rem;
        }

        .warning-i{
            cursor: pointer;
        }
        
        .warning-info-box{
            display: none;
            position: absolute;
            width: 172px;
            left: 130px;
            top: -20px;
            z-index: 2;
            box-shadow: 0 0 5px rgb(0 0 0 / 10%);
        }

        .warning-i:hover ~ .warning-info-box{
            display: block !important;
        }

    </style>
@stop

@section('content')

    @include('flash_message.flash')

    <main class="bg-light">        
        <section>
            <header>
                <div class="py-5" style="background-color: rgb(0 0 0 / 82%);">
                    <div class="container py-3 position-relative text_shadow text-white">
                        <div class="row justify-content-center">
                            <div class="col-md-10 col-lg-8 col-xl-6">
                                <h2 class="font-weight-bold h1 section_title">Kullanıcı Bilgilerim</h2>
                            </div>
                        </div>
                    </div>
                </div>
            </header>
            <div class="container py-5" style="display: flex;justify-content: center;">                
                <div class="col-md-8">
                    
                    <div class="card mb-3">
                        <div class="card-body">
                            
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0 text-secondary">İsim Soyisim</h6>
                                </div>
                                <div class="col-sm-9">
                                    {{ $user->name }} {{ $user->surname }}
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0 text-secondary">Şirket Ünvanı</h6>
                                </div>
                                <div class="col-sm-9">
                                    {{ $user->company_name }}
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0 text-secondary">Şirket Vergi Dairesi</h6>
                                </div>
                                <div class="col-sm-9">
                                    {{ $user->company_tax_office }}
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0 text-secondary">Şirket Vergi No</h6>
                                </div>
                                <div class="col-sm-9">
                                    {{ $user->company_tax_id }}
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0 text-secondary">Eposta Adresi</h6>
                                </div>
                                <div class="col-sm-9">
                                    {{ $user->email }}
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0 text-secondary">Telefon Numarası</h6>
                                </div>
                                <div class="col-sm-9">
                                    {{ $user->phone_number }} 
                                    @if ($user->is_active == 0)
                                        <i class="fa fa-info-circle warning-i" style="color: red;" aria-hidden="true"></i>
                                    @endif
                                    <div class="warning-info-box">
                                        <div style="padding: 5px;background:white;border: 1px solid #ddd;">
                                            <p class="mb-0" style="color: black;font-size: 11px;font-weight: 600;">Numaranız onaylı değil. Teklif verebilmeniz için lütfen numaranızı onaylayınız.</p>
                                        </div>
                                    </div>
                                    @if ($user->is_active == 1)
                                        <i class="fa fa-check" style="color:green;" aria-hidden="true"></i>
                                    @endif
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3 text-secondary">
                                    <h6 class="mb-0">TC Kimlik No</h6>
                                </div>
                                <div class="col-sm-9">
                                    {{ $user->identity_number }}
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-12 text-right">
                                    <a class="btn btn-primary" style="border-radius:0;" href="{{ route('user.edit', ['slug' => $user->slug]) }}">Düzenle</a>
                                </div>
                            </div>

                            
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

@stop

@section('scripts')
    @parent
@endsection