<?php

use App\Http\Controllers\Admin\AddressController;
use App\Http\Controllers\Admin\BankController;
use App\Http\Controllers\Admin\DocumentController;
use App\Http\Controllers\Admin\HomeController as AdminHomeController;
use App\Http\Controllers\Admin\PropertyController as AdminPropertyController;
use App\Http\Controllers\Admin\UserController as AdminUserController;

use App\Http\Controllers\User\TenderController;

use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PropertyApiController;
use App\Http\Controllers\ApiController;






Auth::routes();

Route::group(['prefix' => 'admin', 'as'=> 'admin.'], function() {
  Route::resource('banks', BankController::class);
  Route::resource('documents', DocumentController::class);

  Route::resource('properties', AdminPropertyController::class)->except('show');
  Route::get('/properties/{slug}', [AdminPropertyController::class, 'show'])->name('properties.show');
  Route::post('/properties/clone/count/{id}', [AdminPropertyController::class, 'cloneProperty'])->name('properties.clone');

  Route::resource('users', AdminUserController::class)->except('show');
  Route::get('users/sendCustomMail/{user}', [AdminUserController::class, 'sendCustomMail'])->name('users.sendCustomMail');
  Route::post('users/sendCustomMailUser/{user}', [AdminUserController::class, 'sendCustomMailUser'])->name('users.sendCustomMailUser');
  Route::get('users/getBankContract/{id}', [AdminUserController::class, 'getBankContract'])->name('users.getBankContract');

  Route::get('/home', [AdminHomeController::class, 'index'])->name('home');

  Route::get('/ajaxInput/{id}', [AdminHomeController::class, 'ajaxInput'])->name('ajaxInput');

  Route::get('/getbankId/{id}', [BankController::class, 'getBankDepositRatio'])->name('getBankDepositRatio');

  Route::get('/properties/image/{slug}', [AdminPropertyController::class, 'imagePage'])->name('imagePage');
  Route::post('properties/imageUpload/{slug}', [AdminPropertyController::class, 'imageUpload'])->name('imageUpload');
  Route::post('properties/imageDelete/{slug}', [AdminPropertyController::class, 'imageDelete'])->name('imageDelete');
  Route::get('/setTenderStatusActive/{id}', [AdminPropertyController::class, 'setTenderStatusActive'])->name('setTenderStatusActive');
  Route::get('/setTenderStatusPassive/{id}', [AdminPropertyController::class, 'setTenderStatusPassive'])->name('setTenderStatusPassive');
  Route::get('logs', [\Rap2hpoutre\LaravelLogViewer\LogViewerController::class, 'index'])->name('logs')->middleware('can:show-logs');
  Route::get('logs/mailSms', [AdminHomeController::class, 'smsMailLogs'])->name('logs.mailSms');
  Route::get('logs/mailView/{log}', [AdminHomeController::class, 'logMailView'])->name('logs.logMailView');
  Route::get('logs/logMailPdfsDownload/{log}/{user}/{post}', [AdminHomeController::class, 'logMailPdfsDownload'])->name('logs.logMailPdfsDownload');

  Route::get('/tenderReportDownload/{id}', [AdminPropertyController::class, 'getTenderReportPdf'])->name('getTenderReportPdf');

  Route::get('/archive-files/{slug}', [AdminPropertyController::class, 'archiveFilesIndex'])->name('archiveFiles.index');
  Route::post('/archive-files/{slug}', [AdminPropertyController::class, 'archiveFileUpload'])->name('archiveFile.upload');
  Route::post('/archive-files/{slug}/download', [AdminPropertyController::class, 'archiveFileDownload'])->name('archiveFile.download');
  Route::delete('/archive-files/{slug}', [AdminPropertyController::class, 'archiveFileDelete'])->name('archiveFile.delete');
});



Route::group(['prefix' => 'kullanici', 'as'=> 'user.'], function() {
  Route::put('/{slug}', [UserController::class, 'update'])->name('update');
  Route::get('/{slug}/guncelle', [UserController::class, 'edit'])->name('edit');
  Route::get('/{slug}', [UserController::class, 'show'])->name('show');
  Route::get('/sms-aktivasyon/{slug}', [UserController::class, 'smsSendForVerification'])->name('smsPage');
  Route::post('/sms-aktivasyon/{slug}', [UserController::class, 'smsVerification'])->name('smsVerification');
  Route::get('/ihaleler/{slug}', [UserController::class, 'showUserTenders'])->name('showUserTenders');
  Route::get('/ihaleler/favoricrud/{slug}', [UserController::class, 'userCRUDFavoriteTenders'])->name('userCRUDFavoriteTenders');
  Route::get('/ihaleler/{slug}', [UserController::class, 'showUserTenders'])->name('showUserTenders');
  Route::get('/ihaleler/favoricrud/{slug}', [UserController::class, 'userCRUDFavoriteTenders'])->name('userCRUDFavoriteTenders');
});



 Route::get('/', [HomeController::class, 'index'])->name('home');



Route::get('/tenderUserPermissionMail/{slug}', [HomeController::class, 'tenderUserPermissionMail'])->name('mail.tenderUserPermission');

Route::get('/getDistricts/{id}', [AddressController::class, 'getDistricts'])->name('address.getDistricts');
Route::get('/getNeighborhoods/{id}', [AddressController::class, 'getNeighborhoods'])->name('address.getNeighborhoods');


Route::get('/ihaleler/{slug}', [HomeController::class, 'show'])->name('post.show')->middleware('bank');
Route::put('/ihaleler/{slug}', [TenderController::class, 'bidCheck'])->name('bidCheck');








Route::get('/tenderReport', [TenderController::class, 'showResult'])->name('tender.report');

Route::get('/fastbuy/{slug}', [TenderController::class, 'fastBuy'])->name('fastBuy');
Route::get('/search', [HomeController::class, 'searchFilter'])->name('search');
Route::get('/updateFavoritePosts/{slug}', [UserController::class, 'userCRUDFavoriteTenders'])->name('updateFavoritePosts');


Route::get('/iletisim', [HomeController::class, 'contact'])->name('contact');
Route::get('/hakkimizda', [HomeController::class, 'aboutus'])->name('aboutus');
Route::get('/isimiz', [HomeController::class, 'ourjob'])->name('ourjob');
Route::get('/nasil-edinirim', [HomeController::class, 'buyRealestate'])->name('buy-realestate');
Route::get('/cerez-politikasi', [HomeController::class, 'cookiesPolicy'])->name('cookiesPolicy');
Route::get('/gizlilik-politikasi', [HomeController::class, 'privacyPolicy'])->name('privacyPolicy');
Route::get('/kvkk', [HomeController::class, 'kvkk'])->name('kvkk');

Route::get('/v/{slug}', [HomeController::class, 'shortURLtoURL'])->name('short.url');

Route::get('/getDistrictshome/{id}', [HomeController::class, 'getDistrictsHome'])->name('home.getDistrictsHome');

/*
Route::get('sitemap', function() {
  $file = Storage::get(storage_path('public/sitemap.xml'));
  return $file; 
});*/
