

<?php $__env->startSection('title', 'Giriş Yap'); ?>

<?php $__env->startSection('styles'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('styles'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- start main container -->
    <main class="bg-light bg_parallax">
        <div class="container py-5">
            <div class="row justify-content-center">
                <div class='py-5 px-3 px-md-5 my-3 col-md-8 col-xl-5 shadow bg-white text-left'>
                    <div class="text-center">
                        <a class="main_brand d-inline-block" href="<?php echo e(route('home')); ?>" title="propturk - Ana Sayfa">
                            <img class="d-block w-100" src="<?php echo e(asset('assets/img/logo.png')); ?>" alt="" title=""/>
                        </a>
                        <h2 class="font-weight-bold h4">Giriş Yap</h2>
                        <p class="tagline text-body mb-3">Lütfen giriş bilgilerinizi giriniz!</p>
                    </div>
                    <form method="POST" action="<?php echo e(route('login')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        
                        <div class="form-group">
                            <label for="email">Eposta Adresi</label>
                            <input type="email" name="email"  class="form-control" id="email" placeholder="Eposta Adresi" required>
                        </div>
                        <div class="form-group">
                            <label for="password">Şifre</label>
                            <input type="password" name="password" class="form-control" id="password" placeholder="Şifre" required>
                        </div>

                        <?php if(env('GOOGLE_RECAPTCHA_KEY')): ?>
                            <div class="g-recaptcha"
                                data-sitekey="<?php echo e(env('GOOGLE_RECAPTCHA_KEY')); ?>">
                            </div>
                        <?php endif; ?>
                        
                        <button type="submit" class="btn btn-primary py-3 btn-block" style="margin-top: 1rem;">Giriş</button>

                        <div class="mt-1 d-flex justify-content-between">
                            <a class="float-left" title="Şifremi Unuttum!" href="">Şifremi Unuttum!</a>
                            <a class="float-right" title="Kayıt Ol!" href="<?php echo e(route('register')); ?>">Üye Ol!</a>
                        </div>
                    </form>
                    <?php if($errors->any()): ?>
                        <div class="mt-2 mb-2">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e($error); ?>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                </div>

            </div>
        </div>

    </main>
    <!-- end main container -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
    <script src='https://www.google.com/recaptcha/api.js'></script>
    <script>
        
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/propturk/resources/views/auth/login.blade.php ENDPATH**/ ?>