

<?php $__env->startSection('title', 'Evrak Ekle'); ?>

<?php $__env->startSection('styles'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('styles'); ?>
    <style>
        .onoffswitch {
            position: relative; width: 55px;
            -webkit-user-select:none; -moz-user-select:none; -ms-user-select: none;
            margin-left: 35px;
            margin-top: 5px;
        }
        .onoffswitch-checkbox {
            position: absolute;
            opacity: 0;
            pointer-events: none;
        }
        .onoffswitch-label {
            display: block; overflow: hidden; cursor: pointer;
            height: 20px; padding: 0; line-height: 20px;
            border: 0px solid #FFFFFF; border-radius: 30px;
            background-color: #9E9E9E;
        }
        .onoffswitch-label:before {
            content: "";
            display: block; width: 30px; margin: -5px;
            background: #FFFFFF;
            position: absolute; top: 0; bottom: 0;
            right: 31px;
            border-radius: 30px;
            box-shadow: 0 6px 12px 0px #757575;
        }
        .onoffswitch-checkbox:checked + .onoffswitch-label {
            background-color: #42A5F5;
        }
        .onoffswitch-checkbox:checked + .onoffswitch-label, .onoffswitch-checkbox:checked + .onoffswitch-label:before {
        border-color: #42A5F5;
        }
        .onoffswitch-checkbox:checked + .onoffswitch-label .onoffswitch-inner {
            margin-left: 0;
        }
        .onoffswitch-checkbox:checked + .onoffswitch-label:before {
            right: 0px; 
            background-color: #2196F3; 
            box-shadow: 3px 6px 18px 0px rgba(0, 0, 0, 0.2);
        }
        .currency-wrap{
            position:relative;
        }
        
        .currency-code{
            position:absolute;
            left:8px;
            top:7px;
        }
        
        .text-currency{
            padding:10px 30px;
            border:solid 1px #ccc;
            border-radius:5px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<nav aria-label="breadcrumb">
    <ol class="breadcrumb bg-transparent p-0 text_small">
        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>">Admin</a></li>
        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.documents.index')); ?>">Evraklar</a></li>
        <li class="breadcrumb-item active">Evrak Oluştur</li>
    </ol>
</nav>


<section class="mb-5 pb-5">
    <header class="border-bottom my-4">
        <h3 class="text-primary font-weight-light"><i class="far fa-id-badge"></i> Evrak Oluştur</h3>
    </header>

    <div class="row py-3">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="tab-content" id="pills-tabContent">
                <section class="tab-pane fade show active" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                    <div class="py-3">
                        <form class="auto_save text-muted" name="document_store" action="<?php echo e(route('admin.documents.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="form-row">
                                <div class="col-sm-4 col-md-12 col-lg-4">                                    
                                    <div class="form-group">
                                        <label for="bank">Banka Seçiniz</label>
                                        <select class="form-control" name="bank_id" id="select-bank">
                                                    <option value="0">Banka Seçiniz</option>
                                                <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($bank->id); ?>"><?php echo e($bank->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-12 col-lg-4">
                                    <div class="form-group">
                                        <label for="name">Evrak Adı:</label>
                                        <input class="form-control" type="text" name="contract_name" id="contract-name" placeholder="Evrak Adı" >
                                    </div>
                                </div>


                                <div class="col-sm-4 col-md-12 col-lg-4">
                                    <div class="form-group">
                                        <label for="is_active">Evrak Aktif Mi?:</label>
                                        <div class="onoffswitch">
                                            <input type="checkbox" name="is_active" class="onoffswitch-checkbox" id="myonoffswitch" tabindex="0" value="0">
                                            <label class="onoffswitch-label" for="myonoffswitch"></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <p>
                                            Sözleşmede kullanılması gereken değişkenler aşağıda belirtilmiştir. 
                                            Değişkenin gelmesini istediğiniz yere belirtilen değeri kopyalayınız.
                                        </p>

                                        <table class="bankAgreementStyle">
                                            <tr>
                                              <th>Değişken Açıklama</th>
                                              <th>Değişken Değeri</th>
                                              <th>Değeri Kopyala</th>
                                            </tr>
                                            <tr>
                                              <td>İhale Kodu</td>
                                              <td>{{ihaleKodu}}</td>
                                              <td>
                                                <button class="btn btn-light button-copy" type="button" value="{{ihaleKodu}}">Kopyala</button>
                                            </td>
                                            </tr>
                                            <tr>
                                                <td>İl, İlçe, Mahalle, Ada, Parsel, Bağımsız Bölüm Bilgileri</td>
                                                <td>{{ihaleKonumBilgileri}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{ihaleKonumBilgileri}}">Kopyala</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>İl</td>
                                                <td>{{ihaleIlBilgisi}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{ihaleIlBilgisi}}">Kopyala</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>İlçe</td>
                                                <td>{{ihaleIlceBilgisi}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{ihaleIlceBilgisi}}">Kopyala</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>İhale Taşınmaz Adresi</td>
                                                <td>{{ihaleAcikAdresi}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{ihaleAcikAdresi}}">Kopyala</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Taşınmaz Başlangıç Fiyatı</td>
                                                <td>{{tasinmazBaslangicFiyati}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{tasinmazBaslangicFiyati}}">Kopyala</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Banka İhale Teminat Bedeli</td>
                                                <td>{{bankaDepozito}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{bankaDepozito}}">Kopyala</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Propturk İhale Teminat Bedeli</td>
                                                <td>{{propturkDepozito}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{propturkDepozito}}">Kopyala</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Müşteri Adı Soyadı</td>
                                                <td>{{musteriAdi}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{musteriAdi}}">Kopyala</button>
                                                </td>
                                            </tr>

                                                                                        <tr>
                                                <td>Müşteri Şirket Ünvanı</td>
                                                <td>{{musteriSirketUnvani}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{musteriSirketUnvani}}">Kopyala</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Müşteri Şirket Vergi Dairesi</td>
                                                <td>{{musteriSirketVergiDairesi}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{musteriSirketVergiDairesi}}">Kopyala</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Müşteri Şirket Vergi No</td>
                                                <td>{{musteriSirketVergiNo}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{musteriSirketVergiNo}}">Kopyala</button>
                                                </td>
                                            </tr>

                                            
                                            <tr>
                                                <td>Müşteri TC Kimlik No</td>
                                                <td>{{musteriTcKimlikNo}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{musteriTcKimlikNo}}">Kopyala</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Müşteri Telefon Numarası</td>
                                                <td>{{musteriTelefonNumarasi}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{musteriTelefonNumarasi}}">Kopyala</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Müşteri E-mail</td>
                                                <td>{{musteriEmail}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{musteriEmail}}">Kopyala</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Müşteri Adresi</td>
                                                <td>{{musteriAdresi}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{musteriAdresi}}">Kopyala</button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Bugün (Ör. 01/01/2023)</td>
                                                <td>{{bugunTarih}}</td>
                                                <td>
                                                    <button class="btn btn-light button-copy" type="button" value="{{bugunTarih}}">Kopyala</button>
                                                </td>
                                            </tr>                                            
                                          </table>
                                          <br>
                                        <div class="currency-wrap">
                                            <label for="contract_description">Sözleşme:</label>
                                            <textarea rows="10" class="form-control tinymce-editor" name="contract_description" id="contract_description" ></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="text-right pt-4">
                                <button type="submit" class="btn btn-lg btn-danger slow_3s  position-relative px-5">Evrak Oluştur
                                    <span class="form_load position-absolute">
                                        <span class="spinner-border text-light" role="status">
                                            <span class="sr-only">Loading...</span>
                                        </span>
                                    </span>
                                </button>
                            </div>
                        </form>
                    </div>
                </section>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.13.4/jquery.mask.min.js"></script>
    <script src="https://cdn.tiny.cloud/1/o0m8w9yhwd8ct46kd3kd1icctxv5cc0i9vmwonijms4a3ga6/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>

    <script>
        $(document).ready(function () {
            tinymce.init({
                selector: 'textarea.tinymce-editor',
                height: 300,
                menubar: true,
                plugins: [
                    'advlist autolink lists link image charmap print preview anchor',
                    'searchreplace visualblocks code',
                    'insertdatetime media table paste code help wordcount', 'image'
                ],
                toolbar: 'undo redo | formatselect | ' +
                    'bold italic backcolor | alignleft aligncenter ' +
                    'alignright alignjustify | bullist numlist outdent indent | ' +
                    'removeformat | help',
                content_css: '//www.tiny.cloud/css/codepen.min.css'
            });           
        });
    </script>
    <script>
        $(document).ready(function () {
            $(".button-copy").click(function (e) { 
                e.preventDefault();
                var copiedData = $(this).val();
                // console.log(copiedData);
                navigator.clipboard.writeText(copiedData);
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/propturk/resources/views/admin/documents/create.blade.php ENDPATH**/ ?>