<article class="col-md-6 col-lg-3 col-xl-3 mb-5" style="height: 100%;">
    <a class="text-decoration-none bg-white d-block" title="İlan Detayları" href="<?php echo e(route('post.show', ['slug' => $post->postable->slug])); ?>">
        <div class="card border-0">
            <div class="new-card-clock-main">
                <div class="new-card-clock-card">
                    <?php if($post->diffinseconds): ?>
                        <div id="clockdiv-<?php echo e($post->id); ?>" class="d-flex" style="grid-gap: 10px;align-items: center;">
                            <div style="display: flex;flex-direction: row;align-items: center;">
                                <span class="days" style="font-size: 14px;"></span>
                                <div class="smalltext" style="font-size: 14px;margin-left: 3px;">Gün</div>
                            </div>
                            <div style="display: flex;flex-direction: row;align-items: center;">
                                <span class="hours" style="font-size: 14px;"></span>
                                <div>:</div>
                                <span class="minutes" style="font-size: 14px;"></span>
                                <div>:</div>
                                <span class="seconds" style="font-size: 14px;"></span>
                            </div>
                        </div>
                        <script>
                            var diffInSeconds = <?php echo $post->diffinseconds; ?>;
                            var postId = <?php echo $post->id; ?>;
                            function getTimeRemaining(endtime) {
                                var t = Date.parse(endtime) - Date.parse(new Date());
                                var seconds = Math.floor((t / 1000) % 60);
                                var minutes = Math.floor((t / 1000 / 60) % 60);
                                var hours = Math.floor((t / (1000 * 60 * 60)) % 24);
                                var days = Math.floor(t / (1000 * 60 * 60 * 24));
                                return {
                                    'total': t,
                                    'days': days,
                                    'hours': hours,
                                    'minutes': minutes,
                                    'seconds': seconds
                                };
                            }
                        
                            function initializeClock(id, endtime) {
                                var clock = document.getElementById(id);
                                var daysSpan = clock.querySelector('.days');
                                var hoursSpan = clock.querySelector('.hours');
                                var minutesSpan = clock.querySelector('.minutes');
                                var secondsSpan = clock.querySelector('.seconds');
                        
                                function updateClock() {
                                    var t = getTimeRemaining(endtime);
                        
                                    daysSpan.innerHTML = t.days;
                                    hoursSpan.innerHTML = ('0' + t.hours).slice(-2);
                                    minutesSpan.innerHTML = ('0' + t.minutes).slice(-2);
                                    secondsSpan.innerHTML = ('0' + t.seconds).slice(-2);
                        
                                    if (t.total <= 0) {
                                        clearInterval(timeinterval);
                                    }
                                }
                                var timeinterval = setInterval(updateClock, 1000);
                                updateClock();
                            }
                        
                            var deadline = new Date(Date.parse(new Date()) + diffInSeconds * 1000);
                            initializeClock('clockdiv-'+ postId, deadline);
                        </script>
                    <?php else: ?>
                        Teklif Bekleniyor
                    <?php endif; ?>
                    
                </div>
            </div>
            
            <?php if($post->is_fast_buy == 1): ?>
                <div class="new-card-fast-buy">
                    <div>
                        <h4 class="new-card-fast-buy-title">Hemen Al Fiyatı: <?php echo e(number_format($post->fast_buy_price, 0, '.', '.')); ?> &#x20BA;</h4>
                    </div>
                </div>
            <?php endif; ?>
            <div style="max-height: 260px;min-height: 235px;background-color: aliceblue;border-radius: 6px;position: relative;">
                <?php if(file_exists('assets/img/card-logo/'. $post->bank->code .'.png')): ?>
                    <div style="position: absolute;padding:10px;z-index:2;bottom:25px;padding-left:0px;">
                        <div class="rib">
                            <img class="img-fluid" style="width: 75%;height: 30px;object-fit: contain;" src="<?php echo e(asset('assets/img/card-logo/'. $post->bank->code .'.png')); ?>" alt="<?php echo e($post->bank->code); ?>">
                        </div>
                    </div>
                <?php endif; ?>
                <img class="new-card-image-top img-fluid"
                <?php if(isset(Storage::allFiles($post->images_folder)[0])): ?>
                    src="<?php echo e(asset('storage/'.Storage::allFiles($post->images_folder)[0] )); ?>"
                <?php endif; ?> alt="İlan Resmi">
            </div>
            
            
            <div class="new-card-card-body">
                <div class="new-card-div1">
                    <div class="d-flex justify-content-between">
                        <div class="d-flex">
                            <h4 class="new-card-price"><?php echo e(number_format($post->current_price, 0, '.', '.')); ?> </h4> <h4 class="new-card-price">&#x20BA;</h4>
                        </div>
                        <div class="d-flex align-items-center">
                            <h4 class="new-card-property-type">
                                <?php if(isset($post->postable->house_type)): ?>
                                    <?php echo e(config('enums.property_type')[$post->postable->property_type]); ?> - <?php echo e(config('enums.house_type')[$post->postable->house_type]); ?>

                                <?php endif; ?>
                                <?php if(isset($post->postable->workplace_type)): ?>
                                    <?php echo e(config('enums.property_type')[$post->postable->property_type]); ?> - <?php echo e(config('enums.workplace_type')[$post->postable->workplace_type]); ?>

                                <?php endif; ?>
                                <?php if(isset($post->postable->land_type)): ?>
                                    <?php echo e(config('enums.property_type')[$post->postable->property_type]); ?> - <?php echo e(config('enums.land_type')[$post->postable->land_type]); ?>

                                <?php endif; ?>
                            </h4>
                        </div>
                    </div>
                    
                    <h5 class="new-card-title"><?php echo e($post->title); ?></h5>
                </div>

                <hr class="new-card-hr">

                <div style="padding: 0px 18px 0px 18px;">
                    <h6 class="new-card-location">Konum</h6>
                    <h5 class="new-card-location-text"><?php echo e($post->postable->country); ?> - <?php echo e($post->postable->district); ?> - <?php echo e($post->postable->neighborhood); ?></h5>
                </div>

                <hr class="new-card-hr">

                <div class="new-card-div3">
                    <?php if(isset($post->postable->net_m2)): ?>
                        <div>
                            <i class="fas fa-border-style" style="color: #464E5F;"></i> 
                            <span class="new-card-property-span"><?php echo e(number_format($post->postable->net_m2, 0, '.', '.')); ?>m<sup>2</sup></span>
                        </div>
                    <?php endif; ?>
                    <?php if(isset($post->postable->floor)): ?>
                        <div>
                            <i class="fas fa-warehouse" style="color: #464E5F;"></i>
                            <span class="new-card-property-span"><?php echo e(config('enums.floor')[$post->postable->floor]); ?>.Kat</span>
                        </div>
                    <?php endif; ?>
                    <?php if(isset($post->postable->room_count)): ?>
                        <div>
                            <i class="fas fa-columns" style="color: #464E5F;"></i>
                            <span class="new-card-property-span"><?php echo e(config('enums.room_count')[$post->postable->room_count]); ?></span>
                        </div>
                    <?php endif; ?>
                </div>

                <hr class="new-card-hr">

                <div class="new-card-div4">
                    
                    <?php if(isset($post->code)): ?>
                        <div class="d-flex align-items-center mobile-overflow-row">
                            <h5 class="new-card-code-title">İlan Kodu:</h5>
                            <h5 class="new-card-code"><?php echo e($post->code); ?></h5>
                        </div>
                    <?php endif; ?>
                    <div class="d-flex align-items-center mobile-overflow-row">
                        <h5 class="new-card-code-title">İhale Kodu:</h5>
                        <h5 class="new-card-code"><?php echo e($post->tender_code); ?></h5>
                    </div>
                </div>
            </div>
        </div>
    </a>
    <?php if(Auth::user()): ?>
        <?php if(isset($favoritePosts)): ?>
            <span class="btn_compare  j_compare position-absolute text_shadow fa-2x py-1 px-2 btn_favourite 
                <?php if(in_array($post->postable->post->id, $favoritePosts)): ?>
                    active
                <?php endif; ?>" 
                title="<?php if(in_array($post->postable->post->id, $favoritePosts)): ?>
                    Favorilerimden çıkar.
                <?php else: ?>
                    Favorilerime ekle.
                <?php endif; ?>" id = <?php echo e($post->postable->slug); ?> data-slug=<?php echo e($post->postable->slug); ?> data-imovel="108" data-action="addCompare" data-toggle="tooltip" data-placement="top" title="Compare">
                    <i class="fas fa-heart"></i>
            </span>
        <?php endif; ?>
    <?php endif; ?>
    
</article>   <?php /**PATH /var/www/html/propturk/resources/views/new-card/new-card.blade.php ENDPATH**/ ?>